/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;

public class MSVCBuildCommandParser
extends AbstractBuildCommandParser
implements ILanguageSettingsEditableProvider {
    private static final String DOUBLE_BACKSLASH = "\\\\";
    private static final Pattern DOUBLE_BACKSLASH_PATTERN = Pattern.compile(Pattern.quote("\\\\"));
    private static final String BACKSLASH_REPLACEMENT_STRING = "\\\\";
    private static final String BACKSLASH_QUOTE = "\\\"";
    private static final Pattern BACKSLASH_QUOTE_PATTERN = Pattern.compile(Pattern.quote("\\\""));
    private static final String QUOTE_REPLACEMENT_STRING = "\"";
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] includeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCIncludePathOptionParser("(-|/)I\\s*\"(.*)\"", "$2"), new MSVCIncludePathOptionParser("(-|/)I\\s*([^\\s\"]*)", "$2")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] forceIncludeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCForceIncludePathOptionParser("(-|/)FI\\s*\"(.*)\"", "$2"), new MSVCForceIncludePathOptionParser("(-|/)FI\\s*([^\\s\"]*)", "$2")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] msvcIncludeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCIncludePathOptionParser("(-|/)imsvc\\s*\"(.*)\"", "$2"), new MSVCIncludePathOptionParser("(-|/)imsvc\\s*([^\\s\"]*)", "$2")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] clangISystemIncludeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCIncludePathOptionParser("(-|/)clang:-isystem\"(.*)\"", "$2"), new MSVCIncludePathOptionParser("(-|/)clang:-isystem([^\\s\"]*)", "$2")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] defineOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCMacroOptionParser("(-|/)D\\s*\"([^=]+)=(.*)\"", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)=\"(.*?)(?<!\\\\)\"", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)=([^\\s\"][^\\s]*)?", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)", "$2", "1"), new MSVCMacroOptionParser("(-|/)D\\s*\"([^\\s=\"]+)\"", "$2", "1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] undefineOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.MacroOptionParser("(-|/)U\\s*([^\\s=\"]+)", "$2", 32), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("(-|/)U\\s*\"(.*?)\"", "$2", 32)};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] emptyParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[0];
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers;
    private static final String QUOTE = "(\".*?(?<!\\\\)(\\\\\\\\)?\")";
    private static final Pattern OPTIONS_PATTERN;
    private static final int OPTION_GROUP = 0;

    static {
        ArrayList<AbstractLanguageSettingsOutputScanner.AbstractOptionParser> parsers = new ArrayList<AbstractLanguageSettingsOutputScanner.AbstractOptionParser>(Arrays.asList(includeOptionParsers));
        Collections.addAll(parsers, defineOptionParsers);
        Collections.addAll(parsers, msvcIncludeOptionParsers);
        Collections.addAll(parsers, clangISystemIncludeOptionParsers);
        Collections.addAll(parsers, forceIncludeOptionParsers);
        Collections.addAll(parsers, undefineOptionParsers);
        optionParsers = parsers.toArray(new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[0]);
        OPTIONS_PATTERN = Pattern.compile("(-|/)[^\\s\"\\\\]*(\\s*[^-/\\s\"\\\\]*((\".*?(?<!\\\\)(\\\\\\\\)?\")|([^-/\\s][^\\s]+)))?");
    }

    private static String unescapeString(String value) {
        if (value.contains("\\\\")) {
            value = DOUBLE_BACKSLASH_PATTERN.matcher(value).replaceAll("\\\\");
        }
        if (value.contains(BACKSLASH_QUOTE)) {
            value = BACKSLASH_QUOTE_PATTERN.matcher(value).replaceAll(QUOTE_REPLACEMENT_STRING);
        }
        return value;
    }

    protected List<String> parseOptions(String line) {
        if (line == null || this.currentResource == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        Matcher optionMatcher = OPTIONS_PATTERN.matcher(line);
        while (optionMatcher.find()) {
            String option = optionMatcher.group(0);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers(String optionToParse) {
        if (optionToParse.length() <= 1) {
            return emptyParsers;
        }
        String optionName = optionToParse.substring(1);
        if (optionName.startsWith("I")) {
            return includeOptionParsers;
        }
        if (optionName.startsWith("D")) {
            return defineOptionParsers;
        }
        if (optionName.startsWith("imsvc")) {
            return msvcIncludeOptionParsers;
        }
        if (optionName.startsWith("clang")) {
            return clangISystemIncludeOptionParsers;
        }
        if (optionName.startsWith("FI")) {
            return forceIncludeOptionParsers;
        }
        if (optionName.startsWith("U")) {
            return undefineOptionParsers;
        }
        return emptyParsers;
    }

    public MSVCBuildCommandParser cloneShallow() throws CloneNotSupportedException {
        return (MSVCBuildCommandParser)super.cloneShallow();
    }

    public MSVCBuildCommandParser clone() throws CloneNotSupportedException {
        return (MSVCBuildCommandParser)super.clone();
    }

    private static class MSVCForceIncludePathOptionParser
    extends AbstractLanguageSettingsOutputScanner.IncludeFileOptionParser {
        public MSVCForceIncludePathOptionParser(String pattern, String nameExpression) {
            super(pattern, nameExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }

    private static class MSVCIncludePathOptionParser
    extends AbstractLanguageSettingsOutputScanner.IncludePathOptionParser {
        public MSVCIncludePathOptionParser(String pattern, String nameExpression) {
            super(pattern, nameExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }

    private static class MSVCMacroOptionParser
    extends AbstractLanguageSettingsOutputScanner.MacroOptionParser {
        public MSVCMacroOptionParser(String pattern, String nameExpression, String valueExpression) {
            super(pattern, nameExpression, valueExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }
}

