/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl3;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.service.command.events.MITracepointSelectedEvent;
import org.eclipse.cdt.dsf.mi.service.IMIBreakpointPathAdjuster;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MICatchpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIErrorEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIRunningEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISharedLibEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIThreadInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadListIdsInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIRunControl
extends AbstractDsfService
implements IMIRunControl,
ICachingService,
IRunControl3 {
    private ICommandControlService fConnection;
    private CommandCache fMICommandCache;
    private CommandFactory fCommandFactory;
    private boolean fSuspended = true;
    private boolean fResumePending = false;
    private boolean fStepping = false;
    private boolean fTerminated = false;
    protected RunControlEvent<IRunControl.IExecutionDMContext, ?> fLatestEvent = null;
    private IRunControl.StateChangeReason fStateChangeReason;
    private String fStateChangeDetails;
    private IRunControl.IExecutionDMContext fStateChangeTriggeringContext;
    protected boolean fDisableNextRunningEvent;
    protected boolean fDisableNextSignalEvent;
    protected MIStoppedEvent fSilencedSignalEvent;
    private static final String FAKE_THREAD_ID = "0";
    private boolean fTargetAvailable;
    private IRunControl.IExecutionDMContext fExecutionDmc;
    private boolean fOngoingOperation;
    private boolean fCurrentlyExecutingSteps;
    private MultiRequestMonitor<RequestMonitor> fExecuteQueuedOpsStepMonitor;
    private int fNumStepsStillExecuting;
    private LinkedList<TargetAvailableOperationInfo> fOperationsPending = new LinkedList();

    public MIRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIRunControl.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)this.fConnection, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fMICommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fMICommandCache.setContextAvailable((IDMContext)this.fConnection.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public boolean isValid() {
        return true;
    }

    protected boolean isResumePending() {
        return this.fResumePending;
    }

    protected void setResumePending(boolean pending) {
        this.fResumePending = pending;
    }

    protected boolean isTerminated() {
        return this.fTerminated;
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public CommandCache getCache() {
        return this.fMICommandCache;
    }

    protected ICommandControlService getConnection() {
        return this.fConnection;
    }

    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), container, threadId);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunningEvent e) {
        if (this.fDisableNextRunningEvent) {
            this.fDisableNextRunningEvent = false;
            return;
        }
        if (this.fLatestEvent instanceof IRunControl.IResumedDMEvent) {
            return;
        }
        ResumedEvent event = null;
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            IRunControl.IExecutionDMContext triggeringCtx = !((IRunControl.IExecutionDMContext)e.getDMContext()).equals(containerDmc) ? (IRunControl.IExecutionDMContext)e.getDMContext() : null;
            event = new ContainerResumedEvent(containerDmc, e, triggeringCtx);
        } else {
            event = new ResumedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e);
        }
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(final MIStoppedEvent e) {
        if (this.fDisableNextSignalEvent && e instanceof MISignalEvent) {
            this.fDisableNextSignalEvent = false;
            this.fSilencedSignalEvent = e;
            return;
        }
        MIBreakpoints.MIBreakpointDMContext _bp = null;
        if (e instanceof MIBreakpointHitEvent) {
            String bpId = ((MIBreakpointHitEvent)e).getNumber();
            IBreakpoints.IBreakpointsTargetDMContext bpsTarget = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            if (bpsTarget != null && !bpId.isEmpty()) {
                _bp = new MIBreakpoints.MIBreakpointDMContext(this.getSession().getId(), new IDMContext[]{bpsTarget}, bpId);
            }
        }
        final MIBreakpoints.MIBreakpointDMContext bp = _bp;
        SuspendedEvent event = null;
        final IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            IRunControl.IExecutionDMContext triggeringCtx;
            IRunControl.IExecutionDMContext iExecutionDMContext = triggeringCtx = !((IRunControl.IExecutionDMContext)e.getDMContext()).equals(containerDmc) ? (IRunControl.IExecutionDMContext)e.getDMContext() : null;
            if (triggeringCtx == null) {
                this.getConnection().queueCommand(this.fCommandFactory.createCLIThread(containerDmc), (DataRequestMonitor)new DataRequestMonitor<CLIThreadInfo>((Executor)this.getExecutor(), null){

                    protected void handleCompleted() {
                        IMIExecutionDMContext triggeringCtx2 = null;
                        if (this.isSuccess() && ((CLIThreadInfo)this.getData()).getCurrentThread() != null) {
                            triggeringCtx2 = MIRunControl.this.createMIExecutionContext(containerDmc, ((CLIThreadInfo)this.getData()).getCurrentThread());
                        }
                        ContainerSuspendedEvent event2 = bp != null ? new ContainerBreakpointHitEvent(containerDmc, (MIBreakpointHitEvent)e, triggeringCtx2, bp) : new ContainerSuspendedEvent(containerDmc, e, triggeringCtx2);
                        MIRunControl.this.getSession().dispatchEvent((Object)event2, MIRunControl.this.getProperties());
                    }
                });
                return;
            }
            event = bp != null ? new ContainerBreakpointHitEvent(containerDmc, (MIBreakpointHitEvent)e, triggeringCtx, bp) : new ContainerSuspendedEvent(containerDmc, e, triggeringCtx);
        } else {
            event = bp != null ? new BreakpointHitEvent((IRunControl.IExecutionDMContext)e.getDMContext(), (MIBreakpointHitEvent)e, bp) : new SuspendedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e);
        }
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadCreatedEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = e.getStrId() != null ? this.createMIExecutionContext(containerDmc, e.getStrId()) : null;
        this.getSession().dispatchEvent((Object)new StartedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadExitEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = e.getStrId() != null ? this.createMIExecutionContext(containerDmc, e.getStrId()) : null;
        this.getSession().dispatchEvent((Object)new ExitedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerResumedEvent e) {
        this.fSuspended = false;
        this.fResumePending = false;
        this.fStateChangeReason = e.getReason();
        this.fStateChangeDetails = null;
        this.fMICommandCache.setContextAvailable(e.getDMContext(), false);
        this.fLatestEvent = e;
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fStepping = true;
        } else {
            this.fMICommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerSuspendedEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), true);
        this.fMICommandCache.reset();
        this.fStateChangeReason = e.getReason();
        this.fStateChangeDetails = e.getDetails();
        this.fStateChangeTriggeringContext = e.getTriggeringContexts().length != 0 ? e.getTriggeringContexts()[0] : null;
        this.fSuspended = true;
        this.fStepping = false;
        this.fLatestEvent = e;
        this.fResumePending = false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.fTerminated = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(StartedDMEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fMICommandCache.setContextAvailable(e.getDMContext(), true);
            this.fMICommandCache.reset();
            this.fSuspended = true;
            this.fStepping = false;
            this.fResumePending = false;
        } else {
            this.fMICommandCache.reset(e.getDMContext());
        }
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanResume(context));
        rm.done();
    }

    protected boolean doCanResume(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.isSuspended(context) && !this.fResumePending;
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanSuspend(context));
        rm.done();
    }

    private boolean doCanSuspend(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && !this.isSuspended(context);
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.fSuspended;
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.fStepping;
    }

    public void resume(final IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        if (this.doCanResume(context)) {
            ICommand<MIInfo> cmd = null;
            if (context instanceof IRunControl.IContainerDMContext) {
                cmd = this.fCommandFactory.createMIExecContinue(context);
            } else {
                IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + String.valueOf(context) + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = this.fCommandFactory.createMIExecContinue(dmc);
            }
            this.fResumePending = true;
            this.fMICommandCache.setContextAvailable((IDMContext)context, false);
            this.fConnection.queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleFailure() {
                    MIRunControl.this.fResumePending = false;
                    MIRunControl.this.fMICommandCache.setContextAvailable((IDMContext)context, true);
                    super.handleFailure();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + String.valueOf(context) + ", is already running.", null));
            rm.done();
        }
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        if (this.doCanSuspend(context)) {
            ICommand<MIInfo> cmd = null;
            if (context instanceof IRunControl.IContainerDMContext) {
                cmd = this.fCommandFactory.createMIExecInterrupt(context);
            } else {
                IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + String.valueOf(context) + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = this.fCommandFactory.createMIExecInterrupt(dmc);
            }
            this.fConnection.queueCommand(cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + String.valueOf(context) + ", is already suspended.", null));
            rm.done();
        }
    }

    public void canStep(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        if (context instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        this.canResume(context, rm);
    }

    public void step(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        this.step(context, stepType, true, rm);
    }

    protected void step(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, boolean checkCanResume, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + String.valueOf(context) + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (checkCanResume && !this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        ICommand<MIInfo> cmd = null;
        switch (stepType) {
            case STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecStep(dmc, 1);
                break;
            }
            case STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecNext(dmc);
                break;
            }
            case STEP_RETURN: {
                MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
                if (stackService != null) {
                    IStack.IFrameDMContext topFrameDmc = stackService.createFrameDMContext(dmc, 0);
                    cmd = this.fCommandFactory.createMIExecFinish(topFrameDmc);
                    break;
                }
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot create context for command, stack service not available.", null));
                rm.done();
                return;
            }
            case INSTRUCTION_STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecStepInstruction(dmc, 1);
                break;
            }
            case INSTRUCTION_STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecNextInstruction(dmc, 1);
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given step type not supported", null));
                rm.done();
                return;
            }
        }
        this.fResumePending = true;
        this.fStepping = true;
        this.fMICommandCache.setContextAvailable((IDMContext)context, false);
        this.fConnection.queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleFailure() {
                MIRunControl.this.fResumePending = false;
                MIRunControl.this.fStepping = false;
                MIRunControl.this.fMICommandCache.setContextAvailable((IDMContext)context, true);
                super.handleFailure();
            }
        });
    }

    public void getExecutionContexts(final IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fMICommandCache.execute(this.fCommandFactory.createMIThreadListIds(containerDmc), (DataRequestMonitor)new DataRequestMonitor<MIThreadListIdsInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)MIRunControl.this.makeExecutionDMCs(containerDmc, (MIThreadListIdsInfo)this.getData()));
                rm.done();
            }
        });
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerCtx, MIThreadListIdsInfo info) {
        if (info.getStrThreadIds().length == 0) {
            return new IMIExecutionDMContext[]{this.createMIExecutionContext(containerCtx, FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[info.getStrThreadIds().length];
        int i = 0;
        while (i < info.getStrThreadIds().length) {
            executionDmcs[i] = this.createMIExecutionContext(containerCtx, info.getStrThreadIds()[i]);
            ++i;
        }
        return executionDmcs;
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (dmc instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)new ExecutionData(this.fStateChangeReason, this.fStateChangeDetails));
        } else if (dmc instanceof IMIExecutionDMContext) {
            boolean thisThreadCausedStateChange = dmc.equals(this.fStateChangeTriggeringContext);
            IRunControl.StateChangeReason reason = thisThreadCausedStateChange ? this.fStateChangeReason : IRunControl.StateChangeReason.CONTAINER;
            String details = thisThreadCausedStateChange ? this.fStateChangeDetails : null;
            rm.setData((Object)new ExecutionData(reason, details));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Given context: " + String.valueOf(dmc) + " is not an execution context.", null));
        }
        rm.done();
    }

    protected void runToLocation(IRunControl.IExecutionDMContext context, String location, boolean skipBreakpoints, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + String.valueOf(context) + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            this.fResumePending = true;
            this.fMICommandCache.setContextAvailable((IDMContext)dmc, false);
            this.fConnection.queueCommand(this.fCommandFactory.createMIExecUntil(dmc, location), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    protected void resumeAtLocation(IRunControl.IExecutionDMContext context, String location, RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + String.valueOf(context) + " is not an thread execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            this.fResumePending = true;
            this.fMICommandCache.setContextAvailable((IDMContext)dmc, false);
            this.fConnection.queueCommand(this.fCommandFactory.createCLIJump(dmc, location), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleFailure() {
                    MIRunControl.this.fResumePending = false;
                    MIRunControl.this.fMICommandCache.setContextAvailable((IDMContext)dmc, true);
                    super.handleFailure();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    protected boolean isTargetAvailable() {
        return this.fTargetAvailable;
    }

    protected void setTargetAvailable(boolean available) {
        this.fTargetAvailable = available;
    }

    protected IRunControl.IExecutionDMContext getContextToSuspend() {
        return this.fExecutionDmc;
    }

    protected void setContextToSuspend(IRunControl.IExecutionDMContext context) {
        this.fExecutionDmc = context;
    }

    protected boolean isTargetAvailableOperationOngoing() {
        return this.fOngoingOperation;
    }

    protected void setTargetAvailableOperationOngoing(boolean ongoing) {
        this.fOngoingOperation = ongoing;
    }

    protected boolean isCurrentlyExecutingSteps() {
        return this.fCurrentlyExecutingSteps;
    }

    protected void setCurrentlyExecutingSteps(boolean executing) {
        this.fCurrentlyExecutingSteps = executing;
    }

    protected MultiRequestMonitor<RequestMonitor> getExecuteQueuedStepsRM() {
        return this.fExecuteQueuedOpsStepMonitor;
    }

    protected void setExecuteQueuedStepsRM(MultiRequestMonitor<RequestMonitor> rm) {
        this.fExecuteQueuedOpsStepMonitor = rm;
    }

    protected int getNumStepsStillExecuting() {
        return this.fNumStepsStillExecuting;
    }

    protected void setNumStepsStillExecuting(int num) {
        this.fNumStepsStillExecuting = num;
    }

    protected LinkedList<TargetAvailableOperationInfo> getOperationsPending() {
        return this.fOperationsPending;
    }

    protected void executeSteps(final TargetAvailableOperationInfo info) {
        ++this.fNumStepsStillExecuting;
        ImmediateRequestMonitor stepsRm = new ImmediateRequestMonitor(){

            protected void handleCompleted() {
                info.rm.setStatus(this.getStatus());
                info.rm.done();
                MIRunControl.this.fExecuteQueuedOpsStepMonitor.requestMonitorDone((RequestMonitor)this);
                --MIRunControl.this.fNumStepsStillExecuting;
                if (MIRunControl.this.fNumStepsStillExecuting == 0) {
                    MIRunControl.this.fExecuteQueuedOpsStepMonitor.doneAdding();
                }
            }
        };
        this.fExecuteQueuedOpsStepMonitor.add((RequestMonitor)stepsRm);
        this.getExecutor().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)stepsRm){

            public Sequence.Step[] getSteps() {
                return info.steps;
            }
        });
    }

    @Override
    public void executeWithTargetAvailable(IDMContext ctx, Sequence.Step[] steps, RequestMonitor rm) {
        if (!this.fOngoingOperation) {
            this.fOngoingOperation = true;
            this.fOperationsPending.add(new TargetAvailableOperationInfo(ctx, steps, rm));
            final Sequence.Step[] sequenceSteps = new Sequence.Step[]{new IsTargetAvailableStep(ctx), new MakeTargetAvailableStep(), new ExecuteQueuedOperationsStep(), new RestoreTargetStateStep()};
            RequestMonitor sequenceCompletedRm = new RequestMonitor((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    MIRunControl.this.fOngoingOperation = false;
                    if (!MIRunControl.this.fOperationsPending.isEmpty()) {
                        TargetAvailableOperationInfo info = MIRunControl.this.fOperationsPending.removeLast();
                        MIRunControl.this.executeWithTargetAvailable(info.ctx, info.steps, info.rm);
                    }
                }

                protected void handleFailure() {
                    MIRunControl.this.fOngoingOperation = false;
                    while (!MIRunControl.this.fOperationsPending.isEmpty()) {
                        RequestMonitor rm = MIRunControl.this.fOperationsPending.poll().rm;
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                    super.handleFailure();
                }
            };
            this.getExecutor().execute((Runnable)new Sequence(this.getExecutor(), sequenceCompletedRm){

                public Sequence.Step[] getSteps() {
                    return sequenceSteps;
                }
            });
        } else if (this.fCurrentlyExecutingSteps) {
            this.executeSteps(new TargetAvailableOperationInfo(ctx, steps, rm));
        } else {
            this.fOperationsPending.add(new TargetAvailableOperationInfo(ctx, steps, rm));
        }
    }

    public void flushCache(IDMContext context) {
        this.fMICommandCache.reset(context);
    }

    private void moveToLocation(final IRunControl.IExecutionDMContext context, final String location, Map<String, Object> bpAttributes, final RequestMonitor rm) {
        IBreakpoints bpService = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (bpService != null && bpDmc != null) {
            bpService.insertBreakpoint(bpDmc, bpAttributes, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIRunControl.this.resumeAtLocation(context, location, rm);
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Unable to set breakpoint", null));
            rm.done();
        }
    }

    public void canRunToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void runToLine(final IRunControl.IExecutionDMContext context, String sourceFile, final int lineNumber, final boolean skipBreakpoints, final RequestMonitor rm) {
        this.determineDebuggerPath((IDMContext)context, sourceFile, (DataRequestMonitor<String>)new ImmediateDataRequestMonitor<String>(rm){

            protected void handleSuccess() {
                MIRunControl.this.runToLocation(context, (String)this.getData() + ":" + Integer.toString(lineNumber), skipBreakpoints, rm);
            }
        });
    }

    public void canRunToAddress(IRunControl.IExecutionDMContext context, IAddress address, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void runToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean skipBreakpoints, RequestMonitor rm) {
        this.runToLocation(context, "*0x" + address.toString(16), skipBreakpoints, rm);
    }

    public void canMoveToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean resume, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void moveToLine(final IRunControl.IExecutionDMContext context, String sourceFile, final int lineNumber, final boolean resume, final RequestMonitor rm) {
        final IMIExecutionDMContext threadExecDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (threadExecDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Invalid thread context", null));
            rm.done();
        } else {
            this.determineDebuggerPath((IDMContext)context, sourceFile, (DataRequestMonitor<String>)new ImmediateDataRequestMonitor<String>(rm){

                protected void handleSuccess() {
                    String debuggerPath = (String)this.getData();
                    String location = debuggerPath + ":" + lineNumber;
                    if (resume) {
                        MIRunControl.this.resumeAtLocation(context, location, rm);
                    } else {
                        HashMap<String, Object> attr = new HashMap<String, Object>();
                        attr.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
                        attr.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", debuggerPath);
                        attr.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", lineNumber);
                        attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", true);
                        attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", threadExecDmc.getThreadId());
                        MIRunControl.this.moveToLocation(context, location, attr, rm);
                    }
                }
            });
        }
    }

    public void canMoveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void moveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, RequestMonitor rm) {
        IMIExecutionDMContext threadExecDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (threadExecDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Invalid thread context", null));
            rm.done();
        } else {
            String location = "*0x" + address.toString(16);
            if (resume) {
                this.resumeAtLocation(context, location, rm);
            } else {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.address", "0x" + address.toString(16));
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", true);
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", threadExecDmc.getThreadId());
                this.moveToLocation(context, location, attr, rm);
            }
        }
    }

    @Override
    public IMIRunControl.IRunMode getRunMode() {
        return IMIRunControl.MIRunMode.ALL_STOP;
    }

    @Override
    public boolean isTargetAcceptingCommands() {
        return !this.fTerminated && this.fSuspended && !this.fResumePending;
    }

    protected void determineDebuggerPath(IDMContext dmc, String hostPath, final DataRequestMonitor<String> rm) {
        final IBreakpoints breakpoints = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        if (!(breakpoints instanceof IMIBreakpointPathAdjuster)) {
            rm.done((Object)hostPath);
            return;
        }
        ISourceLookup sourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        ISourceLookup.ISourceLookupDMContext srcDmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISourceLookup.ISourceLookupDMContext.class);
        if (sourceLookup == null || srcDmc == null) {
            rm.done((Object)((IMIBreakpointPathAdjuster)breakpoints).adjustDebuggerPath(hostPath));
            return;
        }
        sourceLookup.getDebuggerPath(srcDmc, (Object)hostPath, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.done((Object)((IMIBreakpointPathAdjuster)breakpoints).adjustDebuggerPath((String)this.getData()));
            }
        });
    }

    public void canStepIntoSelection(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, IFunctionDeclaration selectedFunction, DataRequestMonitor<Boolean> rm) {
        rm.done((Object)false);
    }

    public void stepIntoSelection(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean skipBreakpoints, IFunctionDeclaration selectedFunction, RequestMonitor rm) {
        Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Step Into Selection not supported", null);
        rm.done((IStatus)status);
    }

    @Immutable
    protected static class BreakpointHitEvent
    extends SuspendedEvent
    implements IBreakpointsExtension.IBreakpointHitDMEvent {
        private final IBreakpoints.IBreakpointDMContext[] fBreakpoints;

        BreakpointHitEvent(IRunControl.IExecutionDMContext ctx, MIBreakpointHitEvent miInfo, IBreakpoints.IBreakpointDMContext bpCtx) {
            super(ctx, miInfo);
            this.fBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bpCtx};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.fBreakpoints;
        }
    }

    @Immutable
    protected static class ContainerBreakpointHitEvent
    extends ContainerSuspendedEvent
    implements IBreakpointsExtension.IBreakpointHitDMEvent {
        private final IBreakpoints.IBreakpointDMContext[] fBreakpoints;

        ContainerBreakpointHitEvent(IRunControl.IContainerDMContext containerDmc, MIBreakpointHitEvent miInfo, IRunControl.IExecutionDMContext triggeringDmc, IBreakpoints.IBreakpointDMContext bpCtx) {
            super(containerDmc, miInfo, triggeringDmc);
            this.fBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bpCtx};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.fBreakpoints;
        }
    }

    @Immutable
    protected static class ContainerResumedEvent
    extends ResumedEvent
    implements IRunControl.IContainerResumedDMEvent {
        final IRunControl.IExecutionDMContext[] triggeringDmcs;

        ContainerResumedEvent(IRunControl.IContainerDMContext containerDmc, MIRunningEvent miInfo, IRunControl.IExecutionDMContext triggeringDmc) {
            super((IRunControl.IExecutionDMContext)containerDmc, miInfo);
            IRunControl.IExecutionDMContext[] iExecutionDMContextArray;
            if (triggeringDmc != null) {
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray2 = new IRunControl.IExecutionDMContext[1];
                iExecutionDMContextArray = iExecutionDMContextArray2;
                iExecutionDMContextArray2[0] = triggeringDmc;
            } else {
                iExecutionDMContextArray = new IRunControl.IExecutionDMContext[]{};
            }
            this.triggeringDmcs = iExecutionDMContextArray;
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return this.triggeringDmcs;
        }
    }

    @Immutable
    protected static class ContainerSuspendedEvent
    extends SuspendedEvent
    implements IRunControl.IContainerSuspendedDMEvent {
        final IRunControl.IExecutionDMContext[] triggeringDmcs;

        ContainerSuspendedEvent(IRunControl.IContainerDMContext containerDmc, MIStoppedEvent miInfo, IRunControl.IExecutionDMContext triggeringDmc) {
            super((IRunControl.IExecutionDMContext)containerDmc, miInfo);
            IRunControl.IExecutionDMContext[] iExecutionDMContextArray;
            if (triggeringDmc != null) {
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray2 = new IRunControl.IExecutionDMContext[1];
                iExecutionDMContextArray = iExecutionDMContextArray2;
                iExecutionDMContextArray2[0] = triggeringDmc;
            } else {
                iExecutionDMContextArray = new IRunControl.IExecutionDMContext[]{};
            }
            this.triggeringDmcs = iExecutionDMContextArray;
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return this.triggeringDmcs;
        }
    }

    protected class ExecuteQueuedOperationsStep
    extends Sequence.Step {
        public void execute(final RequestMonitor rm) {
            MIRunControl.this.fCurrentlyExecutingSteps = true;
            MIRunControl.this.fExecuteQueuedOpsStepMonitor = new MultiRequestMonitor<RequestMonitor>(ImmediateExecutor.getInstance(), rm){

                protected void handleCompleted() {
                    if (!$assertionsDisabled && ((ExecuteQueuedOperationsStep)ExecuteQueuedOperationsStep.this).MIRunControl.this.fOperationsPending.size() != 0) {
                        throw new AssertionError();
                    }
                    ((ExecuteQueuedOperationsStep)ExecuteQueuedOperationsStep.this).MIRunControl.this.fCurrentlyExecutingSteps = false;
                    rm.done();
                }
            };
            MIRunControl.this.fExecuteQueuedOpsStepMonitor.requireDoneAdding();
            while (!MIRunControl.this.fOperationsPending.isEmpty()) {
                MIRunControl.this.executeSteps(MIRunControl.this.fOperationsPending.poll());
            }
        }
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData2 {
        private final IRunControl.StateChangeReason fReason;
        private final String fDetails;

        ExecutionData(IRunControl.StateChangeReason reason, String details) {
            this.fReason = reason;
            this.fDetails = details;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.fReason;
        }

        public String getDetails() {
            return this.fDetails;
        }
    }

    @Immutable
    protected static class ExitedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadExitEvent>
    implements IRunControl.IExitedDMEvent {
        ExitedDMEvent(IMIExecutionDMContext executionDmc, MIThreadExitEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    protected class IsTargetAvailableStep
    extends Sequence.Step {
        final IDMContext fCtx;

        public IsTargetAvailableStep(IDMContext ctx) {
            this.fCtx = ctx;
        }

        public void execute(final RequestMonitor rm) {
            MIRunControl.this.fExecutionDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCtx, IMIContainerDMContext.class);
            if (MIRunControl.this.fExecutionDmc != null) {
                MIRunControl.this.fTargetAvailable = MIRunControl.this.isSuspended(MIRunControl.this.fExecutionDmc);
                rm.done();
                return;
            }
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCtx, ICommandControlService.ICommandControlDMContext.class);
            IProcesses processControl = (IProcesses)MIRunControl.this.getServicesTracker().getService(IProcesses.class);
            processControl.getProcessesBeingDebugged((IDMContext)controlDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)MIRunControl.this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (!$assertionsDisabled && this.getData() == null) {
                        throw new AssertionError();
                    }
                    if (((IDMContext[])this.getData()).length == 0) {
                        ((IsTargetAvailableStep)IsTargetAvailableStep.this).MIRunControl.this.fTargetAvailable = true;
                    } else {
                        ((IsTargetAvailableStep)IsTargetAvailableStep.this).MIRunControl.this.fExecutionDmc = (IRunControl.IExecutionDMContext)((IDMContext[])this.getData())[0];
                        ((IsTargetAvailableStep)IsTargetAvailableStep.this).MIRunControl.this.fTargetAvailable = MIRunControl.this.isSuspended(((IsTargetAvailableStep)IsTargetAvailableStep.this).MIRunControl.this.fExecutionDmc);
                    }
                    rm.done();
                }
            });
        }
    }

    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc != null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = containerDmc;
            } else {
                iDMContextArray = new IDMContext[]{};
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        @Override
        public String getThreadId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return super.baseHashCode() + this.fThreadId.hashCode();
        }
    }

    protected class MakeTargetAvailableStep
    extends Sequence.Step {
        public void execute(RequestMonitor rm) {
            if (!MIRunControl.this.isTargetAvailable()) {
                assert (!MIRunControl.this.fDisableNextRunningEvent);
                assert (!MIRunControl.this.fDisableNextSignalEvent);
                MIRunControl.this.fDisableNextSignalEvent = true;
                MIRunControl.this.suspend(MIRunControl.this.getContextToSuspend(), new RequestMonitor((Executor)MIRunControl.this.getExecutor(), rm){

                    protected void handleFailure() {
                        ((MakeTargetAvailableStep)MakeTargetAvailableStep.this).MIRunControl.this.fDisableNextSignalEvent = false;
                        super.handleFailure();
                    }
                });
            } else {
                rm.done();
            }
        }

        public void rollBack(RequestMonitor rm) {
            RestoreTargetStateStep restoreStep = new RestoreTargetStateStep();
            restoreStep.execute(rm);
        }
    }

    protected class RestoreTargetStateStep
    extends Sequence.Step {
        public void execute(RequestMonitor rm) {
            if (!MIRunControl.this.isTargetAvailable()) {
                assert (!MIRunControl.this.fDisableNextRunningEvent);
                MIRunControl.this.fDisableNextRunningEvent = true;
                MIRunControl.this.fConnection.queueCommand(MIRunControl.this.fCommandFactory.createMIExecContinue(MIRunControl.this.getContextToSuspend()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIRunControl.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        ((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fSilencedSignalEvent = null;
                        super.handleSuccess();
                    }

                    protected void handleFailure() {
                        ((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fDisableNextRunningEvent = false;
                        if (((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fSilencedSignalEvent != null) {
                            MIRunControl.this.eventDispatched(((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fSilencedSignalEvent);
                            ((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fSilencedSignalEvent = null;
                        } else {
                            ((RestoreTargetStateStep)RestoreTargetStateStep.this).MIRunControl.this.fDisableNextSignalEvent = false;
                        }
                        super.handleFailure();
                    }
                });
            } else {
                rm.done();
            }
        }
    }

    @Immutable
    protected static class ResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIRunningEvent>
    implements IRunControl.IResumedDMEvent {
        ResumedEvent(IRunControl.IExecutionDMContext ctx, MIRunningEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((MIRunningEvent)((Object)this.getMIEvent())).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    @Immutable
    protected static class RunControlEvent<V extends IDMContext, T extends MIEvent<? extends IDMContext>>
    extends AbstractDMEvent<V>
    implements IMIDMEvent {
        private final T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    @Immutable
    protected static class StartedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadCreatedEvent>
    implements IRunControl.IStartedDMEvent {
        StartedDMEvent(IMIExecutionDMContext executionDmc, MIThreadCreatedEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    @Immutable
    protected static class SuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIStoppedEvent>
    implements IRunControl.ISuspendedDMEvent {
        SuspendedEvent(IRunControl.IExecutionDMContext ctx, MIStoppedEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof MICatchpointHitEvent) {
                return IRunControl.StateChangeReason.EVENT_BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MITracepointSelectedEvent) {
                return IRunControl.StateChangeReason.UNKNOWN;
            }
            if (this.getMIEvent() instanceof MIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof MIFunctionFinishedEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof MISharedLibEvent) {
                return IRunControl.StateChangeReason.SHAREDLIB;
            }
            if (this.getMIEvent() instanceof MISignalEvent) {
                return IRunControl.StateChangeReason.SIGNAL;
            }
            if (this.getMIEvent() instanceof MIWatchpointTriggerEvent) {
                return IRunControl.StateChangeReason.WATCHPOINT;
            }
            if (this.getMIEvent() instanceof MIErrorEvent) {
                return IRunControl.StateChangeReason.ERROR;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }

        public String getDetails() {
            MIStoppedEvent event = (MIStoppedEvent)((Object)this.getMIEvent());
            if (event instanceof MICatchpointHitEvent) {
                return ((MICatchpointHitEvent)event).getReason();
            }
            if (event instanceof MITracepointSelectedEvent) {
                return ((MITracepointSelectedEvent)event).getReason();
            }
            if (event instanceof MISharedLibEvent) {
                return ((MISharedLibEvent)event).getLibrary();
            }
            if (event instanceof MISignalEvent) {
                return ((MISignalEvent)event).getName() + ":" + ((MISignalEvent)event).getMeaning();
            }
            if (event instanceof MIWatchpointTriggerEvent) {
                return ((MIWatchpointTriggerEvent)event).getExpression();
            }
            if (event instanceof MIErrorEvent) {
                return ((MIErrorEvent)event).getMessage();
            }
            return null;
        }
    }

    protected static class TargetAvailableOperationInfo {
        public IDMContext ctx;
        public Sequence.Step[] steps;
        public RequestMonitor rm;

        public TargetAvailableOperationInfo(IDMContext ctx, Sequence.Step[] steps, RequestMonitor rm) {
            this.ctx = ctx;
            this.steps = steps;
            this.rm = rm;
        }
    }
}

