/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Reservations;
import org.mandas.docker.client.messages.swarm.ResourceSpec;

final class ImmutableReservations
implements Reservations {
    @Nullable
    private final Long nanoCpus;
    @Nullable
    private final Long memoryBytes;
    @Nullable
    private final List<ResourceSpec> resources;

    private ImmutableReservations(@Nullable Long nanoCpus, @Nullable Long memoryBytes, @Nullable List<ResourceSpec> resources) {
        this.nanoCpus = nanoCpus;
        this.memoryBytes = memoryBytes;
        this.resources = resources;
    }

    @Override
    @JsonProperty(value="NanoCPUs")
    @Nullable
    public Long nanoCpus() {
        return this.nanoCpus;
    }

    @Override
    @JsonProperty(value="MemoryBytes")
    @Nullable
    public Long memoryBytes() {
        return this.memoryBytes;
    }

    @Override
    @JsonProperty(value="GenericResources")
    @Nullable
    public List<ResourceSpec> resources() {
        return this.resources;
    }

    public final ImmutableReservations withNanoCpus(@Nullable Long value) {
        if (Objects.equals(this.nanoCpus, value)) {
            return this;
        }
        return new ImmutableReservations(value, this.memoryBytes, this.resources);
    }

    public final ImmutableReservations withMemoryBytes(@Nullable Long value) {
        if (Objects.equals(this.memoryBytes, value)) {
            return this;
        }
        return new ImmutableReservations(this.nanoCpus, value, this.resources);
    }

    public final ImmutableReservations withResources(ResourceSpec ... elements) {
        if (elements == null) {
            return new ImmutableReservations(this.nanoCpus, this.memoryBytes, null);
        }
        List<ResourceSpec> newValue = Arrays.asList(elements) == null ? null : ImmutableReservations.createUnmodifiableList(false, ImmutableReservations.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReservations(this.nanoCpus, this.memoryBytes, newValue);
    }

    public final ImmutableReservations withResources(@Nullable Iterable<? extends ResourceSpec> elements) {
        if (this.resources == elements) {
            return this;
        }
        List<ResourceSpec> newValue = elements == null ? null : ImmutableReservations.createUnmodifiableList(false, ImmutableReservations.createSafeList(elements, true, false));
        return new ImmutableReservations(this.nanoCpus, this.memoryBytes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReservations && this.equalTo(0, (ImmutableReservations)another);
    }

    private boolean equalTo(int synthetic, ImmutableReservations another) {
        return Objects.equals(this.nanoCpus, another.nanoCpus) && Objects.equals(this.memoryBytes, another.memoryBytes) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nanoCpus);
        h += (h << 5) + Objects.hashCode(this.memoryBytes);
        h += (h << 5) + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "Reservations{nanoCpus=" + this.nanoCpus + ", memoryBytes=" + this.memoryBytes + ", resources=" + this.resources + "}";
    }

    public static ImmutableReservations copyOf(Reservations instance) {
        if (instance instanceof ImmutableReservations) {
            return (ImmutableReservations)instance;
        }
        return ImmutableReservations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements Reservations.Builder {
        private Long nanoCpus;
        private Long memoryBytes;
        private List<ResourceSpec> resources = null;

        private Builder() {
        }

        public final Builder from(Reservations instance) {
            List<ResourceSpec> resourcesValue;
            Long memoryBytesValue;
            Objects.requireNonNull(instance, "instance");
            Long nanoCpusValue = instance.nanoCpus();
            if (nanoCpusValue != null) {
                this.nanoCpus(nanoCpusValue);
            }
            if ((memoryBytesValue = instance.memoryBytes()) != null) {
                this.memoryBytes(memoryBytesValue);
            }
            if ((resourcesValue = instance.resources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="NanoCPUs")
        public final Builder nanoCpus(@Nullable Long nanoCpus) {
            this.nanoCpus = nanoCpus;
            return this;
        }

        @Override
        @JsonProperty(value="MemoryBytes")
        public final Builder memoryBytes(@Nullable Long memoryBytes) {
            this.memoryBytes = memoryBytes;
            return this;
        }

        public final Builder resource(ResourceSpec element) {
            if (this.resources == null) {
                this.resources = new ArrayList<ResourceSpec>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(ResourceSpec ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<ResourceSpec>();
            }
            for (ResourceSpec element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="GenericResources")
        public final Builder resources(@Nullable Iterable<? extends ResourceSpec> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<ResourceSpec>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends ResourceSpec> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<ResourceSpec>();
            }
            for (ResourceSpec resourceSpec : elements) {
                this.resources.add(Objects.requireNonNull(resourceSpec, "resources element"));
            }
            return this;
        }

        @Override
        public ImmutableReservations build() {
            return new ImmutableReservations(this.nanoCpus, this.memoryBytes, this.resources == null ? null : ImmutableReservations.createUnmodifiableList(true, this.resources));
        }
    }
}

