import type { Connection } from '@volar/language-server';
import { GetLanguagePlugin } from './lib/hybridModeProject';
export declare const connection: Connection;
export declare const server: {
    connection: Connection;
    initializeParams: import("@volar/language-server").VolarInitializeParams;
    languageServicePlugins: import("@volar/language-server").LanguageServicePlugin<any>[];
    projects: import("@volar/language-server").ServerProjectProvider;
    fs: import("@volar/language-server").FileSystem;
    semanticTokensLegend: import("@volar/language-server").SemanticTokensLegend;
    pullModelDiagnostics: boolean;
    documents: import("@volar/language-server").TextDocuments<import("@volar/language-server/node").SnapshotDocument>;
    uriConverter: {
        uriToFileName: (uri: string, parsed?: import("vscode-uri").URI | undefined) => string;
        fileNameToUri: (fileName: string) => string;
    };
    workspaceFolders: {
        clear: () => void;
        values: () => IterableIterator<boolean>;
        keys: () => Generator<import("vscode-uri").URI, void, unknown>;
        delete: (uri: import("vscode-uri").URI) => boolean;
        get: (uri: import("vscode-uri").URI) => boolean | undefined;
        has: (uri: import("vscode-uri").URI) => boolean;
        set: (uri: import("vscode-uri").URI, item: boolean) => Map<string, boolean>;
    };
    initialize: (initializeParams: import("@volar/language-server").VolarInitializeParams, languageServicePlugins: import("@volar/language-server").LanguageServicePlugin<any>[], projects: import("@volar/language-server").ServerProjectProvider, options?: {
        semanticTokensLegend?: import("@volar/language-server").SemanticTokensLegend | undefined;
        pullModelDiagnostics?: boolean | undefined;
    } | undefined) => import("@volar/language-server").InitializeResult<any>;
    initialized: () => void;
    shutdown: () => Promise<void>;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string | undefined) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: import("@volar/language-server").NotificationHandler<import("@volar/language-server").DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: import("@volar/language-server").NotificationHandler<import("@volar/language-server").DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: import("@volar/language-server").ServerProjectProvider) => Promise<void>;
};
export declare const getLanguagePlugins: GetLanguagePlugin;
