"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTemplateCodegenContext = void 0;
const common_1 = require("../common");
const _codeFeatures = {
    all: {
        verification: true,
        completion: true,
        semantic: true,
        navigation: true,
    },
    verification: {
        verification: true,
    },
    completion: {
        completion: true,
    },
    additionalCompletion: {
        completion: { isAdditional: true },
    },
    navigation: {
        navigation: true,
    },
    navigationWithoutRename: {
        navigation: {
            shouldRename() {
                return false;
            },
        },
    },
    navigationAndCompletion: {
        navigation: true,
        completion: true,
    },
    navigationAndAdditionalCompletion: {
        navigation: true,
        completion: { isAdditional: true },
    },
    withoutHighlight: {
        semantic: { shouldHighlight: () => false },
        verification: true,
        navigation: true,
        completion: true,
    },
    withoutHighlightAndCompletion: {
        semantic: { shouldHighlight: () => false },
        verification: true,
        navigation: true,
    },
    withoutHighlightAndCompletionAndNavigation: {
        semantic: { shouldHighlight: () => false },
        verification: true,
    },
};
function createTemplateCodegenContext(scriptSetupBindingNames) {
    let ignoredError = false;
    let expectErrorToken;
    let variableId = 0;
    const codeFeatures = new Proxy(_codeFeatures, {
        get(target, key) {
            const data = target[key];
            if (data.verification) {
                if (ignoredError) {
                    return {
                        ...data,
                        verification: false,
                    };
                }
                if (expectErrorToken) {
                    const token = expectErrorToken;
                    if (typeof data.verification !== 'object' || !data.verification.shouldReport) {
                        return {
                            ...data,
                            verification: {
                                shouldReport: () => {
                                    token.errors++;
                                    return false;
                                },
                            },
                        };
                    }
                }
            }
            return data;
        },
    });
    const localVars = new Map();
    const accessExternalVariables = new Map();
    const slots = [];
    const dynamicSlots = [];
    const hasSlotElements = new Set();
    ;
    const blockConditions = [];
    const usedComponentCtxVars = new Set();
    const scopedClasses = [];
    const emptyClassOffsets = [];
    return {
        slots,
        dynamicSlots,
        codeFeatures,
        accessExternalVariables,
        hasSlotElements,
        blockConditions,
        usedComponentCtxVars,
        scopedClasses,
        emptyClassOffsets,
        hasSlot: false,
        accessExternalVariable(name, offset) {
            let arr = accessExternalVariables.get(name);
            if (!arr) {
                accessExternalVariables.set(name, arr = new Set());
            }
            if (offset !== undefined) {
                arr.add(offset);
            }
        },
        hasLocalVariable: (name) => {
            return !!localVars.get(name);
        },
        addLocalVariable: (name) => {
            localVars.set(name, (localVars.get(name) ?? 0) + 1);
        },
        removeLocalVariable: (name) => {
            localVars.set(name, localVars.get(name) - 1);
        },
        getInternalVariable: () => {
            return `__VLS_${variableId++}`;
        },
        ignoreError: function* () {
            if (!ignoredError) {
                ignoredError = true;
                yield `// @vue-ignore start${common_1.newLine}`;
            }
        },
        expectError: function* (prevNode) {
            if (!expectErrorToken) {
                expectErrorToken = {
                    errors: 0,
                    node: prevNode,
                };
                yield `// @vue-expect-error start${common_1.newLine}`;
            }
        },
        resetDirectiveComments: function* (endStr) {
            if (expectErrorToken) {
                const token = expectErrorToken;
                yield* (0, common_1.wrapWith)(expectErrorToken.node.loc.start.offset, expectErrorToken.node.loc.end.offset, {
                    verification: {
                        shouldReport: () => token.errors === 0,
                    },
                }, `// @ts-expect-error __VLS_TS_EXPECT_ERROR`);
                yield `${common_1.newLine}${common_1.endOfLine}`;
                expectErrorToken = undefined;
                yield `// @vue-expect-error ${endStr}${common_1.newLine}`;
            }
            if (ignoredError) {
                ignoredError = false;
                yield `// @vue-ignore ${endStr}${common_1.newLine}`;
            }
        },
        generateAutoImportCompletion: function* () {
            const all = [...accessExternalVariables.entries()];
            if (!all.some(([_, offsets]) => offsets.size)) {
                return;
            }
            yield `// @ts-ignore${common_1.newLine}`; // #2304
            yield `[`;
            for (const [varName, offsets] of all) {
                for (const offset of offsets) {
                    if (scriptSetupBindingNames.has(varName)) {
                        // #3409
                        yield [
                            varName,
                            'template',
                            offset,
                            {
                                ...codeFeatures.additionalCompletion,
                                ...codeFeatures.withoutHighlightAndCompletionAndNavigation,
                            },
                        ];
                    }
                    else {
                        yield [
                            varName,
                            'template',
                            offset,
                            codeFeatures.additionalCompletion,
                        ];
                    }
                    yield `,`;
                }
                offsets.clear();
            }
            yield `]${common_1.endOfLine}`;
        }
    };
}
exports.createTemplateCodegenContext = createTemplateCodegenContext;
//# sourceMappingURL=context.js.map