/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs.factory;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryEditCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryAbstractDialog;
import org.eclipse.wb.internal.core.editor.palette.model.entry.FactoryEntryInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;

public final class FactoryEditDialog
extends FactoryAbstractDialog {
    private final FactoryEntryInfo m_entry;

    public FactoryEditDialog(Shell parentShell, AstEditor editor, boolean forStatic, FactoryEntryInfo entry) {
        super(parentShell, editor, forStatic, forStatic ? Messages.FactoryEditDialog_titleStatic : Messages.FactoryEditDialog_titleInstance, forStatic ? Messages.FactoryEditDialog_messageStatic : Messages.FactoryEditDialog_messageInstance);
        this.m_entry = entry;
    }

    @Override
    protected void createControls(Composite container) {
        super.createControls(container);
        this.m_nameField.setText(this.m_entry.getName());
        this.m_factoryClassField.setText(this.m_entry.getFactoryClassName());
        this.m_methodSignatureField.setText(this.m_entry.getMethodSignature());
        this.m_descriptionField.setText(this.m_entry.getDescription());
        this.m_visibleField.setSelection(this.m_entry.isVisible());
    }

    @Override
    protected Command createCommand() {
        String name = this.m_nameField.getText().trim();
        String description = this.getDescriptionText();
        String factoryClassName = this.m_factoryClassField.getText();
        String methodSignature = this.m_methodSignatureField.getText();
        return new FactoryEditCommand(this.m_entry.getId(), name, description, this.m_visibleField.getSelection(), factoryClassName, methodSignature, this.m_forStatic);
    }
}

