/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.aggregators;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;

public class ExtremumOperator<T extends Comparable<T>>
implements IMultisetAggregationOperator<T, SortedMap<T, Integer>, T> {
    private static final ExtremumOperator MIN_OP = new ExtremumOperator(Extreme.MIN);
    private static final ExtremumOperator MAX_OP = new ExtremumOperator(Extreme.MAX);
    Extreme extreme;

    public static <T extends Comparable<T>> ExtremumOperator<T> getMin() {
        return MIN_OP;
    }

    public static <T extends Comparable<T>> ExtremumOperator<T> getMax() {
        return MAX_OP;
    }

    private ExtremumOperator(Extreme extreme) {
        this.extreme = extreme;
    }

    @Override
    public String getShortDescription() {
        String opName = this.getName();
        return String.format("%s incrementally computes the %simum of java.lang.Comparable values, using the default comparison", opName, opName);
    }

    @Override
    public String getName() {
        return this.extreme.name().toLowerCase();
    }

    @Override
    public SortedMap<T, Integer> createNeutral() {
        return new TreeMap();
    }

    @Override
    public boolean isNeutral(SortedMap<T, Integer> result) {
        return result.isEmpty();
    }

    @Override
    public SortedMap<T, Integer> update(SortedMap<T, Integer> oldResult, T updateValue, boolean isInsertion) {
        oldResult.compute(updateValue, (value, c) -> {
            int count2 = c == null ? 0 : c;
            int result = isInsertion ? count2 + 1 : count2 - 1;
            return result == 0 ? null : Integer.valueOf(result);
        });
        return oldResult;
    }

    @Override
    public T getAggregate(SortedMap<T, Integer> result) {
        return (T)(result.isEmpty() ? null : (Comparable)this.extreme.pickFrom(result));
    }

    @Override
    public T aggregateStream(Stream<T> stream) {
        switch (this.extreme) {
            case MIN: {
                return (T)((Comparable)stream.min(Comparator.naturalOrder()).orElse(null));
            }
            case MAX: {
                return (T)((Comparable)stream.max(Comparator.naturalOrder()).orElse(null));
            }
        }
        return null;
    }

    @Override
    public SortedMap<T, Integer> clone(SortedMap<T, Integer> original) {
        return new TreeMap<T, Integer>(original);
    }

    public static enum Extreme {
        MIN,
        MAX;


        public <T> T pickFrom(SortedMap<T, Integer> nonEmptyMultiSet) {
            switch (this) {
                case MIN: {
                    return nonEmptyMultiSet.firstKey();
                }
                case MAX: {
                    return nonEmptyMultiSet.lastKey();
                }
            }
            return null;
        }
    }
}

