/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

final class DocumentInputStream
extends InputStream {
    private final IDocument doc;
    private int pos = 0;

    DocumentInputStream(IDocument document) {
        this.doc = document;
    }

    @Override
    public int read(@NonNullByDefault(value={}) byte[] buff, int buffOffset, int len) throws IOException {
        Objects.checkFromIndexSize(buffOffset, len, buff.length);
        if (len == 0) {
            return 0;
        }
        int docLen = this.doc.getLength();
        if (this.pos >= docLen) {
            return -1;
        }
        int bytesRead = -1;
        try {
            buff[buffOffset] = (byte)this.doc.getChar(this.pos++);
            bytesRead = 1;
            while (bytesRead < len) {
                if (this.pos < docLen) {
                    buff[buffOffset + bytesRead++] = (byte)this.doc.getChar(this.pos++);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.pos < this.doc.getLength()) {
                return this.doc.getChar(this.pos++) & 0xFF;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }
}

