/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.IOException;
import java.net.URL;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.CommandCatalog;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.Option;

@Command(usage="usage_displayAListOfAllRegisteredJgitCommands")
class ShowCommands
extends TextBuiltin {
    @Option(name="--pretty", metaVar="metaVar_commandDetail", usage="usage_alterTheDetailShown")
    private Format pretty = Format.USAGE;

    ShowCommands() {
    }

    @Override
    protected void run() throws Exception {
        CommandRef c;
        CommandRef[] list = CommandCatalog.all();
        int width = 0;
        CommandRef[] commandRefArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            c = commandRefArray[n2];
            width = Math.max(width, c.getName().length());
            ++n2;
        }
        width += 2;
        commandRefArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            c = commandRefArray[n2];
            this.errw.print(c.isCommon() ? (char)'*' : ' ');
            this.errw.print(' ');
            this.errw.print((Object)c.getName());
            int i = c.getName().length();
            while (i < width) {
                this.errw.print(' ');
                ++i;
            }
            this.pretty.print(this.errw, c);
            this.errw.println();
            ++n2;
        }
        this.errw.println();
    }

    static enum Format {
        USAGE{

            @Override
            void print(ThrowingPrintWriter err, CommandRef c) throws IOException {
                String usage = c.getUsage();
                if (usage != null && usage.length() > 0) {
                    err.print((Object)CLIText.get().resourceBundle().getString(usage));
                }
            }
        }
        ,
        CLASSES{

            @Override
            void print(ThrowingPrintWriter err, CommandRef c) throws IOException {
                err.print((Object)c.getImplementationClassName());
            }
        }
        ,
        URLS{

            @Override
            void print(ThrowingPrintWriter err, CommandRef c) throws IOException {
                ClassLoader ldr = c.getImplementationClassLoader();
                Object cn = c.getImplementationClassName();
                URL url = ldr.getResource((String)(cn = ((String)cn).replace('.', '/') + ".class"));
                if (url == null) {
                    err.print((Object)CLIText.get().notFound);
                    return;
                }
                String rn = url.toExternalForm();
                if (rn.endsWith((String)cn)) {
                    rn = rn.substring(0, rn.length() - ((String)cn).length());
                }
                err.print((Object)rn);
            }
        };


        abstract void print(ThrowingPrintWriter var1, CommandRef var2) throws IOException;
    }
}

