/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.makestatic;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class InitialConditionsChecker {
    private RefactoringStatus fStatus;

    public InitialConditionsChecker(RefactoringStatus status) {
        this.fStatus = status;
    }

    public boolean checkValidTextSelectionStart(Selection selection) {
        if (selection.getOffset() < 0 || selection.getLength() < 0) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_this_selection));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkValidICompilationUnit(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_this_selection));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkASTNodeIsValidMethod(ASTNode selectedNode) {
        if (selectedNode == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_this_selection));
        } else if (selectedNode instanceof SuperMethodInvocation) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_super_method_invocations));
        }
        if (!(selectedNode instanceof MethodDeclaration) && !(selectedNode instanceof MethodInvocation)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_this_selection));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkValidIMethod(IMethod iMethod) throws JavaModelException {
        if (iMethod == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_this_selection));
        } else if (iMethod.getDeclaringType().isAnnotation()) {
            this.fStatus.addFatalError(RefactoringCoreMessages.MakeStaticRefactoring_not_available_on_annotation);
        }
        return !this.fStatus.hasError();
    }

    public boolean checkMethodNotInLocalOrAnonymousClass(IMethod iMethod) throws JavaModelException {
        if (iMethod.getDeclaringType().isLocal() || iMethod.getDeclaringType().isAnonymous()) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_local_or_anonymous_types));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkMethodIsNotConstructor(IMethod iMethod) throws JavaModelException {
        if (iMethod.isConstructor()) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_constructors));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkMethodNotStatic(IMethod iMethod) throws JavaModelException {
        int flags = iMethod.getFlags();
        if (Modifier.isStatic((int)flags)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_method_already_static));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkMethodNotOverridden(IMethod iMethod) throws JavaModelException {
        if (this.isOverridden(iMethod.getDeclaringType(), iMethod)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_method_is_overridden_in_subtype));
        }
        return !this.fStatus.hasError();
    }

    public boolean checkSourceAvailable(IMethod iMethod) {
        if (iMethod.getCompilationUnit() == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_source_not_available_for_selected_method));
        }
        return !this.fStatus.hasError();
    }

    private boolean isOverridden(IType type, IMethod iMethod) throws JavaModelException {
        IType[] subtypes;
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] iTypeArray = subtypes = hierarchy.getAllSubtypes(type);
        int n = subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod[] methods;
            IType subtype = iTypeArray[n2];
            IMethod[] iMethodArray = methods = subtype.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                int flags;
                IMethod method = iMethodArray[n4];
                if (!(!method.isSimilar(iMethod) || Flags.isPrivate((int)(flags = method.getFlags())) && Flags.isStatic((int)flags))) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

