/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;

public class RevealConflictingDiffsAction
extends Action {
    private final StructuredViewer viewer;
    private final Diff selectedDiff;
    private final IEMFCompareConfiguration compareConfiguration;

    public RevealConflictingDiffsAction(StructuredViewer viewer, Diff selectedDiff, IEMFCompareConfiguration compareConfiguration) {
        super(EMFCompareIDEUIMessages.getString("show.conflicting.diffs.action.text"));
        this.viewer = viewer;
        this.selectedDiff = selectedDiff;
        this.compareConfiguration = compareConfiguration;
    }

    public void run() {
        Conflict conflict = this.selectedDiff.getConflict();
        if (conflict == null) {
            return;
        }
        EList diffsToReveal = conflict.getDifferences();
        for (Diff diff : diffsToReveal) {
            List nodes = this.compareConfiguration.getStructureMergeViewerGrouper().getProvider().getTreeNodes((EObject)diff);
            for (TreeNode node : nodes) {
                this.getCompareInputAdapter(node).ifPresent(adapter -> this.viewer.reveal(adapter));
            }
        }
    }

    private Optional<Adapter> getCompareInputAdapter(TreeNode node) {
        return node.eAdapters().stream().filter(adapter -> adapter instanceof CompareInputAdapter).findAny();
    }
}

