/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.AbstractDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.image.EMFCompareCopyToImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExportComparisonAction
extends WorkspaceModifyOperation {
    private DiagramEditPart leftDiagramEditPart;
    private DiagramEditPart rightDiagramEditPart;
    private Collection<AbstractDecoratorManager.AbstractDecorator> decorators;
    private IPath outputPath;
    private ImageFileFormat imageFormat;

    public ExportComparisonAction(IPath path, ImageFileFormat format, DiagramEditPart leftDEP, DiagramEditPart rightDEP, Collection<AbstractDecoratorManager.AbstractDecorator> abstractDecorators) {
        this.outputPath = path;
        this.imageFormat = format;
        this.leftDiagramEditPart = leftDEP;
        this.rightDiagramEditPart = rightDEP;
        this.decorators = abstractDecorators;
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.createImageFiles(monitor);
            }
            catch (OutOfMemoryError | CoreException e) {
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
        }
        finally {
            monitor.done();
            if (monitor.isCanceled()) {
                throw new InterruptedException("The operation was cancelled");
            }
        }
    }

    protected void createImageFiles(IProgressMonitor monitor) throws CoreException {
        EMFCompareCopyToImageUtil tool = new EMFCompareCopyToImageUtil(this.leftDiagramEditPart, this.rightDiagramEditPart, this.decorators);
        tool.copyAllToImage(this.outputPath, this.imageFormat, monitor);
    }
}

