"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const plugin = (context) => {
    if (!context)
        return {};
    return {
        async provideAutoInsertionEdit(document, _, { lastChange }) {
            if (document.languageId === 'html' || document.languageId === 'jade') {
                const enabled = await context.env.getConfiguration?.('vue.autoInsert.bracketSpacing') ?? true;
                if (!enabled)
                    return;
                if (lastChange.text === '{}'
                    && document.getText({
                        start: { line: lastChange.range.start.line, character: lastChange.range.start.character - 1 },
                        end: { line: lastChange.range.start.line, character: lastChange.range.start.character + 3 }
                    }) === '{{}}') {
                    return {
                        newText: ` $0 `,
                        range: {
                            start: { line: lastChange.range.start.line, character: lastChange.range.start.character + 1 },
                            end: { line: lastChange.range.start.line, character: lastChange.range.start.character + 1 }
                        },
                    };
                }
            }
        },
    };
};
const create = () => plugin;
exports.create = create;
//# sourceMappingURL=vue-autoinsert-space.js.map