/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.complex;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class InstanceObjectPropertyEditor
extends TextDialogPropertyEditor
implements IComplexPropertyEditor,
IConfigurablePropertyObject {
    private static final String INSTANCE_JAVA_INFO_KEY = "Instance JavaInfo";
    private String m_className;
    private String m_sourceNewClass;

    /*
     * WARNING - void declaration
     */
    protected String getText(Property property) throws Exception {
        JavaInfo instanceInfo = this.getInstanceInfo(property);
        if (instanceInfo != null) {
            return instanceInfo.getDescription().getComponentClass().getName();
        }
        Expression expression = this.getInstanceExpression(property);
        if (expression != null) {
            Expression expression2 = expression;
            if (expression2 instanceof ClassInstanceCreation) {
                void creation;
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression2;
                ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)expression2;
                if (creation.getAnonymousClassDeclaration() != null) {
                    return "<anonymous>";
                }
                return AstNodeUtils.getFullyQualifiedName(expression, false);
            }
            return "<unknown>";
        }
        Object value = property.getValue();
        if (value != null && value != Property.UNKNOWN_VALUE) {
            return value.getClass().getName();
        }
        return null;
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openClass(property);
        }
        return false;
    }

    public void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        super.deactivate(propertyTable, property, save);
    }

    public void doubleClick(Property property, Point location) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)this.m_sourceNewClass)) {
            this.openClass(property);
        }
    }

    protected void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        IJavaProject project = genericProperty.getJavaInfo().getEditor().getJavaProject();
        IType classType = project.findType(this.m_className);
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)classType);
        Shell shell = DesignerPlugin.getShell();
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)2, (boolean)false);
        dialog.setTitle(ModelMessages.InstanceObjectPropertyEditor_chooseTitle);
        dialog.setMessage(ModelMessages.InstanceObjectPropertyEditor_chooseMessage);
        if (dialog.open() == 0) {
            IType instanceType = (IType)dialog.getResult()[0];
            String instanceTypeName = instanceType.getFullyQualifiedName();
            ComponentDescription instanceComponentDescription = ComponentDescriptionHelper.getDescription(genericProperty.getJavaInfo().getEditor(), instanceTypeName);
            CreationDescription creation = instanceComponentDescription.getCreation(null);
            this.setValueSource(genericProperty, creation.getSource().replace('$', '.'));
        }
    }

    private void openClass(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Expression expression = genericProperty.getExpression();
        if (expression != null) {
            IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)genericProperty.getJavaInfo());
            if (site != null) {
                site.openSourcePosition(expression.getStartPosition());
            }
        } else {
            this.generateNewClass(genericProperty);
            this.openClass(property);
        }
    }

    private void generateNewClass(GenericProperty property) throws Exception {
        this.setValueSource(property, this.m_sourceNewClass);
    }

    public Property[] getProperties(Property property) throws Exception {
        JavaInfo instanceInfo = this.getInstanceInfo(property);
        if (instanceInfo != null) {
            List propertyList = PropertyUtils.getProperties_excludeByParameter((ObjectInfo)instanceInfo, (String)"instanceProperty.exclude-properties");
            Property[] properties = propertyList.toArray(new Property[propertyList.size()]);
            return properties;
        }
        return new Property[0];
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_className = (String)parameters.get("class");
        Assert.isNotNull((Object)this.m_className, (String)"'class' attribute required.");
        this.m_sourceNewClass = (String)parameters.get("source");
    }

    public Expression getInstanceExpression(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        return genericProperty.getExpression();
    }

    public JavaInfo getInstanceInfo(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Expression expression = genericProperty.getExpression();
        if (expression != null) {
            JavaInfo instanceInfo = genericProperty.getJavaInfo().getChildRepresentedBy((ASTNode)expression);
            property.putArbitraryValue((Object)INSTANCE_JAVA_INFO_KEY, (Object)instanceInfo);
            return instanceInfo;
        }
        return null;
    }

    private void setValueSource(final GenericProperty property, final String source) throws Exception {
        final JavaInfo javaInfo = property.getJavaInfo();
        ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

            /*
             * WARNING - void declaration
             */
            public void run() throws Exception {
                JavaInfo oldInstanceInfo = InstanceObjectPropertyEditor.this.getInstanceInfo((Property)property);
                if (oldInstanceInfo != null) {
                    oldInstanceInfo.delete();
                    property.removeArbitraryValue(InstanceObjectPropertyEditor.INSTANCE_JAVA_INFO_KEY);
                }
                String evaluateSource = TemplateUtils.evaluate(source, javaInfo, Collections.emptyMap());
                property.setExpression(evaluateSource, Property.UNKNOWN_VALUE);
                Expression expression = InstanceObjectPropertyEditor.this.getInstanceExpression((Property)property);
                Assert.isNotNull((Object)expression, (String)"setting expression failed.");
                Expression expression2 = expression;
                if (expression2 instanceof ClassInstanceCreation) {
                    void creation;
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression2;
                    ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)expression2;
                    if (creation.getAnonymousClassDeclaration() == null) {
                        JavaInfo newInstanceInfo = JavaInfoUtils.createJavaInfo(javaInfo.getEditor(), AstNodeUtils.getFullyQualifiedName(expression, true), (CreationSupport)new ConstructorCreationSupport((ClassInstanceCreation)creation));
                        newInstanceInfo.bindToExpression(expression);
                        newInstanceInfo.setVariableSupport(new EmptyVariableSupport(newInstanceInfo, (Expression)creation));
                        newInstanceInfo.setAssociation(new InvocationChildAssociation((MethodInvocation)creation.getParent()));
                        javaInfo.addChild(newInstanceInfo);
                    }
                }
            }
        });
    }

    public static void installListenerForProperty(JavaInfo instanceInfo) {
        instanceInfo.addBroadcastListener(new JavaEventListener(instanceInfo){
            final JavaInfo m_instanceInfo;
            {
                this.m_instanceInfo = javaInfo;
            }

            @Override
            public void propertyValueWasSet(GenericPropertyImpl property) throws Exception {
                InstanceObjectPropertyEditor editor;
                if (property.getEditor() instanceof InstanceObjectPropertyEditor && this.m_instanceInfo == property.getArbitraryValue(InstanceObjectPropertyEditor.INSTANCE_JAVA_INFO_KEY) && (editor = (InstanceObjectPropertyEditor)property.getEditor()).getInstanceInfo((Property)property) != this.m_instanceInfo) {
                    this.m_instanceInfo.delete();
                    property.removeArbitraryValue(InstanceObjectPropertyEditor.INSTANCE_JAVA_INFO_KEY);
                }
            }
        });
    }
}

