/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.tree;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.WeightedTreeSet;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeSet;

public final class WeightedTreeGroupBy {
    private WeightedTreeGroupBy() {
    }

    public static <N, E, T extends WeightedTree<N>> WeightedTreeSet<N, Object> groupWeightedTreeBy(IWeightedTreeGroupDescriptor groupBy, IWeightedTreeSet<N, E, T> weightedTreeSet, IWeightedTreeProvider<N, E, T> provider) {
        if (groupBy.equals(AllGroupDescriptor.getInstance())) {
            return WeightedTreeGroupBy.groupWeightedTreeByAll(weightedTreeSet);
        }
        return WeightedTreeGroupBy.searchForGroups(groupBy, weightedTreeSet, provider);
    }

    private static <N, E, T extends WeightedTree<N>> WeightedTreeSet<N, Object> searchForGroups(IWeightedTreeGroupDescriptor groupBy, IWeightedTreeSet<N, E, T> callGraph, IWeightedTreeProvider<N, E, T> provider) {
        IWeightedTreeGroupDescriptor groupDescriptor = provider.getGroupDescriptor();
        int level = 0;
        while (groupDescriptor != null && !groupDescriptor.equals(groupBy)) {
            groupDescriptor = groupDescriptor.getNextGroup();
            ++level;
        }
        WeightedTreeSet newCg = new WeightedTreeSet();
        Collection<E> elements = callGraph.getElements();
        for (E element : elements) {
            Object groupElement = element instanceof ITree ? ((ITree)element).copyElement() : Objects.requireNonNull(element);
            WeightedTreeGroupBy.recurseAddElementData(element, groupElement, callGraph, newCg, 0, level);
        }
        return newCg;
    }

    private static <N, E, T extends WeightedTree<N>> void recurseAddElementData(E originalElement, Object groupElement, IWeightedTreeSet<@NonNull N, E, T> treeSet, WeightedTreeSet<@NonNull N, Object> newTreeSet, int elDepth, int groupDepth) {
        for (WeightedTree tree : treeSet.getTreesFor(originalElement)) {
            newTreeSet.addWeightedTree(groupElement, tree.copyOf());
        }
        if (originalElement instanceof ITree) {
            ITree treeEl = (ITree)originalElement;
            Collection<ITree> children = treeEl.getChildren();
            for (ITree child : children) {
                ITree nextGroupEl = (ITree)groupElement;
                if (elDepth < groupDepth) {
                    nextGroupEl = child.copyElement();
                    ((ITree)groupElement).addChild(nextGroupEl);
                }
                WeightedTreeGroupBy.recurseAddElementData(child, nextGroupEl, treeSet, newTreeSet, elDepth + 1, groupDepth);
            }
        }
    }

    private static <N, E, T extends WeightedTree<N>> WeightedTreeSet<N, Object> groupWeightedTreeByAll(IWeightedTreeSet<N, E, T> weightedTree) {
        WeightedTreeSet newTreeSet = new WeightedTreeSet();
        Collection<E> elements = weightedTree.getElements();
        String mainGroup = "All";
        for (E element : elements) {
            WeightedTreeGroupBy.recurseAddElementData(element, mainGroup, weightedTree, newTreeSet);
        }
        return newTreeSet;
    }

    private static <N, E, T extends WeightedTree<N>> void recurseAddElementData(E element, String group, IWeightedTreeSet<@NonNull N, E, T> treeSet, WeightedTreeSet<@NonNull N, Object> newTreeSet) {
        for (WeightedTree tree : treeSet.getTreesFor(element)) {
            newTreeSet.addWeightedTree(group, tree.copyOf());
        }
        if (element instanceof ITree) {
            ITree treeEl = (ITree)element;
            Collection<ITree> children = treeEl.getChildren();
            for (ITree child : children) {
                WeightedTreeGroupBy.recurseAddElementData(child, group, treeSet, newTreeSet);
            }
        }
    }
}

