/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.model;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.CompositeHostModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.ICpuTimeProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.ISamplingDataProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IThreadOnCpuProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ModelListener
implements ITmfNewAnalysisModuleListener {
    private static final Comparator<ITmfStateInterval> INTERVAL_COMPARATOR = new Comparator<ITmfStateInterval>(){

        @Override
        public int compare(@Nullable ITmfStateInterval o1, @Nullable ITmfStateInterval o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getEndTime() < o2.getEndTime() ? -1 : (o1.getEndTime() == o2.getEndTime() ? 0 : 1);
        }
    };
    private Map<TidAnalysisModule, TidAnalysisWrapper> fTidModules = new WeakHashMap<TidAnalysisModule, TidAnalysisWrapper>();

    public void moduleCreated(@Nullable IAnalysisModule module) {
        Object model;
        ITmfTrace trace;
        IHostModel model2;
        Object provider;
        if (module instanceof ICpuTimeProvider) {
            provider = (ICpuTimeProvider)module;
            for (String hostId : provider.getHostIds()) {
                model2 = ModelManager.getModelFor(hostId);
                if (!(model2 instanceof CompositeHostModel)) continue;
                ((CompositeHostModel)model2).setCpuTimeProvider((ICpuTimeProvider)provider);
            }
        }
        if (module instanceof IThreadOnCpuProvider) {
            provider = (IThreadOnCpuProvider)module;
            for (String hostId : provider.getHostIds()) {
                model2 = ModelManager.getModelFor(hostId);
                if (!(model2 instanceof CompositeHostModel)) continue;
                ((CompositeHostModel)model2).setThreadOnCpuProvider((IThreadOnCpuProvider)provider);
            }
        }
        if (module instanceof TidAnalysisModule && (trace = (provider = (TidAnalysisModule)module).getTrace()) != null) {
            model = ModelManager.getModelFor(trace.getHostId());
            TidAnalysisWrapper tidAnalysisWrapper = new TidAnalysisWrapper((TidAnalysisModule)provider, trace.getHostId());
            this.fTidModules.put((TidAnalysisModule)provider, tidAnalysisWrapper);
            ((CompositeHostModel)model).setThreadOnCpuProvider(trace, tidAnalysisWrapper);
            ((CompositeHostModel)model).setCpuTimeProvider(trace, tidAnalysisWrapper);
        }
        if (module instanceof ISamplingDataProvider) {
            provider = (ISamplingDataProvider)module;
            for (String hostId : provider.getHostIds()) {
                model2 = ModelManager.getModelFor(hostId);
                if (!(model2 instanceof CompositeHostModel)) continue;
                ((CompositeHostModel)model2).setSamplingDataProvider((ISamplingDataProvider)provider);
            }
        }
        if (module instanceof KernelAnalysisModule && (trace = (provider = (KernelAnalysisModule)module).getTrace()) != null) {
            model = ModelManager.getModelFor(trace.getHostId());
            ((CompositeHostModel)model).setKernelModule(trace, (KernelAnalysisModule)provider);
        }
    }

    static interface IModuleWrapper {
        public Optional<IAnalysisModule> getModule();
    }

    private static class TidAnalysisWrapper
    implements IThreadOnCpuProvider,
    ICpuTimeProvider,
    IModuleWrapper {
        private final WeakReference<@Nullable TidAnalysisModule> fModule;
        private final Collection<String> fHostIds;

        public TidAnalysisWrapper(TidAnalysisModule module, String hostId) {
            this.fHostIds = Collections.singleton(hostId);
            this.fModule = new WeakReference<TidAnalysisModule>(module);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public @Nullable Integer getThreadOnCpuAtTime(int cpu, long time, boolean block) {
            module = (TidAnalysisModule)this.fModule.get();
            if (module != null) ** GOTO lbl9
            return null;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
lbl9:
                // 2 sources

                ** while (block && !module.isQueryable((long)time))
            }
lbl10:
            // 2 sources

            return module.getThreadOnCpuAtTime(cpu, time);
        }

        @Override
        public @NonNull Collection<String> getHostIds() {
            return this.fHostIds;
        }

        @Override
        public long getCpuTime(int tid, long start, long realEnd) {
            TidAnalysisModule module = (TidAnalysisModule)this.fModule.get();
            if (module == null) {
                return -1L;
            }
            ITmfStateSystem stateSystem = module.getStateSystem();
            if (stateSystem == null) {
                return -1L;
            }
            long cpuTime = 0L;
            if (tid < 0) {
                return -1L;
            }
            long time = Long.max(start, stateSystem.getStartTime());
            long end = Math.min(realEnd, stateSystem.getCurrentEndTime());
            boolean found = false;
            try {
                while (time < end) {
                    found = false;
                    List states = stateSystem.queryFullState(time);
                    for (ITmfStateInterval interval : states) {
                        if (interval.getStateValue().unboxLong() != (long)tid) continue;
                        long endTime = Math.min(end, interval.getEndTime() + 1L);
                        cpuTime += endTime - time;
                        time = endTime + 1L;
                        found = true;
                    }
                    if (found) continue;
                    Collections.sort(states, INTERVAL_COMPARATOR);
                    while (time < end && !found) {
                        ITmfStateInterval interval;
                        interval = (ITmfStateInterval)states.remove(0);
                        time = interval.getEndTime() + 1L;
                        if (time > end) continue;
                        ITmfStateInterval next = stateSystem.querySingleState(time, interval.getAttribute());
                        if (next.getStateValue().unboxLong() == (long)tid) {
                            long endTime = Math.min(end, next.getEndTime() + 1L);
                            cpuTime += endTime - time;
                            time = endTime + 1L;
                            found = true;
                            continue;
                        }
                        int pos = Collections.binarySearch(states, next, INTERVAL_COMPARATOR);
                        if (pos < 0) {
                            states.add(-pos - 1, next);
                            continue;
                        }
                        states.add(interval);
                    }
                }
            }
            catch (StateSystemDisposedException e) {
                return -1L;
            }
            return cpuTime;
        }

        @Override
        public Optional<IAnalysisModule> getModule() {
            TidAnalysisModule module = (TidAnalysisModule)this.fModule.get();
            return module == null ? Optional.empty() : Optional.of(module);
        }
    }
}

