/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;

public class ConnectionLoggerImpl
implements ConnectionLogger {
    private final Writer logWriter;
    private final LogLifecycleListener lifecycleListener;
    private StreamId lastSource = null;
    private volatile ConnectionLogger.ConnectionCloser connectionCloser = null;
    private volatile boolean isClosed = false;
    private final ITerminate connectionTerminate = new ITerminate(){

        public boolean canTerminate() {
            return !ConnectionLoggerImpl.this.isClosed && ConnectionLoggerImpl.this.connectionCloser != null;
        }

        public boolean isTerminated() {
            return ConnectionLoggerImpl.this.isClosed;
        }

        public void terminate() {
            ConnectionLogger.ConnectionCloser connectionCloser0 = ConnectionLoggerImpl.this.connectionCloser;
            if (connectionCloser0 == null) {
                throw new IllegalStateException();
            }
            connectionCloser0.closeConnection();
        }
    };
    private static final String MESSAGE_SEPARATOR = Messages.ConnectionLoggerImpl_MessageSeparator;

    public ConnectionLoggerImpl(Writer logWriter, LogLifecycleListener lifecycleListener) {
        this.logWriter = logWriter;
        this.lifecycleListener = lifecycleListener;
    }

    public ConnectionLogger.StreamListener getIncomingStreamListener() {
        StreamId streamId = new StreamId(){

            @Override
            public String getStreamName() {
                return Messages.ConnectionLoggerImpl_ReceivedFromChrome;
            }
        };
        return new StreamListenerImpl(streamId);
    }

    public ConnectionLogger.StreamListener getOutgoingStreamListener() {
        StreamId streamId = new StreamId(){

            @Override
            public String getStreamName() {
                return Messages.ConnectionLoggerImpl_SentToChrome;
            }
        };
        return new StreamListenerImpl(streamId);
    }

    public void start() {
        this.lifecycleListener.logStarted(this);
    }

    public void handleEos() {
        this.isClosed = true;
        this.lifecycleListener.logClosed();
    }

    public ITerminate getConnectionTerminate() {
        return this.connectionTerminate;
    }

    public void setConnectionCloser(ConnectionLogger.ConnectionCloser connectionCloser) {
        this.connectionCloser = connectionCloser;
    }

    private synchronized void writeToLog(CharSequence str, StreamId streamId) {
        try {
            this.printHead(streamId);
            this.logWriter.append(str);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    private void printHead(StreamId streamId) throws IOException {
        if (this.lastSource != streamId) {
            if (this.lastSource != null) {
                this.logWriter.append('\n');
            }
            this.logWriter.append("> ").append(streamId.getStreamName()).append('\n');
            this.lastSource = streamId;
        }
    }

    private void flushLogWriter() {
        try {
            this.logWriter.flush();
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    public static interface LogLifecycleListener {
        public void logStarted(ConnectionLoggerImpl var1);

        public void logClosed();
    }

    private static abstract class StreamId {
        private StreamId() {
        }

        abstract String getStreamName();
    }

    private class StreamListenerImpl
    implements ConnectionLogger.StreamListener {
        private final StreamId streamId;

        private StreamListenerImpl(StreamId streamId) {
            this.streamId = streamId;
        }

        public void addContent(CharSequence text) {
            ConnectionLoggerImpl.this.writeToLog(text, this.streamId);
            ConnectionLoggerImpl.this.flushLogWriter();
        }

        public void addSeparator() {
            ConnectionLoggerImpl.this.writeToLog(MESSAGE_SEPARATOR, this.streamId);
            ConnectionLoggerImpl.this.flushLogWriter();
        }
    }
}

