/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui.history;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.ui.history.History;
import org.eclipse.unittest.internal.ui.history.HistoryItem;
import org.eclipse.unittest.internal.ui.history.Messages;

public class HistoryDialog
extends SelectionDialog {
    private static final Comparator<HistoryItem> COMPARING_START_DATE = Comparator.comparing(HistoryItem::getStartDate).reversed();
    private Set<TestRunSession> fCurrentlyVisible;
    private Button fRemoveButton;
    private Button fExportButton;
    private TableViewer fTable;

    public HistoryDialog(Shell shell, Set<TestRunSession> visibleSessions) {
        super(shell);
        this.fCurrentlyVisible = visibleSessions;
        this.setResult(Collections.emptyList());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.HistoryDialog_title);
        this.getShell().setText(Messages.HistoryDialog_title);
        Composite res = new Composite(parent, 0);
        res.setLayoutData((Object)new GridData(4, 4, true, true));
        res.setLayout((Layout)new GridLayout(2, false));
        this.fTable = this.createTable(res);
        this.fTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createButtons(res);
        return this.fTable.getControl();
    }

    private void createButtons(Composite res) {
        Composite buttons = new Composite(res, 0);
        buttons.setLayoutData((Object)new GridData(4, -1, false, false));
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        buttons.setLayout((Layout)rowLayout);
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(Messages.HistoryDialog_remove);
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object[] objectArray = this.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                History.INSTANCE.remove((HistoryItem)selected);
                ++n2;
            }
            this.fTable.refresh();
        }));
        Button importButton = new Button(buttons, 8);
        importButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fileDialog = new FileDialog(this.getShell());
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            fileDialog.setText(Messages.HistoryDialog_selectImport);
            String path = fileDialog.open();
            if (path == null) {
                return;
            }
            Path sourcePath = Path.of(path, new String[0]);
            Path targetPath = Path.of(History.INSTANCE.getDirectory().getAbsolutePath(), sourcePath.getFileName().toString());
            try {
                Files.copy(sourcePath, targetPath, new CopyOption[0]);
                History.INSTANCE.add(new HistoryItem(targetPath.toFile()));
            }
            catch (IOException e1) {
                UnitTestPlugin.log(e1);
            }
            this.fTable.refresh();
        }));
        importButton.setText(Messages.HistoryDialog_import);
        this.fExportButton = new Button(buttons, 8);
        this.fExportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setText(Messages.HistoryDialog_selectExport);
            String path = directoryDialog.open();
            if (path == null) {
                return;
            }
            File directory = new File(path);
            Object[] objectArray = this.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                HistoryItem historyItem = (HistoryItem)object;
                try {
                    historyItem.storeSessionToFile(new File(directory, historyItem.getFile().getName()));
                }
                catch (TransformerFactoryConfigurationError | CoreException e1) {
                    UnitTestPlugin.log(e1);
                }
                ++n2;
            }
            this.fTable.refresh();
        }));
        this.fExportButton.setText(Messages.HistoryDialog_export);
        this.updateButtons();
    }

    private TableViewer createTable(Composite parent) {
        TableViewer table = new TableViewer(parent);
        table.setContentProvider((IContentProvider)new ArrayContentProvider());
        table.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                HistoryItem item1 = (HistoryItem)e1;
                HistoryItem item2 = (HistoryItem)e2;
                return COMPARING_START_DATE.compare(item1, item2);
            }
        });
        int fontSize = table.getTable().getFont().getFontData()[0].getHeight();
        table.getTable().setHeaderVisible(true);
        TableViewerColumn visibleColumn = new TableViewerColumn(table, -1);
        visibleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((HistoryItem)element).getCurrentTestRunSession().filter(HistoryDialog.this.fCurrentlyVisible::contains).map(any -> "\ud83d\udc41\ufe0f").orElse("");
            }
        });
        visibleColumn.getColumn().setWidth(2 * fontSize);
        TableViewerColumn nameColumn = new TableViewerColumn(table, -1);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((HistoryItem)element).getName();
            }
        });
        nameColumn.getColumn().setWidth(20 * fontSize);
        nameColumn.getColumn().setText(Messages.HistoryDialog_name);
        TableViewerColumn dateColumn = new TableViewerColumn(table, -1);
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Instant startDate = ((HistoryItem)element).getStartDate();
                return startDate != null ? startDate.atZone(ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME) : "";
            }
        });
        dateColumn.getColumn().setWidth(25 * fontSize);
        dateColumn.getColumn().setText(Messages.HistoryDialog_date);
        TableViewerColumn progressColumn = new TableViewerColumn(table, -1);
        progressColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((HistoryItem)element).getCurrentTestRunSession().filter(TestRunSession::isRunning).map(any -> "\ud83c\udfc3").orElse("");
            }
        });
        progressColumn.getColumn().setWidth(2 * fontSize);
        progressColumn.getColumn().setText(Messages.HistoryDialog_progress);
        TableViewerColumn successColumn = new TableViewerColumn(table, -1);
        successColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                int failures = ((HistoryItem)element).getFailureCount();
                if (failures == 0) {
                    return "\u2705";
                }
                return "\u274c " + failures + Messages.HistoryDialog_failures;
            }
        });
        successColumn.getColumn().setWidth(15 * fontSize);
        successColumn.getColumn().setText(Messages.HistoryDialog_result);
        TableViewerColumn sizeColumn = new TableViewerColumn(table, -1);
        sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Long size = ((HistoryItem)element).getSizeOnDisk();
                if (size != null) {
                    return size.toString() + " B";
                }
                return Character.toString('?');
            }
        });
        sizeColumn.getColumn().setText(Messages.HistoryDialog_size);
        sizeColumn.getColumn().setWidth(10 * fontSize);
        table.setInput(History.INSTANCE.getHistory());
        table.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections().toArray()));
        table.addSelectionChangedListener(event -> this.setSelectionResult(((IStructuredSelection)event.getSelection()).toArray()));
        return table;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, id == 0 ? IDialogConstants.OPEN_LABEL : label, defaultButton);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    protected void setSelectionResult(Object[] newResult) {
        super.setSelectionResult(newResult);
        this.updateButtons();
    }

    private void updateButtons() {
        Object[] selection = this.getResult();
        boolean singleItemSelection = selection.length == 1;
        Stream.of(this.getButton(0), this.fRemoveButton, this.fExportButton).filter(Objects::nonNull).forEach(button -> button.setEnabled(singleItemSelection));
        if (singleItemSelection) {
            HistoryItem item = (HistoryItem)selection[0];
            boolean isRunning = item.getCurrentTestRunSession().filter(TestRunSession::isRunning).isPresent();
            this.fRemoveButton.setEnabled(!isRunning);
            this.fExportButton.setEnabled(!isRunning);
        }
    }
}

