/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractPeerModelService;

public class PeerModelUpdateService
extends AbstractPeerModelService
implements IPeerModelUpdateService {
    public PeerModelUpdateService(IPeerModel parentModel) {
        super(parentModel);
    }

    @Override
    public void add(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peerNodes = (Map)this.getPeerModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peerNodes);
        peerNodes.put(peerNode.getPeerId(), peerNode);
        final IPeerModelListener[] listeners = this.getPeerModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeerModelListener[] iPeerModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPeerModelListener listener = iPeerModelListenerArray[n2];
                        listener.modelChanged(PeerModelUpdateService.this.getPeerModel(), peerNode, true);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void remove(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peerNodes = (Map)this.getPeerModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peerNodes);
        peerNodes.remove(peerNode.getPeerId());
        final IPeerModelListener[] listeners = this.getPeerModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeerModelListener[] iPeerModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPeerModelListener listener = iPeerModelListenerArray[n2];
                        listener.modelChanged(PeerModelUpdateService.this.getPeerModel(), peerNode, false);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void updatePeerServices(IPeerNode peerNode, Collection<String> localServices, Collection<String> remoteServices) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        peerNode.setProperty("LocalServices", localServices != null ? this.makeString(localServices) : null);
        peerNode.setProperty("RemoteServices", remoteServices != null ? this.makeString(remoteServices) : null);
    }

    protected String makeString(Collection<String> collection) {
        Assert.isNotNull(collection);
        if (collection.isEmpty()) {
            return null;
        }
        String buffer = collection.toString();
        buffer = buffer.replaceAll("\\[", "").replaceAll("\\]", "");
        return buffer.trim();
    }
}

