/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.internal.core.Token;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;

public class ChannelHTTP
extends AbstractChannel {
    private static int id_cnt = 0;
    private final String id = String.valueOf(UUID.randomUUID().toString()) + "-" + Integer.toHexString(id_cnt++);
    private final String host;
    private final int port;
    private boolean stopped;
    private byte[] wr_buf = new byte[4096];
    private int wr_cnt;

    public ChannelHTTP(IPeer remote_peer, String host, int port) {
        super(remote_peer);
        this.host = host;
        this.port = port;
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelHTTP.this.start();
            }
        });
    }

    @Override
    public boolean isZeroCopySupported() {
        return false;
    }

    @Override
    protected int read() throws IOException {
        String nm = "http://" + this.host + ":" + this.port + "/tcf/sse";
        URL url = new URL(nm);
        while (!this.stopped) {
            try {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("Content-Type", "text/event-stream");
                con.setRequestProperty("X-Session-ID", this.id);
                con.setRequestMethod("GET");
                BufferedReader inp = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
                while (!this.stopped) {
                    String s = inp.readLine();
                    if (s == null) break;
                    if (s.length() > 0) continue;
                    Protocol.invokeLater(new Runnable(){
                        IToken cmd;

                        @Override
                        public void run() {
                            if (this.cmd != null) {
                                return;
                            }
                            if (ChannelHTTP.this.getState() != 1) {
                                return;
                            }
                            ILocator l = ChannelHTTP.this.getRemoteService(ILocator.class);
                            this.cmd = l.sync(new ILocator.DoneSync(){

                                @Override
                                public void doneSync(IToken token) {
                                    if (!$assertionsDisabled && cmd != token) {
                                        throw new AssertionError();
                                    }
                                    cmd = null;
                                }
                            });
                        }
                    });
                }
                inp.close();
            }
            catch (Throwable x) {
                if (x instanceof FileNotFoundException) {
                    throw new IOException("Page not found: " + x.getMessage());
                }
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                throw new IOException(x);
            }
        }
        return -1;
    }

    @Override
    protected void write(int n) throws IOException {
        if (n < 0) {
            if (this.wr_cnt > 0) {
                try {
                    try {
                        int i = 0;
                        char type = (char)this.wr_buf[i++];
                        this.checkEndOfString(i++);
                        switch (type) {
                            case 'C': {
                                this.sendCommand(i);
                                break;
                            }
                            case 'E': {
                                this.sendEvent(i);
                            }
                        }
                    }
                    catch (Throwable x) {
                        if (x instanceof FileNotFoundException) {
                            throw new IOException("Page not found: " + x.getMessage());
                        }
                        if (x instanceof IOException) {
                            throw (IOException)x;
                        }
                        throw new IOException(x);
                    }
                }
                finally {
                    this.wr_cnt = 0;
                }
            }
            return;
        }
        if (this.wr_cnt >= this.wr_buf.length) {
            byte[] t = new byte[this.wr_cnt * 2];
            System.arraycopy(this.wr_buf, 0, t, 0, this.wr_cnt);
            this.wr_buf = t;
        }
        this.wr_buf[this.wr_cnt++] = (byte)n;
    }

    @Override
    protected final void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    protected final void write(byte[] buf, int pos, int len) throws IOException {
        if (this.wr_cnt + len > this.wr_buf.length) {
            byte[] t = new byte[(this.wr_cnt + len) * 2];
            System.arraycopy(this.wr_buf, 0, t, 0, this.wr_cnt);
            this.wr_buf = t;
        }
        System.arraycopy(buf, pos, this.wr_buf, this.wr_cnt, len);
        this.wr_cnt += len;
    }

    @Override
    protected void flush() throws IOException {
    }

    @Override
    protected void stop() throws IOException {
        assert (!this.stopped);
        this.stopped = true;
        URL url = new URL("http://" + this.host + ":" + this.port + "/tcf/stop/");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("X-Session-ID", this.id);
        con.setRequestMethod("GET");
        con.getInputStream().close();
    }

    private char toHexDigit(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(48 + n);
        }
        if (n >= 10 && n <= 15) {
            return (char)(65 + n - 10);
        }
        return ' ';
    }

    private void checkEndOfString(int i) throws Exception {
        if (i >= this.wr_cnt || this.wr_buf[i] != 0) {
            throw new IOException("Invalid message format");
        }
    }

    private String getArgs(int i) throws Exception {
        if (i >= this.wr_cnt) {
            return null;
        }
        StringBuffer args = new StringBuffer();
        while (i < this.wr_cnt) {
            if (args.length() > 0) {
                args.append('&');
            }
            while (this.wr_buf[i] != 0) {
                char ch;
                if ((ch = (char)(this.wr_buf[i++] & 0xFF)) <= ' ' || ch == '%' || ch == '#' || ch == '&' || ch >= '\u007f') {
                    args.append('%');
                    args.append(this.toHexDigit(ch >> 4 & 0xF));
                    args.append(this.toHexDigit(ch & 0xF));
                    continue;
                }
                args.append(ch);
            }
            this.checkEndOfString(i++);
        }
        return args.toString();
    }

    private void sendCommand(int i) throws Exception {
        int p = i;
        while (i < this.wr_cnt && this.wr_buf[i] != 0) {
            ++i;
        }
        byte[] t = new byte[i - p];
        System.arraycopy(this.wr_buf, p, t, 0, t.length);
        Token token = new Token(t);
        this.checkEndOfString(i++);
        p = i;
        while (i < this.wr_cnt && this.wr_buf[i] != 0) {
            ++i;
        }
        String service = new String(this.wr_buf, p, i - p, "UTF-8");
        this.checkEndOfString(i++);
        p = i;
        while (i < this.wr_cnt && this.wr_buf[i] != 0) {
            ++i;
        }
        String command = new String(this.wr_buf, p, i - p, "UTF-8");
        this.checkEndOfString(i++);
        this.sendRequest(token, service, command, this.getArgs(i));
    }

    private void sendEvent(int i) throws Exception {
        int p = i;
        while (i < this.wr_cnt && this.wr_buf[i] != 0) {
            ++i;
        }
        String service = new String(this.wr_buf, p, i - p, "UTF-8");
        this.checkEndOfString(i++);
        p = i;
        while (i < this.wr_cnt && this.wr_buf[i] != 0) {
            ++i;
        }
        String command = new String(this.wr_buf, p, i - p, "UTF-8");
        this.checkEndOfString(i++);
        this.sendRequest(null, service, command, this.getArgs(i));
    }

    private void sendRequest(Token token, String service, String command, String args) throws Exception {
        String nm = token != null ? "/tcf/c/" + token + "/" : "/tcf/e/";
        nm = "http://" + this.host + ":" + this.port + nm + service + "/" + command;
        if (args != null && args.length() > 0) {
            nm = String.valueOf(nm) + "?" + args;
        }
        assert (!this.stopped);
        URL url = new URL(nm);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("X-Session-ID", this.id);
        con.setRequestMethod("GET");
        InputStream inp = con.getInputStream();
        final byte[] buf = new byte[con.getHeaderFieldInt("Content-Length", 0)];
        int pos = 0;
        while (pos < buf.length) {
            int rd = inp.read(buf, pos, buf.length - pos);
            if (rd < 0) break;
            pos += rd;
        }
        while (inp.read() > 0) {
        }
        inp.close();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        Object obj = JSON.parseOne(buf);
                        if (obj instanceof Collection) {
                            for (Object x : (Collection)obj) {
                                ChannelHTTP.this.handleReply(x);
                            }
                            break block4;
                        }
                        throw new Exception("Invalid HTTP reply");
                    }
                    catch (Exception x) {
                        Protocol.log("Cannot execute HTTP request", x);
                    }
                }
            }
        });
    }

    private void handleReply(Object obj) throws Exception {
        AbstractChannel.Message msg;
        if (obj instanceof Map) {
            Map m = (Map)obj;
            String error = (String)m.get("Error");
            if (error != null) {
                throw new Exception(error);
            }
            String type = (String)m.get("Type");
            msg = new AbstractChannel.Message(type.charAt(0));
            switch (msg.type) {
                case 'C': {
                    msg.token = new Token(((String)m.get("Token")).getBytes("UTF-8"));
                    msg.service = (String)m.get("Service");
                    msg.name = (String)m.get("Command");
                    msg.data = this.readArgs(m.get("Args"));
                    break;
                }
                case 'N': 
                case 'P': 
                case 'R': {
                    msg.token = new Token(((String)m.get("Token")).getBytes("UTF-8"));
                    msg.data = this.readArgs(m.get("Args"));
                    break;
                }
                case 'E': {
                    msg.service = (String)m.get("Service");
                    msg.name = (String)m.get("Event");
                    msg.data = this.readArgs(m.get("Args"));
                    if (!msg.service.equals("Locator") || !msg.name.equals("Hello") || this.getState() == 0) break;
                    return;
                }
                case 'F': {
                    msg.data = this.readArgs(m.get("Args"));
                    break;
                }
                default: {
                    throw new Exception("Invalid HTTP reply");
                }
            }
        } else {
            throw new Exception("Invalid HTTP reply");
        }
        this.handleInput(msg);
    }

    private byte[] readArgs(Object obj) throws Exception {
        byte[] res = null;
        if (obj instanceof Collection) {
            res = JSON.toJSONSequence(((Collection)obj).toArray());
        } else if (obj != null) {
            throw new Exception("Invalid HTTP reply");
        }
        return res;
    }
}

