/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionDetails;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionElementBodyTextDetails;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionElementDetails;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ExtensionsPage
extends PDEFormPage {
    public static final String PAGE_ID = "extensions";
    private ExtensionsSection fSection;
    private ExtensionsBlock fBlock = new ExtensionsBlock();

    public ExtensionsPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.ExtensionsPage_tabName);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_plugin_extensions";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(PDEUIMessages.ExtensionsPage_title);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXTENSIONS_OBJ));
        this.fBlock.createContent(managedForm);
        this.fSection.fireSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_plugin_extensions");
        super.createFormContent(managedForm);
    }

    @Override
    public void updateFormSelection() {
        super.updateFormSelection();
        IFormPage page = this.getPDEEditor().findPage("plugin-context");
        if (page instanceof ManifestSourcePage) {
            ISourceViewer viewer = ((ManifestSourcePage)page).getViewer();
            if (viewer == null) {
                return;
            }
            StyledText text = viewer.getTextWidget();
            if (text == null) {
                return;
            }
            int offset = text.getCaretOffset();
            if (offset < 0) {
                return;
            }
            IDocumentRange range = ((ManifestSourcePage)page).getRangeElement(offset, true);
            if (range instanceof IDocumentAttributeNode) {
                range = ((IDocumentAttributeNode)range).getEnclosingElement();
            } else if (range instanceof IDocumentTextNode) {
                range = ((IDocumentTextNode)range).getEnclosingElement();
            }
            if (range instanceof IPluginExtension || range instanceof IPluginElement) {
                this.fSection.selectExtensionElement((ISelection)new StructuredSelection((Object)range));
            }
        }
    }

    public class ExtensionsBlock
    extends PDEMasterDetailsBlock
    implements IDetailsPageProvider {
        private ExtensionElementBodyTextDetails fBodyTextDetails;

        public ExtensionsBlock() {
            super(ExtensionsPage.this);
        }

        @Override
        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            ExtensionsPage.this.fSection = new ExtensionsSection(this.getPage(), parent);
            return ExtensionsPage.this.fSection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageLimit(10);
            detailsPart.registerPage(IPluginExtension.class, (IDetailsPage)new ExtensionDetails(ExtensionsPage.this.fSection));
            this.fBodyTextDetails = new ExtensionElementBodyTextDetails(ExtensionsPage.this.fSection);
            detailsPart.registerPage(ExtensionElementBodyTextDetails.class, (IDetailsPage)this.fBodyTextDetails);
            detailsPart.setPageProvider((IDetailsPageProvider)this);
        }

        public Object getPageKey(Object object) {
            if (object instanceof IPluginExtension) {
                return IPluginExtension.class;
            }
            if (object instanceof IPluginElement) {
                ISchemaElement element = ExtensionsSection.getSchemaElement((IPluginElement)object);
                if (element != null) {
                    if (element.getType() instanceof ISchemaSimpleType) {
                        this.fBodyTextDetails.setSchemaElement(element);
                        return ExtensionElementBodyTextDetails.class;
                    }
                    return element;
                }
                IPluginElement pelement = (IPluginElement)object;
                if (pelement.getAttributeCount() == 0 && pelement.getChildCount() == 0) {
                    this.fBodyTextDetails.setSchemaElement(null);
                    return ExtensionElementBodyTextDetails.class;
                }
                String ename = pelement.getName();
                IPluginExtension extension = ExtensionsSection.getExtension((IPluginParent)pelement.getParent());
                return extension.getPoint() + "/" + ename;
            }
            return object.getClass();
        }

        public IDetailsPage getPage(Object object) {
            if (object instanceof ISchemaElement) {
                return new ExtensionElementDetails(ExtensionsPage.this.fSection, (ISchemaElement)object);
            }
            if (object instanceof String) {
                return new ExtensionElementDetails(ExtensionsPage.this.fSection, null);
            }
            return null;
        }
    }
}

