/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.ProjectTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.BundleException;

public class ProjectComponent
extends BundleComponent {
    public static final String ENTRY_CUSTOM = "custom";
    public static final String EXTRA_PREFIX = "extra.";
    private IJavaProject fProject;
    private IPluginModelBase fModel;
    private volatile Map<String, IApiTypeContainer> fPathToOutputContainers;
    private volatile Map<IPath, IApiTypeContainer> fOutputLocationToContainer;

    public ProjectComponent(IApiBaseline baseline, String location, IPluginModelBase model, long bundleid) throws CoreException {
        super(baseline, location, bundleid);
        IPath path = IPath.fromOSString((String)location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        this.fProject = JavaCore.create((IProject)project);
        this.fModel = model;
    }

    @Override
    protected void setName(String newname) {
        super.setName(this.fModel.getResourceString(newname));
    }

    @Override
    protected boolean isBinary() {
        return false;
    }

    @Override
    protected BundleDescription getBundleDescription(Map<String, String> manifest, String location, long id) throws BundleException {
        try {
            BundleDescription result = this.getModel().getBundleDescription();
            if (result == null) {
                throw new BundleException("Cannot find manifest for bundle at " + location);
            }
            return result;
        }
        catch (CoreException ce) {
            throw new BundleException(ce.getMessage());
        }
    }

    IPluginModelBase getModel() throws CoreException {
        if (this.fModel == null) {
            this.fModel = PluginRegistry.findModel((IProject)this.fProject.getProject());
            if (this.fModel == null) {
                this.abort(NLS.bind((String)CoreMessages.ProjectComponent_could_not_locate_model, (Object)this.fProject.getElementName()), null);
            }
        }
        return this.fModel;
    }

    @Override
    protected boolean isApiEnabled() {
        return Util.isApiProject(this.fProject);
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            try {
                if (this.hasApiFilterStore()) {
                    this.getFilterStore().dispose();
                }
                this.fModel = null;
                if (this.fOutputLocationToContainer != null) {
                    this.fOutputLocationToContainer.clear();
                    this.fOutputLocationToContainer = null;
                }
                if (this.fPathToOutputContainers != null) {
                    this.fPathToOutputContainers.clear();
                    this.fPathToOutputContainers = null;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    protected IApiDescription createLocalApiDescription() throws CoreException {
        long time = System.currentTimeMillis();
        if (Util.isApiProject(this.getJavaProject())) {
            this.setHasApiDescription(true);
        }
        IApiDescription apiDesc = ApiDescriptionManager.getManager().getApiDescription(this, this.getBundleDescription());
        if (ApiPlugin.DEBUG_PROJECT_COMPONENT) {
            System.out.println("Time to create api description for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return apiDesc;
    }

    @Override
    protected IApiFilterStore createApiFilterStore() throws CoreException {
        long time = System.currentTimeMillis();
        ApiFilterStore store = new ApiFilterStore(this.getJavaProject());
        if (ApiPlugin.DEBUG_PROJECT_COMPONENT) {
            System.out.println("Time to create api filter store for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return store;
    }

    @Override
    protected List<IApiTypeContainer> createApiTypeContainers() throws CoreException {
        if (this.isDisposed()) {
            this.baselineDisposed(this.getBaseline());
        }
        this.fPathToOutputContainers = new ConcurrentHashMap<String, IApiTypeContainer>(4);
        this.fOutputLocationToContainer = new ConcurrentHashMap<IPath, IApiTypeContainer>(4);
        if (this.fProject.exists() && this.fProject.getProject().isOpen()) {
            IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject.getProject());
            if (model != null) {
                ProjectComponent.createContainersFromProjectModel(model, this, this.fPathToOutputContainers, this.fOutputLocationToContainer);
            }
            return super.createApiTypeContainers();
        }
        return Collections.emptyList();
    }

    private static void createContainersFromProjectModel(IPluginModelBase model, ProjectComponent project, Map<String, IApiTypeContainer> pathToOutputContainers, Map<IPath, IApiTypeContainer> outputLocationToContainer) throws CoreException {
        block13: {
            IBuild build;
            block12: {
                IBuildModel buildModel = PluginRegistry.createBuildModel((IPluginModelBase)model);
                if (buildModel == null) {
                    return;
                }
                build = buildModel.getBuild();
                IBuildEntry entry = build.getEntry(ENTRY_CUSTOM);
                if (entry == null) break block12;
                String[] tokens = entry.getTokens();
                if (tokens.length != 1 || !tokens[0].equals("true")) break block13;
                IClasspathEntry[] classpathEntries = project.fProject.getRawClasspath();
                ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
                IClasspathEntry[] iClasspathEntryArray = classpathEntries;
                int n = classpathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classpathEntrie;
                    IClasspathEntry classpathEntry = classpathEntrie = iClasspathEntryArray[n2];
                    switch (classpathEntry.getEntryKind()) {
                        case 3: {
                            String containerPath = classpathEntry.getPath().removeFirstSegments(1).toString();
                            IApiTypeContainer container = ProjectComponent.getApiTypeContainer(containerPath, project, outputLocationToContainer);
                            if (container == null || containers.contains(container)) break;
                            containers.add(container);
                            break;
                        }
                        case 4: {
                            classpathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
                        }
                        case 1: {
                            IPath path = classpathEntry.getPath();
                            if (!Util.isArchive(path.lastSegment())) break;
                            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                            if (resource != null) {
                                containers.add(new ArchiveApiTypeContainer(project, resource.getLocation().toOSString()));
                                break;
                            }
                            containers.add(new ArchiveApiTypeContainer(project, path.toOSString()));
                            break;
                        }
                    }
                    ++n2;
                }
                if (containers.isEmpty()) break block13;
                IApiTypeContainer cfc = null;
                cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(project, containers);
                pathToOutputContainers.put(".", cfc);
                break block13;
            }
            IBuildEntry[] entries = build.getBuildEntries();
            int length = entries.length;
            int i = 0;
            while (i < length) {
                IBuildEntry buildEntry = entries[i];
                String name = buildEntry.getName();
                if (name.startsWith("source.")) {
                    ProjectComponent.retrieveContainers(name, "source.", buildEntry, project, pathToOutputContainers, outputLocationToContainer);
                } else if (name.startsWith(EXTRA_PREFIX)) {
                    ProjectComponent.retrieveContainers(name, EXTRA_PREFIX, buildEntry, project, pathToOutputContainers, outputLocationToContainer);
                }
                ++i;
            }
        }
    }

    private static void retrieveContainers(String name, String prefix, IBuildEntry buildEntry, ProjectComponent project, Map<String, IApiTypeContainer> pathToOutputContainers, Map<IPath, IApiTypeContainer> outputLocationToContainer) throws CoreException {
        String jar = name.substring(prefix.length());
        String[] tokens = buildEntry.getTokens();
        if (tokens.length == 1) {
            IApiTypeContainer container = ProjectComponent.getApiTypeContainer(tokens[0], project, outputLocationToContainer);
            if (container != null) {
                IApiTypeContainer existingContainer = pathToOutputContainers.get(jar);
                if (existingContainer != null) {
                    ArrayList<IApiTypeContainer> allContainers = new ArrayList<IApiTypeContainer>();
                    allContainers.add(existingContainer);
                    allContainers.add(container);
                    CompositeApiTypeContainer apiTypeContainer = new CompositeApiTypeContainer(project, allContainers);
                    pathToOutputContainers.put(jar, apiTypeContainer);
                } else {
                    pathToOutputContainers.put(jar, container);
                }
            }
        } else {
            ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
            String[] stringArray = tokens;
            int n = tokens.length;
            int allContainers = 0;
            while (allContainers < n) {
                String currentToken = stringArray[allContainers];
                IApiTypeContainer container = ProjectComponent.getApiTypeContainer(currentToken, project, outputLocationToContainer);
                if (container != null && !containers.contains(container)) {
                    containers.add(container);
                }
                ++allContainers;
            }
            if (!containers.isEmpty()) {
                IApiTypeContainer existingContainer = pathToOutputContainers.get(jar);
                if (existingContainer != null) {
                    containers.add(existingContainer);
                }
                IApiTypeContainer cfc = null;
                cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(project, containers);
                pathToOutputContainers.put(jar, cfc);
            }
        }
    }

    @Override
    protected IApiTypeContainer createApiTypeContainer(String path) throws CoreException {
        IApiTypeContainer container;
        if (this.isDisposed() || this.fPathToOutputContainers == null) {
            this.baselineDisposed(this.getBaseline());
        }
        if ((container = this.fPathToOutputContainers.get(path)) == null) {
            container = this.findApiTypeContainer(path);
        }
        return container;
    }

    private IApiTypeContainer findApiTypeContainer(String location) {
        IResource res = this.fProject.getProject().findMember(IPath.fromOSString((String)location));
        if (res != null) {
            if (res.getType() == 1) {
                return new ArchiveApiTypeContainer(this, res.getLocation().toOSString());
            }
            return new DirectoryApiTypeContainer(this, res.getLocation().toOSString());
        }
        return null;
    }

    private static IApiTypeContainer getApiTypeContainer(String location, ProjectComponent component, Map<IPath, IApiTypeContainer> outputLocationToContainer) throws CoreException {
        IPackageFragmentRoot root;
        IJavaProject project = component.fProject;
        IResource res = project.getProject().findMember(IPath.fromOSString((String)location));
        if (res != null && (root = project.getPackageFragmentRoot(res)).exists()) {
            if (root.getKind() == 2) {
                if (res.getType() == 2) {
                    IPath location2 = res.getLocation();
                    IApiTypeContainer cfc = outputLocationToContainer.get(location2);
                    if (cfc == null) {
                        cfc = new ProjectTypeContainer(component, (IContainer)res);
                        outputLocationToContainer.put(location2, cfc);
                    }
                    return cfc;
                }
            } else {
                IApiTypeContainer cfc;
                IClasspathEntry entry = root.getRawClasspathEntry();
                IPath outputLocation = entry.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = project.getOutputLocation();
                }
                if ((cfc = outputLocationToContainer.get(outputLocation)) == null) {
                    IPath projectFullPath = project.getProject().getFullPath();
                    Object container = null;
                    container = projectFullPath.equals((Object)outputLocation) ? project.getProject() : project.getProject().getWorkspace().getRoot().getFolder(outputLocation);
                    cfc = new ProjectTypeContainer(component, (IContainer)container);
                    outputLocationToContainer.put(outputLocation, cfc);
                }
                return cfc;
            }
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public IApiTypeContainer getTypeContainer(IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() == 1) {
            if (this.isDisposed()) {
                this.baselineDisposed(this.getBaseline());
            }
            this.getApiTypeContainers();
            IResource resource = root.getResource();
            if (resource != null) {
                String location = resource.getProjectRelativePath().toString();
                return ProjectComponent.getApiTypeContainer(location, this, this.fOutputLocationToContainer);
            }
        }
        return null;
    }
}

