/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.osgi.util.NLS;

public class StringUtil {
    private static final String maxIntValue = Integer.toString(Integer.MAX_VALUE);
    private static final int maxIntSize = maxIntValue.length();
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    private static final char[] nibble2uchex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static @NonNull String defaultIndentation = "    ";

    public static void appendIndentation(@NonNull StringBuilder s, int depth) {
        StringUtil.appendIndentation(s, depth, defaultIndentation);
    }

    public static void appendIndentation(@NonNull StringBuilder s, int depth, @NonNull String string) {
        if (depth >= 0) {
            s.append("\n");
        }
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
    }

    public static void appendMultiplicity(@NonNull StringBuilder s, long lower, long upper, boolean isNullFree) {
        s.append("[");
        if (upper < 0L) {
            if (lower == 1L) {
                s.append("+");
            } else {
                if (lower != 0L) {
                    s.append(lower);
                    s.append("..");
                }
                s.append("*");
            }
        } else if (lower == 0L && upper == 1L) {
            s.append("?");
        } else {
            s.append(lower);
            if (lower != upper) {
                s.append("..");
                s.append(upper);
            }
        }
        s.append("|");
        s.append(isNullFree ? "1" : "?");
        s.append("]");
    }

    @Deprecated
    public static void appendMultiplicity(@NonNull StringBuilder s, long lower, long upper) {
        StringUtil.appendMultiplicity(s, lower, upper, false);
    }

    public static @NonNull String bind(String messageTemplate, Object ... bindings) {
        @NonNull String result = NLS.bind((String)messageTemplate, (Object[])bindings);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static @NonNull String convertFromOCLString(@NonNull String oclString) {
        s = null;
        iMax = oclString.length();
        i = 0;
        while (i < iMax) {
            block20: {
                block19: {
                    c = oclString.charAt(i);
                    if (c != '\\') break block19;
                    if (s == null) {
                        s = new StringBuilder(iMax);
                        s.append(oclString, 0, i);
                    }
                    iStart = i++;
                    if (i >= iMax) break block20;
                    c = oclString.charAt(i);
                    switch (c) {
                        case 't': {
                            s.append('\t');
                            ** break;
                        }
                        case 'n': {
                            s.append('\n');
                            ** break;
                        }
                        case 'r': {
                            s.append('\r');
                            ** break;
                        }
                        case 'f': {
                            s.append('\f');
                            ** break;
                        }
                        case 'b': {
                            s.append('\b');
                            ** break;
                        }
                        case 'u': {
                            if (i + 4 < iMax) {
                                value = 0;
                                j = 0;
                                while (j < 4) {
                                    if ('0' <= (c = oclString.charAt(++i)) && c <= '9') {
                                        value = 16 * value + c - 48;
                                    } else if ('A' <= c && c <= 'F') {
                                        value = 16 * value + c - 65 + 10;
                                    } else if ('a' <= c && c <= 'f') {
                                        value = 16 * value + c - 97 + 10;
                                    } else {
                                        throw new IllegalArgumentException("Malformed Unicode escape: " + oclString.substring(iStart, i + 1 - iStart) + ".");
                                    }
                                    ++j;
                                }
                                s.append((char)value);
                                ** break;
                            }
                            break block20;
                        }
                        default: {
                            s.append(c);
                            ** break;
                        }
                    }
lbl61:
                    // 7 sources

                    break block20;
                }
                if (s != null) {
                    s.append(c);
                }
            }
            ++i;
        }
        return s != null ? s.toString() : oclString;
    }

    public static String convertToOCLString(String theString) {
        if (theString == null) {
            return null;
        }
        StringBuilder s = null;
        int iMax = theString.length();
        int i = 0;
        while (i < iMax) {
            char c = theString.charAt(i);
            switch (c) {
                case '\t': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\t");
                    break;
                }
                case '\n': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\n");
                    break;
                }
                case '\r': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\r");
                    break;
                }
                case '\f': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\f");
                    break;
                }
                case '\b': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\b");
                    break;
                }
                case '\'': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\'");
                    break;
                }
                case '\\': {
                    s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\\\");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        s = StringUtil.convertToOCLStringLazyStringBuilder(s, theString, i, "\\u");
                        s.append(nibble2uchex[c >> 12 & 0xF]);
                        s.append(nibble2uchex[c >> 8 & 0xF]);
                        s.append(nibble2uchex[c >> 4 & 0xF]);
                        s.append(nibble2uchex[c & 0xF]);
                        break;
                    }
                    if (s == null) break;
                    s.append(c);
                }
            }
            ++i;
        }
        return s != null ? s.toString() : theString;
    }

    private static @NonNull StringBuilder convertToOCLStringLazyStringBuilder(@Nullable StringBuilder s, @NonNull String theString, int theIndex, @NonNull String suffix) {
        if (s == null) {
            int length = theString.length();
            s = (length += 1 + length / 10) < 0 ? new StringBuilder() : new StringBuilder(length);
            s.append(theString, 0, theIndex);
        }
        s.append(suffix);
        return s;
    }

    public static @NonNull Number createNumberFromString(@NonNull String aValue) throws NumberFormatException {
        if ("*".equals(aValue)) {
            return Unlimited.INSTANCE;
        }
        int len = aValue.length();
        if (len < maxIntSize || len == maxIntSize && maxIntValue.compareTo(aValue) >= 0) {
            Integer result = Integer.valueOf(aValue);
            assert (result != null);
            return result;
        }
        if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
            Long result = Long.valueOf(aValue);
            assert (result != null);
            return result;
        }
        return new BigInteger(aValue);
    }

    public static @NonNull String formatMultiplicity(@Nullable ETypedElement typedElement) {
        int upper;
        if (typedElement == null) {
            return "";
        }
        int lower = typedElement.getLowerBound();
        if (lower == (upper = typedElement.getUpperBound())) {
            return Integer.toString(lower);
        }
        if (lower == 0) {
            if (upper < 0) {
                return "*";
            }
            if (upper == 1) {
                return "?";
            }
        } else if (lower == 1 && upper < 0) {
            return "+";
        }
        return String.valueOf(Integer.toString(lower)) + ".." + (upper >= 0 ? Integer.toString(upper) : "*");
    }

    public static @NonNull String formatOrdered(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isOrdered() && typedElement.isMany() : false;
        return isOrdered ? "{ordered}" : "";
    }

    public static @NonNull String formatString(@Nullable String name) {
        return name != null ? name : "<null>";
    }

    public static @NonNull String formatUnique(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isUnique() && typedElement.isMany() : false;
        return isOrdered ? "{unique}" : "";
    }

    public static String getIndentation(int depth, @NonNull String string) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
        return s.toString();
    }

    public static String splice(List<String> strings, String separator) {
        if (strings == null) {
            return null;
        }
        int iMax = strings.size();
        if (iMax <= 0) {
            return "";
        }
        if (iMax == 1) {
            return strings.get(0);
        }
        StringBuilder s = new StringBuilder();
        s.append(strings.get(0));
        int i = 1;
        while (i < iMax) {
            s.append(separator);
            s.append(strings.get(i));
            ++i;
        }
        return s.toString();
    }

    @Deprecated
    public static char toHex(int value) {
        int nibble = value & 0xF;
        return nibble2uchex[nibble];
    }
}

