/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.Map;
import java.util.TreeMap;
import org.codelibs.nekohtml.parsers.SAXParser;
import org.codelibs.xerces.xerces.xni.Augmentations;
import org.codelibs.xerces.xerces.xni.QName;
import org.codelibs.xerces.xerces.xni.XMLAttributes;
import org.codelibs.xerces.xerces.xni.XMLString;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;

class HTMLSAXParser
extends SAXParser
implements DevHelpSAXParser {
    private boolean begin;
    private boolean returnType;
    private boolean protoStart;
    private boolean parmStart;
    private boolean descStart;
    private boolean rowIgnore;
    private boolean srcLink;
    private boolean valid = true;
    private Map<String, String> funcs;
    private String returnValue;
    private String funcName;
    private String rowTag;
    private StringBuilder prototype = new StringBuilder();
    private StringBuilder description = new StringBuilder();
    private int divCounter;
    private int rowItemCount;
    private TreeMap<String, FunctionInfo> infos = new TreeMap();

    public HTMLSAXParser(Map<String, String> funcs) {
        this.funcs = funcs;
    }

    public void startElement(QName name, XMLAttributes a, Augmentations aug) {
        String classValue;
        if ("A".equals(name.rawname) && (classValue = a.getValue("class")) != null) {
            if (classValue.equals("anchor")) {
                String href = a.getValue("href");
                if (href != null) {
                    if (href.equals("#declaration")) {
                        String mapName = this.funcs.get("name");
                        if (mapName != null) {
                            this.funcName = mapName.trim();
                            if (this.funcName.endsWith("()")) {
                                this.funcName = this.funcName.replaceAll("\\(\\)", "").replaceAll("\\p{javaSpaceChar}", "");
                            }
                            this.begin = true;
                        }
                    } else if (href.equals("#description")) {
                        this.descStart = true;
                    } else if (href.equals("#return-value")) {
                        this.descStart = true;
                    } else if (href.equals("#parameters")) {
                        this.description.append("<br><br><h4>Parameters:</h4>");
                        this.descStart = true;
                    }
                }
            } else if (classValue.equals("srclink")) {
                this.srcLink = true;
            }
        }
        if (this.begin) {
            String type;
            if ("DIV".equals(name.rawname)) {
                ++this.divCounter;
            }
            if (!this.descStart && "SPAN".equals(name.rawname)) {
                type = a.getValue("class");
                if (this.returnValue == null && type != null && type.equals("n")) {
                    this.returnType = true;
                }
            }
            if (this.protoStart) {
                if ("P".equals(name.rawname)) {
                    this.protoStart = false;
                    this.descStart = true;
                    this.description.append("<p>");
                }
            } else if (this.descStart) {
                if ("P".equals(name.rawname)) {
                    this.description.append("<p>");
                } else if ("TABLE".equals(name.rawname)) {
                    this.description.append("<dl>");
                } else if ("TR".equals(name.rawname)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(name.rawname)) {
                    type = a.getValue("class");
                    if (type != null && type.equals("listing_lines")) {
                        this.rowIgnore = true;
                    } else {
                        this.rowIgnore = false;
                        this.rowTag = this.rowItemCount++ == 0 ? "<dt>" : "<dd>";
                        this.description.append(this.rowTag);
                    }
                } else {
                    "H4".equals(name.rawname);
                }
            }
        }
    }

    public void endElement(QName name, Augmentations aug) {
        if (this.srcLink) {
            if ("A".equals(name.rawname)) {
                this.srcLink = false;
            }
        } else if (this.begin) {
            if ("DIV".equals(name.rawname)) {
                --this.divCounter;
                if (this.divCounter <= 0) {
                    this.descStart = false;
                    this.parmStart = false;
                    this.protoStart = false;
                }
            } else if ("SECTION".equals(name.rawname) && this.valid && this.returnValue != null && !this.returnValue.startsWith("#") && !this.returnValue.startsWith("typedef ")) {
                FunctionInfo info = new FunctionInfo(this.funcName);
                info.setReturnType(this.returnValue);
                info.setPrototype(this.prototype.toString());
                info.setDescription(this.description.toString());
                this.infos.put(this.funcName, info);
                throw new FuncFoundSaxException();
            }
            if (this.descStart) {
                if ("P".equals(name.rawname)) {
                    this.description.append("</p>");
                } else if ("TABLE".equals(name.rawname)) {
                    this.description.append("</dl>");
                } else if ("TR".equals(name.rawname)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(name.rawname)) {
                    if (!this.rowIgnore) {
                        if (this.rowTag != null && this.rowTag.equals("<dt>")) {
                            this.description.append("</dt>");
                        } else {
                            this.description.append("</dd>");
                        }
                    }
                    this.rowIgnore = false;
                }
            }
        }
    }

    public void characters(XMLString data, Augmentations aug) {
        if (this.begin && !this.srcLink) {
            if (this.returnType) {
                this.returnValue = "";
                String tmp = data.toString().trim();
                boolean completed = false;
                if (tmp.endsWith(");")) {
                    completed = true;
                    tmp = tmp.substring(0, tmp.length() - 2);
                }
                String[] tokens = tmp.split("\\s+");
                String separator = "";
                this.protoStart = true;
                int i = 0;
                while (i < tokens.length) {
                    String token = tokens[i];
                    if (token.equals(this.funcName)) {
                        separator = "";
                        int j = i + 1;
                        while (j < tokens.length) {
                            String jtoken = tokens[j];
                            if (j == i + 1 && jtoken.charAt(0) == '(') {
                                jtoken = jtoken.substring(1);
                                this.parmStart = true;
                                this.protoStart = false;
                            }
                            this.prototype.append(separator).append(jtoken);
                            separator = " ";
                            ++j;
                        }
                        if (!this.parmStart || !completed) break;
                        this.parmStart = false;
                        this.descStart = true;
                        break;
                    }
                    this.returnValue = String.valueOf(this.returnValue) + separator + token;
                    separator = " ";
                    ++i;
                }
                this.returnType = false;
            } else if (this.protoStart) {
                String temp = data.toString().trim();
                boolean completed = false;
                if (temp.endsWith(");")) {
                    completed = true;
                    temp = temp.substring(0, temp.length() - 2);
                }
                String separator = " ";
                while (temp.startsWith("*") || temp.startsWith("const")) {
                    if (temp.charAt(0) == '*') {
                        this.returnValue = String.valueOf(this.returnValue) + separator + "*";
                        temp = temp.substring(1).trim();
                        separator = "";
                        continue;
                    }
                    this.returnValue = String.valueOf(this.returnValue) + "const";
                    temp = temp.substring(5).trim();
                    separator = " ";
                }
                int index = temp.lastIndexOf(40);
                int index2 = temp.lastIndexOf(41);
                if (index2 < index) {
                    if (index + 1 < temp.length()) {
                        temp = temp.substring(index + 1).trim();
                        this.prototype.append(temp);
                    }
                    this.parmStart = true;
                    this.protoStart = false;
                }
                if (this.parmStart && completed) {
                    this.parmStart = false;
                    this.descStart = true;
                }
            } else if (this.parmStart) {
                String parmData = data.toString().trim();
                int index = parmData.indexOf(41);
                if (index >= 0) {
                    this.parmStart = false;
                    this.descStart = true;
                    parmData = parmData.substring(0, index);
                }
                if (this.prototype.length() == 0 && !parmData.equals(",") && !parmData.isEmpty()) {
                    parmData = " " + parmData;
                }
                this.prototype.append(parmData);
            } else if (this.descStart && !this.rowIgnore) {
                this.description.append(String.valueOf(data));
            }
        }
    }

    @Override
    public TreeMap<String, FunctionInfo> getFunctionInfos() {
        return this.infos;
    }

    public String toString() {
        return "funcName: <" + this.funcName + "> returnType: <" + this.returnValue + "> prototype: <" + this.prototype + "> description: " + this.description;
    }
}

