/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.binutils.utils.STBinutilsFactoryManager;
import org.eclipse.linuxtools.binutils.utils.STStrings;
import org.eclipse.linuxtools.internal.Activator;

public class STSymbolManager {
    private static final long AUTO_DISPOSE_TIMEOUT = 30000L;
    public static final STSymbolManager sharedInstance = new STSymbolManager();
    private final HashMap<IBinaryParser.IBinaryObject, AutoDisposeAddr2line> addr2lines = new HashMap();
    private final HashMap<String, AutoDisposeCPPFilt> cppfilts = new HashMap();

    private STSymbolManager() {
        Runnable worker = () -> {
            try {
                while (true) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                    this.cleanup();
                }
            }
            catch (Exception e2) {
                IStatus s = Status.error((String)e2.getMessage(), (Throwable)e2);
                Activator.getDefault().getLog().log(s);
            }
        };
        new Thread(worker, "ST System Analysis Symbol Manager").start();
    }

    public synchronized void reset() {
        Iterator<Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line>> iter = this.addr2lines.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line> entry = iter.next();
            AutoDisposeAddr2line ada2l = entry.getValue();
            ada2l.addr2line.dispose();
            ada2l.addr2line = null;
            iter.remove();
        }
        for (Map.Entry<String, AutoDisposeCPPFilt> entry : this.cppfilts.entrySet()) {
            AutoDisposeCPPFilt adcppf = entry.getValue();
            adcppf.cppfilt.dispose();
            adcppf.cppfilt = null;
        }
    }

    private synchronized void cleanup() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line>> iter = this.addr2lines.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line> entry = iter.next();
            AutoDisposeAddr2line ada2l = entry.getValue();
            long diff = currentTime - ada2l.startTime;
            if (diff <= 30000L) continue;
            if (ada2l.addr2line != null) {
                ada2l.addr2line.dispose();
                ada2l.addr2line = null;
            }
            iter.remove();
        }
        Iterator<Map.Entry<String, AutoDisposeCPPFilt>> iter2 = this.cppfilts.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry<String, AutoDisposeCPPFilt> entry = iter2.next();
            AutoDisposeCPPFilt adcppf = entry.getValue();
            long diff = currentTime - adcppf.startTime;
            if (diff <= 30000L) continue;
            if (adcppf.cppfilt != null) {
                adcppf.cppfilt.dispose();
                adcppf.cppfilt = null;
            }
            iter2.remove();
        }
    }

    public synchronized String demangle(IBinaryParser.ISymbol symbol, IProject project) {
        String cpu = symbol.getBinaryObject().getCPU();
        String symbolName = symbol.getName();
        return this.demangleImpl(symbolName, cpu, project);
    }

    public synchronized String demangle(IBinaryParser.IBinaryObject program, String symbolName, IProject project) {
        String cpu = program.getCPU();
        return this.demangleImpl(symbolName, cpu, project);
    }

    private synchronized String demangleImpl(String symbolName, String cpu, IProject project) {
        CPPFilt cppfilt = this.getCppFilt(cpu, project);
        if (cppfilt != null && (symbolName.startsWith("_Z") || symbolName.startsWith("_G"))) {
            try {
                symbolName = cppfilt.getFunction(symbolName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return symbolName;
    }

    public synchronized int getLineNumber(IBinaryParser.IBinaryObject program, IAddress address, IProject project) {
        Addr2line addr2line = this.getAddr2line(program, project);
        if (addr2line == null) {
            return -1;
        }
        try {
            return addr2line.getLineNumber(address);
        }
        catch (IOException e) {
            return -1;
        }
    }

    public int getLineNumber(IBinaryParser.ISymbol symbol, IProject project) {
        IBinaryParser.IBinaryObject obj = symbol.getBinaryObject();
        IAddress address = symbol.getAddress();
        return this.getLineNumber(obj, address, project);
    }

    public synchronized String getFileName(IBinaryParser.IBinaryObject program, IAddress address, IProject project) {
        Addr2line addr2line = this.getAddr2line(program, project);
        if (addr2line == null) {
            return null;
        }
        try {
            return addr2line.getFileName(address);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFilename(IBinaryParser.ISymbol symbol, IProject project) {
        IBinaryParser.IBinaryObject obj = symbol.getBinaryObject();
        IAddress address = symbol.getAddress();
        return this.getFileName(obj, address, project);
    }

    private synchronized CPPFilt getCppFilt(String cpu, IProject project) {
        AutoDisposeCPPFilt adCppfilt = this.cppfilts.get(cpu);
        if (adCppfilt == null) {
            adCppfilt = new AutoDisposeCPPFilt();
            this.cppfilts.put(cpu, adCppfilt);
        }
        if (adCppfilt.cppfilt == null) {
            try {
                adCppfilt.cppfilt = STBinutilsFactoryManager.getCPPFilt(cpu, project);
            }
            catch (IOException e) {
                return null;
            }
        }
        adCppfilt.startTime = System.currentTimeMillis();
        return adCppfilt.cppfilt;
    }

    private synchronized Addr2line getAddr2line(IBinaryParser.IBinaryObject program, IProject project) {
        AutoDisposeAddr2line adAddr2line = this.addr2lines.get(program);
        if (adAddr2line == null) {
            adAddr2line = new AutoDisposeAddr2line();
            this.addr2lines.put(program, adAddr2line);
        }
        if (adAddr2line.addr2line == null) {
            try {
                adAddr2line.addr2line = STBinutilsFactoryManager.getAddr2line(program.getCPU(), program.getPath().toOSString(), project);
            }
            catch (IOException e) {
                return null;
            }
        }
        adAddr2line.startTime = System.currentTimeMillis();
        return adAddr2line.addr2line;
    }

    public synchronized STStrings getStrings(IBinaryParser.IBinaryObject program, IProject project) {
        STStrings strings = null;
        try {
            strings = STBinutilsFactoryManager.getStrings(program.getCPU(), project);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return strings;
    }

    public IBinaryParser.IBinaryObject getBinaryObject(String loc) {
        Path path = new Path(loc);
        return this.getBinaryObject((IPath)path);
    }

    public IBinaryParser.IBinaryObject getBinaryObject(IPath path) {
        return this.getBinaryObject(path, null);
    }

    private IBinaryParser.IBinaryObject getBinaryObject(IPath path, IBinaryParser defaultparser) {
        IBinaryParser.IBinaryObject ret;
        LinkedList<IBinaryParser> parsers;
        IFile c = this.findFileFromPath(path);
        if (c != null) {
            IBinaryParser.IBinaryObject object = this.getAlreadyExistingBinaryObject(c);
            if (object != null) {
                return object;
            }
            parsers = this.getBinaryParser(c.getProject());
        } else {
            parsers = new LinkedList<IBinaryParser>();
        }
        if (defaultparser == null) {
            try {
                defaultparser = CCorePlugin.getDefault().getDefaultBinaryParser();
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        if (defaultparser != null) {
            parsers.add(defaultparser);
        }
        if ((ret = this.buildBinaryObject(path, parsers)) == null) {
            parsers.clear();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                if (extension != null) {
                    IConfigurationElement[] element;
                    IConfigurationElement[] iConfigurationElementArray = element = extension.getConfigurationElements();
                    int n3 = element.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element2 = iConfigurationElementArray[n4];
                        if (element2.getName().equalsIgnoreCase("cextension")) {
                            try {
                                IBinaryParser parser = (IBinaryParser)element2.createExecutableExtension("run");
                                parsers.add(parser);
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ret = this.buildBinaryObject(path, parsers);
        }
        return ret;
    }

    public IResource findOneAndOnlyBinary(IPath file) {
        ICProject cproject;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource binary = null;
        IProject project = sharedInstance.getProjectFromFile(file);
        if (project != null && project.exists() && (cproject = (ICProject)CoreModel.getDefault().create((IResource)project)) != null) {
            try {
                IBinary[] bs = cproject.getBinaryContainer().getBinaries();
                if (bs.length == 1) {
                    binary = bs[0].getResource();
                }
            }
            catch (CModelException e) {
                String message = "Error getting binaries for [" + cproject.toString() + "]";
                CCorePlugin.log((String)message, (Throwable)e);
            }
        }
        if (binary == null) {
            IProject[] projects;
            ArrayList<IResource> binaries = new ArrayList<IResource>();
            IProject[] iProjectArray = projects = root.getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                ICProject cproject2 = CoreModel.getDefault().create(prj);
                if (cproject2 != null) {
                    try {
                        IBinaryParser.IBinaryObject binObj;
                        IBinary[] bs = cproject2.getBinaryContainer().getBinaries();
                        if (bs.length == 1 && (binObj = sharedInstance.getBinaryObject(bs[0].getPath())) != null) {
                            binaries.add(bs[0].getResource());
                        }
                    }
                    catch (CModelException e) {
                        String message = "Error getting binaries for [" + cproject2.toString() + "]";
                        CCorePlugin.log((String)message, (Throwable)e);
                    }
                }
                ++n2;
            }
            if (binaries.size() == 1) {
                binary = (IResource)binaries.get(0);
            }
        }
        return binary;
    }

    public IFile findFileFromPath(IPath file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(URIUtil.toURI((IPath)file));
        if (files.length == 0 || files.length > 1) {
            return null;
        }
        return files[0];
    }

    public IProject getProjectFromFile(IPath file) {
        IFile ifile = this.findFileFromPath(file);
        if (ifile == null) {
            return null;
        }
        return ifile.getProject();
    }

    /*
     * WARNING - void declaration
     */
    private IBinaryParser.IBinaryObject validateBinary(IBinaryParser.IBinaryFile o) {
        IBinaryParser.IBinaryFile iBinaryFile = o;
        if (iBinaryFile instanceof IBinaryParser.IBinaryObject) {
            void object;
            IBinaryParser.IBinaryObject iBinaryObject = (IBinaryParser.IBinaryObject)iBinaryFile;
            IBinaryParser.IBinaryObject cfr_ignored_0 = (IBinaryParser.IBinaryObject)iBinaryFile;
            String s = object.getCPU();
            if (s != null && !s.isEmpty()) {
                return object;
            }
        }
        return null;
    }

    private IBinaryParser.IBinaryObject buildBinaryObject(IPath path, List<IBinaryParser> parsers) {
        for (IBinaryParser iBinaryParser : parsers) {
            IBinaryParser.IBinaryObject o = this.buildBinaryObject(path, iBinaryParser);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private IBinaryParser.IBinaryObject buildBinaryObject(IPath path, IBinaryParser parser) {
        if (parser == null) {
            return null;
        }
        IBinaryParser.IBinaryFile bf = null;
        try {
            bf = parser.getBinary(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.validateBinary(bf);
    }

    private IBinaryParser.IBinaryObject getAlreadyExistingBinaryObject(IFile c) {
        ICProject cproject;
        IProject project = c.getProject();
        if (project != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IBinary[] b;
                IBinary[] iBinaryArray = b = cproject.getBinaryContainer().getBinaries();
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinary binary = iBinaryArray[n2];
                    IResource r = binary.getResource();
                    if (r.equals((Object)c)) {
                        IBinaryParser.IBinaryObject binaryObject = (IBinaryParser.IBinaryObject)binary.getAdapter(IBinaryParser.IBinaryObject.class);
                        return this.validateBinary((IBinaryParser.IBinaryFile)binaryObject);
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private List<IBinaryParser> getBinaryParser(IProject project) {
        LinkedList<IBinaryParser> parsers = new LinkedList<IBinaryParser>();
        ICProjectDescription projDesc = CCorePlugin.getDefault().getProjectDescription(project);
        if (projDesc == null) {
            return parsers;
        }
        ICConfigurationDescription[] cfgs = projDesc.getConfigurations();
        String[] binaryParserIds = CoreModelUtil.getBinaryParserIds((ICConfigurationDescription[])cfgs);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        String[] stringArray = binaryParserIds;
        int n = binaryParserIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IExtension extension = extensionPoint.getExtension(id);
            if (extension != null) {
                IConfigurationElement[] element;
                IConfigurationElement[] iConfigurationElementArray = element = extension.getConfigurationElements();
                int n3 = element.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element2 = iConfigurationElementArray[n4];
                    if (element2.getName().equalsIgnoreCase("cextension")) {
                        try {
                            IBinaryParser parser = (IBinaryParser)element2.createExecutableExtension("run");
                            if (parser != null) {
                                parsers.add(parser);
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return parsers;
    }

    private static final class AutoDisposeAddr2line {
        private Addr2line addr2line;
        private long startTime;

        private AutoDisposeAddr2line() {
        }
    }

    private static final class AutoDisposeCPPFilt {
        private CPPFilt cppfilt;
        private long startTime;

        private AutoDisposeCPPFilt() {
        }
    }
}

