/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.CurrentBrowser;
import org.eclipse.osgi.util.NLS;

public class BrowserManager {
    public static final String DEFAULT_BROWSER_ID_KEY = "default_browser";
    public static final String BROWSER_ID_CUSTOM = "org.eclipse.help.base.custombrowser";
    public static final String BROWSER_ID_FIREFOX = "org.eclipse.help.base.firefox";
    public static final String BROWSER_ID_MAC_SYSTEM = "org.eclipse.help.base.defaultBrowserMacOSX";
    public static final String BROWSER_ID_EMBEDDED = "org.eclipse.help.ui.embeddedbrowser";
    public static final String BROWSER_ID_SYSTEM = "org.eclipse.help.ui.systembrowser";
    private static BrowserManager instance;
    private boolean initialized = false;
    private BrowserDescriptor currentBrowserDesc;
    private BrowserDescriptor defaultBrowserDesc;
    private BrowserDescriptor[] browsersDescriptors;
    private BrowserDescriptor internalBrowserDesc;
    private Collection<IBrowser> browsers = new ArrayList<IBrowser>();
    private boolean alwaysUseExternal = false;

    private BrowserManager() {
    }

    private void init() {
        String curBrowserID;
        this.initialized = true;
        this.browsersDescriptors = this.createBrowserDescriptors();
        IEclipsePreferences defaultPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.help.base");
        String defBrowserID = defaultPreferences.get(DEFAULT_BROWSER_ID_KEY, null);
        if (defBrowserID != null && !"".equals(defBrowserID)) {
            this.setDefaultBrowserID(defBrowserID);
        }
        String os = Platform.getOS();
        if (this.defaultBrowserDesc == null) {
            if ("win32".equalsIgnoreCase(os)) {
                this.setDefaultBrowserID(BROWSER_ID_SYSTEM);
            } else if ("linux".equalsIgnoreCase(os)) {
                this.setDefaultBrowserID(BROWSER_ID_FIREFOX);
            } else if ("macosx".equalsIgnoreCase(os)) {
                this.setDefaultBrowserID(BROWSER_ID_MAC_SYSTEM);
            }
        }
        if (this.defaultBrowserDesc == null) {
            int i = 0;
            while (i < this.browsersDescriptors.length) {
                if (BROWSER_ID_CUSTOM.equals(this.browsersDescriptors[i].getID())) {
                    this.defaultBrowserDesc = this.browsersDescriptors[i];
                }
                ++i;
            }
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID(BROWSER_ID_CUSTOM);
        }
        if (this.defaultBrowserDesc == null) {
            this.defaultBrowserDesc = new BrowserDescriptor("", "Null Browser", new IBrowserFactory(){

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public IBrowser createBrowser() {
                    return new IBrowser(){

                        @Override
                        public void close() {
                        }

                        @Override
                        public void displayURL(String url) {
                            ILog.of(this.getClass()).error("There is no browser adapter configured to display " + url + ".  Ensure that you have a required browser and adapter installed, and that the browser program is available on the system path.", null);
                            String msg = NLS.bind((String)HelpBaseResources.no_browsers, (Object)url);
                            BaseHelpSystem.getDefaultErrorUtil().displayError(msg);
                        }

                        @Override
                        public boolean isCloseSupported() {
                            return false;
                        }

                        @Override
                        public boolean isSetLocationSupported() {
                            return false;
                        }

                        @Override
                        public boolean isSetSizeSupported() {
                            return false;
                        }

                        @Override
                        public void setLocation(int width, int height) {
                        }

                        @Override
                        public void setSize(int x, int y) {
                        }
                    };
                }
            });
        }
        if ((curBrowserID = Platform.getPreferencesService().getString("org.eclipse.help.base", DEFAULT_BROWSER_ID_KEY, null, null)) != null && !"".equals(curBrowserID)) {
            this.setCurrentBrowserID(curBrowserID);
        }
        if (this.currentBrowserDesc == null) {
            this.setCurrentBrowserID(this.getDefaultBrowserID());
        }
        this.setAlwaysUseExternal(Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "always_external_browser", false, null));
    }

    public static BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserDescriptor[] createBrowserDescriptors() {
        if (this.browsersDescriptors != null) {
            return this.browsersDescriptors;
        }
        ArrayList<BrowserDescriptor> bDescriptors = new ArrayList<BrowserDescriptor>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.base", "browser");
        int i = 0;
        while (i < configElements.length) {
            String label;
            String id;
            if (configElements[i].getName().equals("browser") && (id = configElements[i].getAttribute("id")) != null && (label = configElements[i].getAttribute("name")) != null) {
                try {
                    Object adapter = configElements[i].createExecutableExtension("factoryclass");
                    if (adapter instanceof IBrowserFactory && ((IBrowserFactory)adapter).isAvailable()) {
                        BrowserDescriptor descriptor = new BrowserDescriptor(id, label, (IBrowserFactory)adapter);
                        if (descriptor.isExternal()) {
                            bDescriptors.add(descriptor);
                        } else {
                            this.internalBrowserDesc = descriptor;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        this.browsersDescriptors = bDescriptors.toArray(new BrowserDescriptor[bDescriptors.size()]);
        return this.browsersDescriptors;
    }

    public BrowserDescriptor[] getBrowserDescriptors() {
        if (!this.initialized) {
            this.init();
        }
        return this.browsersDescriptors;
    }

    public String getCurrentBrowserID() {
        if (!this.initialized) {
            this.init();
        }
        if (this.currentBrowserDesc == null) {
            return null;
        }
        return this.currentBrowserDesc.getID();
    }

    public String getCurrentInternalBrowserID() {
        if (!this.initialized) {
            this.init();
        }
        if (this.isEmbeddedBrowserPresent() && !this.alwaysUseExternal) {
            return this.internalBrowserDesc.getID();
        }
        return this.getCurrentBrowserID();
    }

    public String getDefaultBrowserID() {
        if (!this.initialized) {
            this.init();
        }
        if (this.defaultBrowserDesc == null) {
            return null;
        }
        return this.defaultBrowserDesc.getID();
    }

    public void setCurrentBrowserID(String currentAdapterID) {
        if (!this.initialized) {
            this.init();
        }
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(currentAdapterID)) {
                this.currentBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    private void setDefaultBrowserID(String defaultAdapterID) {
        if (!this.initialized) {
            this.init();
        }
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(defaultAdapterID)) {
                this.defaultBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    public IBrowser createBrowser(boolean external) {
        if (!this.initialized) {
            this.init();
        }
        if (external) {
            return new CurrentBrowser(this.createBrowserAdapter(true), this.getCurrentBrowserID(), true);
        }
        return new CurrentBrowser(this.createBrowserAdapter(this.alwaysUseExternal), this.getCurrentInternalBrowserID(), false);
    }

    public IBrowser createBrowser() {
        return this.createBrowser(true);
    }

    private IBrowser createBrowserAdapter(boolean external) {
        if (!this.initialized) {
            this.init();
        }
        IBrowser browser = null;
        browser = !external && this.isEmbeddedBrowserPresent() ? this.internalBrowserDesc.getFactory().createBrowser() : this.currentBrowserDesc.getFactory().createBrowser();
        this.browsers.add(browser);
        return browser;
    }

    public void closeAll() {
        if (!this.initialized) {
            return;
        }
        for (IBrowser browser : this.browsers) {
            browser.close();
        }
    }

    public boolean isEmbeddedBrowserPresent() {
        if (!this.initialized) {
            this.init();
        }
        return this.internalBrowserDesc != null;
    }

    public void setAlwaysUseExternal(boolean alwaysExternal) {
        if (!this.initialized) {
            this.init();
        }
        this.alwaysUseExternal = alwaysExternal || !this.isEmbeddedBrowserPresent();
    }

    public boolean isAlwaysUseExternal() {
        if (!this.isEmbeddedBrowserPresent()) {
            return true;
        }
        return this.alwaysUseExternal;
    }
}

