/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import org.eclipse.cdt.debug.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContributionUser;
import org.eclipse.swt.widgets.Composite;

public class BreakpointComboFieldEditor
extends ComboFieldEditor
implements ICBreakpointsUIContributionUser {
    private ICBreakpointsUIContribution fContribution;

    public BreakpointComboFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, new String[0][0], parent);
    }

    @Override
    public void setContribution(ICBreakpointsUIContribution contribution) {
        this.fContribution = contribution;
        String[] possibleValues = this.fContribution.getPossibleValues();
        String[][] entryNamesAndValues = new String[possibleValues.length][2];
        int i = 0;
        while (i < possibleValues.length) {
            entryNamesAndValues[i][0] = this.fContribution.getLabelForValue(possibleValues[i]);
            entryNamesAndValues[i][1] = possibleValues[i];
            ++i;
        }
        this.setEntries(entryNamesAndValues);
    }

    @Override
    public ICBreakpointsUIContribution getContribution() {
        return this.fContribution;
    }

    @Override
    protected void doLoad() {
        this.updateComboForValue(this.storeToComboValue());
    }

    @Override
    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.comboValueToStore(this.fValue);
    }

    protected String storeToComboValue() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        if (this.fContribution != null) {
            if ("integer".equals(this.fContribution.getType())) {
                value = Integer.toString(this.getPreferenceStore().getInt(this.getPreferenceName()));
            } else if ("boolean".equals(this.fContribution.getType())) {
                value = Boolean.toString(this.getPreferenceStore().getBoolean(this.getPreferenceName()));
            } else if ("float".equals(this.fContribution.getType())) {
                value = Float.toString(this.getPreferenceStore().getFloat(this.getPreferenceName()));
            } else if ("double".equals(this.fContribution.getType())) {
                value = Double.toString(this.getPreferenceStore().getDouble(this.getPreferenceName()));
            }
        }
        return value;
    }

    protected void comboValueToStore(String val) {
        if (this.fContribution != null) {
            if ("integer".equals(this.fContribution.getType())) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), Integer.parseInt(val));
            } else if ("boolean".equals(this.fContribution.getType())) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), Boolean.parseBoolean(val));
            } else if ("float".equals(this.fContribution.getType())) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), Float.parseFloat(val));
            } else if ("double".equals(this.fContribution.getType())) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), Double.parseDouble(val));
            } else {
                this.getPreferenceStore().setValue(this.getPreferenceName(), val);
            }
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), val);
        }
    }
}

