/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Info;
import org.mandas.docker.client.messages.swarm.SwarmInfo;

final class ImmutableInfo
implements Info {
    @Nullable
    private final String architecture;
    @Nullable
    private final String clusterStore;
    @Nullable
    private final String cgroupDriver;
    private final Integer containers;
    @Nullable
    private final Integer containersRunning;
    @Nullable
    private final Integer containersStopped;
    @Nullable
    private final Integer containersPaused;
    @Nullable
    private final Boolean cpuCfsPeriod;
    @Nullable
    private final Boolean cpuCfsQuota;
    private final Boolean debug;
    private final String dockerRootDir;
    private final String storageDriver;
    private final List<List<String>> driverStatus;
    @Nullable
    private final Boolean experimentalBuild;
    @Nullable
    private final String httpProxy;
    @Nullable
    private final String httpsProxy;
    private final String id;
    private final Boolean ipv4Forwarding;
    private final Integer images;
    private final String indexServerAddress;
    @Nullable
    private final String initPath;
    @Nullable
    private final String initSha1;
    @Nullable
    private final Boolean kernelMemory;
    private final String kernelVersion;
    private final List<String> labels;
    private final Long memTotal;
    private final Boolean memoryLimit;
    private final Integer cpus;
    private final Integer eventsListener;
    private final Integer fileDescriptors;
    private final Integer goroutines;
    private final String name;
    @Nullable
    private final String noProxy;
    @Nullable
    private final Boolean oomKillDisable;
    private final String operatingSystem;
    @Nullable
    private final String osType;
    @Nullable
    private final Info.Plugins plugins;
    private final Info.RegistryConfig registryConfig;
    @Nullable
    private final String serverVersion;
    private final Boolean swapLimit;
    @Nullable
    private final SwarmInfo swarm;
    @Nullable
    private final List<List<String>> systemStatus;
    private final Date systemTime;

    private ImmutableInfo(@Nullable String architecture, @Nullable String clusterStore, @Nullable String cgroupDriver, Integer containers, @Nullable Integer containersRunning, @Nullable Integer containersStopped, @Nullable Integer containersPaused, @Nullable Boolean cpuCfsPeriod, @Nullable Boolean cpuCfsQuota, Boolean debug, String dockerRootDir, String storageDriver, List<List<String>> driverStatus, @Nullable Boolean experimentalBuild, @Nullable String httpProxy, @Nullable String httpsProxy, String id, Boolean ipv4Forwarding, Integer images, String indexServerAddress, @Nullable String initPath, @Nullable String initSha1, @Nullable Boolean kernelMemory, String kernelVersion, List<String> labels, Long memTotal, Boolean memoryLimit, Integer cpus, Integer eventsListener, Integer fileDescriptors, Integer goroutines, String name, @Nullable String noProxy, @Nullable Boolean oomKillDisable, String operatingSystem, @Nullable String osType, @Nullable Info.Plugins plugins, Info.RegistryConfig registryConfig, @Nullable String serverVersion, Boolean swapLimit, @Nullable SwarmInfo swarm, @Nullable List<List<String>> systemStatus, Date systemTime) {
        this.architecture = architecture;
        this.clusterStore = clusterStore;
        this.cgroupDriver = cgroupDriver;
        this.containers = containers;
        this.containersRunning = containersRunning;
        this.containersStopped = containersStopped;
        this.containersPaused = containersPaused;
        this.cpuCfsPeriod = cpuCfsPeriod;
        this.cpuCfsQuota = cpuCfsQuota;
        this.debug = debug;
        this.dockerRootDir = dockerRootDir;
        this.storageDriver = storageDriver;
        this.driverStatus = driverStatus;
        this.experimentalBuild = experimentalBuild;
        this.httpProxy = httpProxy;
        this.httpsProxy = httpsProxy;
        this.id = id;
        this.ipv4Forwarding = ipv4Forwarding;
        this.images = images;
        this.indexServerAddress = indexServerAddress;
        this.initPath = initPath;
        this.initSha1 = initSha1;
        this.kernelMemory = kernelMemory;
        this.kernelVersion = kernelVersion;
        this.labels = labels;
        this.memTotal = memTotal;
        this.memoryLimit = memoryLimit;
        this.cpus = cpus;
        this.eventsListener = eventsListener;
        this.fileDescriptors = fileDescriptors;
        this.goroutines = goroutines;
        this.name = name;
        this.noProxy = noProxy;
        this.oomKillDisable = oomKillDisable;
        this.operatingSystem = operatingSystem;
        this.osType = osType;
        this.plugins = plugins;
        this.registryConfig = registryConfig;
        this.serverVersion = serverVersion;
        this.swapLimit = swapLimit;
        this.swarm = swarm;
        this.systemStatus = systemStatus;
        this.systemTime = systemTime;
    }

    @Override
    @JsonProperty(value="Architecture")
    @Nullable
    public String architecture() {
        return this.architecture;
    }

    @Override
    @JsonProperty(value="ClusterStore")
    @Nullable
    public String clusterStore() {
        return this.clusterStore;
    }

    @Override
    @JsonProperty(value="CgroupDriver")
    @Nullable
    public String cgroupDriver() {
        return this.cgroupDriver;
    }

    @Override
    @JsonProperty(value="Containers")
    public Integer containers() {
        return this.containers;
    }

    @Override
    @JsonProperty(value="ContainersRunning")
    @Nullable
    public Integer containersRunning() {
        return this.containersRunning;
    }

    @Override
    @JsonProperty(value="ContainersStopped")
    @Nullable
    public Integer containersStopped() {
        return this.containersStopped;
    }

    @Override
    @JsonProperty(value="ContainersPaused")
    @Nullable
    public Integer containersPaused() {
        return this.containersPaused;
    }

    @Override
    @JsonProperty(value="CpuCfsPeriod")
    @Nullable
    public Boolean cpuCfsPeriod() {
        return this.cpuCfsPeriod;
    }

    @Override
    @JsonProperty(value="CpuCfsQuota")
    @Nullable
    public Boolean cpuCfsQuota() {
        return this.cpuCfsQuota;
    }

    @Override
    @JsonProperty(value="Debug")
    public Boolean debug() {
        return this.debug;
    }

    @Override
    @JsonProperty(value="DockerRootDir")
    public String dockerRootDir() {
        return this.dockerRootDir;
    }

    @Override
    @JsonProperty(value="Driver")
    public String storageDriver() {
        return this.storageDriver;
    }

    @Override
    @JsonProperty(value="DriverStatus")
    public List<List<String>> driverStatus() {
        return this.driverStatus;
    }

    @Override
    @JsonProperty(value="ExperimentalBuild")
    @Nullable
    public Boolean experimentalBuild() {
        return this.experimentalBuild;
    }

    @Override
    @JsonProperty(value="HttpProxy")
    @Nullable
    public String httpProxy() {
        return this.httpProxy;
    }

    @Override
    @JsonProperty(value="HttpsProxy")
    @Nullable
    public String httpsProxy() {
        return this.httpsProxy;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="IPv4Forwarding")
    public Boolean ipv4Forwarding() {
        return this.ipv4Forwarding;
    }

    @Override
    @JsonProperty(value="Images")
    public Integer images() {
        return this.images;
    }

    @Override
    @JsonProperty(value="IndexServerAddress")
    public String indexServerAddress() {
        return this.indexServerAddress;
    }

    @Override
    @JsonProperty(value="InitPath")
    @Nullable
    public String initPath() {
        return this.initPath;
    }

    @Override
    @JsonProperty(value="InitSha1")
    @Nullable
    public String initSha1() {
        return this.initSha1;
    }

    @Override
    @JsonProperty(value="KernelMemory")
    @Nullable
    public Boolean kernelMemory() {
        return this.kernelMemory;
    }

    @Override
    @JsonProperty(value="KernelVersion")
    public String kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    @JsonProperty(value="Labels")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public List<String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="MemTotal")
    public Long memTotal() {
        return this.memTotal;
    }

    @Override
    @JsonProperty(value="MemoryLimit")
    public Boolean memoryLimit() {
        return this.memoryLimit;
    }

    @Override
    @JsonProperty(value="NCPU")
    public Integer cpus() {
        return this.cpus;
    }

    @Override
    @JsonProperty(value="NEventsListener")
    public Integer eventsListener() {
        return this.eventsListener;
    }

    @Override
    @JsonProperty(value="NFd")
    public Integer fileDescriptors() {
        return this.fileDescriptors;
    }

    @Override
    @JsonProperty(value="NGoroutines")
    public Integer goroutines() {
        return this.goroutines;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="NoProxy")
    @Nullable
    public String noProxy() {
        return this.noProxy;
    }

    @Override
    @JsonProperty(value="OomKillDisable")
    @Nullable
    public Boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    @JsonProperty(value="OperatingSystem")
    public String operatingSystem() {
        return this.operatingSystem;
    }

    @Override
    @JsonProperty(value="OSType")
    @Nullable
    public String osType() {
        return this.osType;
    }

    @Override
    @JsonProperty(value="Plugins")
    @Nullable
    public Info.Plugins plugins() {
        return this.plugins;
    }

    @Override
    @JsonProperty(value="RegistryConfig")
    public Info.RegistryConfig registryConfig() {
        return this.registryConfig;
    }

    @Override
    @JsonProperty(value="ServerVersion")
    @Nullable
    public String serverVersion() {
        return this.serverVersion;
    }

    @Override
    @JsonProperty(value="SwapLimit")
    public Boolean swapLimit() {
        return this.swapLimit;
    }

    @Override
    @JsonProperty(value="Swarm")
    @Nullable
    public SwarmInfo swarm() {
        return this.swarm;
    }

    @Override
    @JsonProperty(value="SystemStatus")
    @Nullable
    public List<List<String>> systemStatus() {
        return this.systemStatus;
    }

    @Override
    @JsonProperty(value="SystemTime")
    public Date systemTime() {
        return this.systemTime;
    }

    public final ImmutableInfo withArchitecture(@Nullable String value) {
        if (Objects.equals(this.architecture, value)) {
            return this;
        }
        return new ImmutableInfo(value, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withClusterStore(@Nullable String value) {
        if (Objects.equals(this.clusterStore, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, value, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withCgroupDriver(@Nullable String value) {
        if (Objects.equals(this.cgroupDriver, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, value, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withContainers(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "containers");
        if (this.containers.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, newValue, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withContainersRunning(@Nullable Integer value) {
        if (Objects.equals(this.containersRunning, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, value, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withContainersStopped(@Nullable Integer value) {
        if (Objects.equals(this.containersStopped, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, value, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withContainersPaused(@Nullable Integer value) {
        if (Objects.equals(this.containersPaused, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, value, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withCpuCfsPeriod(@Nullable Boolean value) {
        if (Objects.equals(this.cpuCfsPeriod, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, value, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withCpuCfsQuota(@Nullable Boolean value) {
        if (Objects.equals(this.cpuCfsQuota, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, value, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withDebug(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "debug");
        if (this.debug.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, newValue, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withDockerRootDir(String value) {
        String newValue = Objects.requireNonNull(value, "dockerRootDir");
        if (this.dockerRootDir.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, newValue, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withStorageDriver(String value) {
        String newValue = Objects.requireNonNull(value, "storageDriver");
        if (this.storageDriver.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, newValue, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    @SafeVarargs
    public final ImmutableInfo withDriverStatus(List<String> ... elements) {
        List<List<String>> newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, newValue, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withDriverStatus(Iterable<? extends List<String>> elements) {
        if (this.driverStatus == elements) {
            return this;
        }
        List<List<String>> newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, newValue, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withExperimentalBuild(@Nullable Boolean value) {
        if (Objects.equals(this.experimentalBuild, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, value, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withHttpProxy(@Nullable String value) {
        if (Objects.equals(this.httpProxy, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, value, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withHttpsProxy(@Nullable String value) {
        if (Objects.equals(this.httpsProxy, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, value, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, newValue, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withIpv4Forwarding(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "ipv4Forwarding");
        if (this.ipv4Forwarding.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, newValue, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withImages(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "images");
        if (this.images.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, newValue, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withIndexServerAddress(String value) {
        String newValue = Objects.requireNonNull(value, "indexServerAddress");
        if (this.indexServerAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, newValue, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withInitPath(@Nullable String value) {
        if (Objects.equals(this.initPath, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, value, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withInitSha1(@Nullable String value) {
        if (Objects.equals(this.initSha1, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, value, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withKernelMemory(@Nullable Boolean value) {
        if (Objects.equals(this.kernelMemory, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, value, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withKernelVersion(String value) {
        String newValue = Objects.requireNonNull(value, "kernelVersion");
        if (this.kernelVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, newValue, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withLabels(String ... elements) {
        List<String> newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, newValue, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        List<String> newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, newValue, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withMemTotal(Long value) {
        Long newValue = Objects.requireNonNull(value, "memTotal");
        if (this.memTotal.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, newValue, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withMemoryLimit(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "memoryLimit");
        if (this.memoryLimit.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, newValue, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withCpus(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "cpus");
        if (this.cpus.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, newValue, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withEventsListener(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "eventsListener");
        if (this.eventsListener.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, newValue, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withFileDescriptors(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "fileDescriptors");
        if (this.fileDescriptors.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, newValue, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withGoroutines(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "goroutines");
        if (this.goroutines.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, newValue, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, newValue, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withNoProxy(@Nullable String value) {
        if (Objects.equals(this.noProxy, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, value, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withOomKillDisable(@Nullable Boolean value) {
        if (Objects.equals(this.oomKillDisable, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, value, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withOperatingSystem(String value) {
        String newValue = Objects.requireNonNull(value, "operatingSystem");
        if (this.operatingSystem.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, newValue, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withOsType(@Nullable String value) {
        if (Objects.equals(this.osType, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, value, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withPlugins(@Nullable Info.Plugins value) {
        if (this.plugins == value) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, value, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withRegistryConfig(Info.RegistryConfig value) {
        if (this.registryConfig == value) {
            return this;
        }
        Info.RegistryConfig newValue = Objects.requireNonNull(value, "registryConfig");
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, newValue, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withServerVersion(@Nullable String value) {
        if (Objects.equals(this.serverVersion, value)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, value, this.swapLimit, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withSwapLimit(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "swapLimit");
        if (this.swapLimit.equals(newValue)) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, newValue, this.swarm, this.systemStatus, this.systemTime);
    }

    public final ImmutableInfo withSwarm(@Nullable SwarmInfo value) {
        if (this.swarm == value) {
            return this;
        }
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, value, this.systemStatus, this.systemTime);
    }

    @SafeVarargs
    public final ImmutableInfo withSystemStatus(List<String> ... elements) {
        if (elements == null) {
            return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, null, this.systemTime);
        }
        List<List<String>> newValue = Arrays.asList(elements) == null ? null : ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, newValue, this.systemTime);
    }

    public final ImmutableInfo withSystemStatus(@Nullable Iterable<? extends List<String>> elements) {
        if (this.systemStatus == elements) {
            return this;
        }
        List<List<String>> newValue = elements == null ? null : ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, newValue, this.systemTime);
    }

    public final ImmutableInfo withSystemTime(Date value) {
        if (this.systemTime == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "systemTime");
        return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, this.driverStatus, this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, this.labels, this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInfo && this.equalTo((ImmutableInfo)another);
    }

    private boolean equalTo(ImmutableInfo another) {
        return Objects.equals(this.architecture, another.architecture) && Objects.equals(this.clusterStore, another.clusterStore) && Objects.equals(this.cgroupDriver, another.cgroupDriver) && this.containers.equals(another.containers) && Objects.equals(this.containersRunning, another.containersRunning) && Objects.equals(this.containersStopped, another.containersStopped) && Objects.equals(this.containersPaused, another.containersPaused) && Objects.equals(this.cpuCfsPeriod, another.cpuCfsPeriod) && Objects.equals(this.cpuCfsQuota, another.cpuCfsQuota) && this.debug.equals(another.debug) && this.dockerRootDir.equals(another.dockerRootDir) && this.storageDriver.equals(another.storageDriver) && this.driverStatus.equals(another.driverStatus) && Objects.equals(this.experimentalBuild, another.experimentalBuild) && Objects.equals(this.httpProxy, another.httpProxy) && Objects.equals(this.httpsProxy, another.httpsProxy) && this.id.equals(another.id) && this.ipv4Forwarding.equals(another.ipv4Forwarding) && this.images.equals(another.images) && this.indexServerAddress.equals(another.indexServerAddress) && Objects.equals(this.initPath, another.initPath) && Objects.equals(this.initSha1, another.initSha1) && Objects.equals(this.kernelMemory, another.kernelMemory) && this.kernelVersion.equals(another.kernelVersion) && this.labels.equals(another.labels) && this.memTotal.equals(another.memTotal) && this.memoryLimit.equals(another.memoryLimit) && this.cpus.equals(another.cpus) && this.eventsListener.equals(another.eventsListener) && this.fileDescriptors.equals(another.fileDescriptors) && this.goroutines.equals(another.goroutines) && this.name.equals(another.name) && Objects.equals(this.noProxy, another.noProxy) && Objects.equals(this.oomKillDisable, another.oomKillDisable) && this.operatingSystem.equals(another.operatingSystem) && Objects.equals(this.osType, another.osType) && Objects.equals(this.plugins, another.plugins) && this.registryConfig.equals(another.registryConfig) && Objects.equals(this.serverVersion, another.serverVersion) && this.swapLimit.equals(another.swapLimit) && Objects.equals(this.swarm, another.swarm) && Objects.equals(this.systemStatus, another.systemStatus) && this.systemTime.equals(another.systemTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.architecture);
        h += (h << 5) + Objects.hashCode(this.clusterStore);
        h += (h << 5) + Objects.hashCode(this.cgroupDriver);
        h += (h << 5) + this.containers.hashCode();
        h += (h << 5) + Objects.hashCode(this.containersRunning);
        h += (h << 5) + Objects.hashCode(this.containersStopped);
        h += (h << 5) + Objects.hashCode(this.containersPaused);
        h += (h << 5) + Objects.hashCode(this.cpuCfsPeriod);
        h += (h << 5) + Objects.hashCode(this.cpuCfsQuota);
        h += (h << 5) + this.debug.hashCode();
        h += (h << 5) + this.dockerRootDir.hashCode();
        h += (h << 5) + this.storageDriver.hashCode();
        h += (h << 5) + this.driverStatus.hashCode();
        h += (h << 5) + Objects.hashCode(this.experimentalBuild);
        h += (h << 5) + Objects.hashCode(this.httpProxy);
        h += (h << 5) + Objects.hashCode(this.httpsProxy);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.ipv4Forwarding.hashCode();
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.indexServerAddress.hashCode();
        h += (h << 5) + Objects.hashCode(this.initPath);
        h += (h << 5) + Objects.hashCode(this.initSha1);
        h += (h << 5) + Objects.hashCode(this.kernelMemory);
        h += (h << 5) + this.kernelVersion.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.memTotal.hashCode();
        h += (h << 5) + this.memoryLimit.hashCode();
        h += (h << 5) + this.cpus.hashCode();
        h += (h << 5) + this.eventsListener.hashCode();
        h += (h << 5) + this.fileDescriptors.hashCode();
        h += (h << 5) + this.goroutines.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.noProxy);
        h += (h << 5) + Objects.hashCode(this.oomKillDisable);
        h += (h << 5) + this.operatingSystem.hashCode();
        h += (h << 5) + Objects.hashCode(this.osType);
        h += (h << 5) + Objects.hashCode(this.plugins);
        h += (h << 5) + this.registryConfig.hashCode();
        h += (h << 5) + Objects.hashCode(this.serverVersion);
        h += (h << 5) + this.swapLimit.hashCode();
        h += (h << 5) + Objects.hashCode(this.swarm);
        h += (h << 5) + Objects.hashCode(this.systemStatus);
        h += (h << 5) + this.systemTime.hashCode();
        return h;
    }

    public String toString() {
        return "Info{architecture=" + this.architecture + ", clusterStore=" + this.clusterStore + ", cgroupDriver=" + this.cgroupDriver + ", containers=" + this.containers + ", containersRunning=" + this.containersRunning + ", containersStopped=" + this.containersStopped + ", containersPaused=" + this.containersPaused + ", cpuCfsPeriod=" + this.cpuCfsPeriod + ", cpuCfsQuota=" + this.cpuCfsQuota + ", debug=" + this.debug + ", dockerRootDir=" + this.dockerRootDir + ", storageDriver=" + this.storageDriver + ", driverStatus=" + this.driverStatus + ", experimentalBuild=" + this.experimentalBuild + ", httpProxy=" + this.httpProxy + ", httpsProxy=" + this.httpsProxy + ", id=" + this.id + ", ipv4Forwarding=" + this.ipv4Forwarding + ", images=" + this.images + ", indexServerAddress=" + this.indexServerAddress + ", initPath=" + this.initPath + ", initSha1=" + this.initSha1 + ", kernelMemory=" + this.kernelMemory + ", kernelVersion=" + this.kernelVersion + ", labels=" + this.labels + ", memTotal=" + this.memTotal + ", memoryLimit=" + this.memoryLimit + ", cpus=" + this.cpus + ", eventsListener=" + this.eventsListener + ", fileDescriptors=" + this.fileDescriptors + ", goroutines=" + this.goroutines + ", name=" + this.name + ", noProxy=" + this.noProxy + ", oomKillDisable=" + this.oomKillDisable + ", operatingSystem=" + this.operatingSystem + ", osType=" + this.osType + ", plugins=" + this.plugins + ", registryConfig=" + this.registryConfig + ", serverVersion=" + this.serverVersion + ", swapLimit=" + this.swapLimit + ", swarm=" + this.swarm + ", systemStatus=" + this.systemStatus + ", systemTime=" + this.systemTime + "}";
    }

    public static ImmutableInfo copyOf(Info instance) {
        if (instance instanceof ImmutableInfo) {
            return (ImmutableInfo)instance;
        }
        return ImmutableInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class IndexConfig
    implements Info.IndexConfig {
        private final String name;
        private final List<String> mirrors;
        private final Boolean secure;
        private final Boolean official;

        private IndexConfig(String name, List<String> mirrors, Boolean secure, Boolean official) {
            this.name = name;
            this.mirrors = mirrors;
            this.secure = secure;
            this.official = official;
        }

        @Override
        @JsonProperty(value="Name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="Mirrors")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public List<String> mirrors() {
            return this.mirrors;
        }

        @Override
        @JsonProperty(value="Secure")
        public Boolean secure() {
            return this.secure;
        }

        @Override
        @JsonProperty(value="Official")
        public Boolean official() {
            return this.official;
        }

        public final IndexConfig withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new IndexConfig(newValue, this.mirrors, this.secure, this.official);
        }

        public final IndexConfig withMirrors(String ... elements) {
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
            return new IndexConfig(this.name, newValue, this.secure, this.official);
        }

        public final IndexConfig withMirrors(Iterable<String> elements) {
            if (this.mirrors == elements) {
                return this;
            }
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
            return new IndexConfig(this.name, newValue, this.secure, this.official);
        }

        public final IndexConfig withSecure(Boolean value) {
            Boolean newValue = Objects.requireNonNull(value, "secure");
            if (this.secure.equals(newValue)) {
                return this;
            }
            return new IndexConfig(this.name, this.mirrors, newValue, this.official);
        }

        public final IndexConfig withOfficial(Boolean value) {
            Boolean newValue = Objects.requireNonNull(value, "official");
            if (this.official.equals(newValue)) {
                return this;
            }
            return new IndexConfig(this.name, this.mirrors, this.secure, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IndexConfig && this.equalTo((IndexConfig)another);
        }

        private boolean equalTo(IndexConfig another) {
            return this.name.equals(another.name) && this.mirrors.equals(another.mirrors) && this.secure.equals(another.secure) && this.official.equals(another.official);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.mirrors.hashCode();
            h += (h << 5) + this.secure.hashCode();
            h += (h << 5) + this.official.hashCode();
            return h;
        }

        public String toString() {
            return "IndexConfig{name=" + this.name + ", mirrors=" + this.mirrors + ", secure=" + this.secure + ", official=" + this.official + "}";
        }

        public static IndexConfig copyOf(Info.IndexConfig instance) {
            if (instance instanceof IndexConfig) {
                return (IndexConfig)instance;
            }
            return IndexConfig.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_SECURE = 2L;
            private static final long INIT_BIT_OFFICIAL = 4L;
            private long initBits = 7L;
            private String name;
            private List<String> mirrors = new ArrayList<String>();
            private Boolean secure;
            private Boolean official;

            private Builder() {
            }

            public final Builder from(Info.IndexConfig instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.addAllMirrors(instance.mirrors());
                this.secure(instance.secure());
                this.official(instance.official());
                return this;
            }

            @JsonProperty(value="Name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder mirror(String element) {
                this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
                return this;
            }

            public final Builder mirrors(String ... elements) {
                for (String element : elements) {
                    this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
                }
                return this;
            }

            @JsonProperty(value="Mirrors")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public final Builder mirrors(Iterable<String> elements) {
                this.mirrors.clear();
                return this.addAllMirrors(elements);
            }

            public final Builder addAllMirrors(Iterable<String> elements) {
                for (String element : elements) {
                    this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
                }
                return this;
            }

            @JsonProperty(value="Secure")
            public final Builder secure(Boolean secure) {
                this.secure = Objects.requireNonNull(secure, "secure");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="Official")
            public final Builder official(Boolean official) {
                this.official = Objects.requireNonNull(official, "official");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public IndexConfig build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IndexConfig(this.name, ImmutableInfo.createUnmodifiableList(true, this.mirrors), this.secure, this.official);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("secure");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("official");
                }
                return "Cannot build IndexConfig, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class RegistryConfig
    implements Info.RegistryConfig {
        private final Map<String, Info.IndexConfig> indexConfigs;
        private final List<String> insecureRegistryCidrs;

        private RegistryConfig(Map<String, Info.IndexConfig> indexConfigs, List<String> insecureRegistryCidrs) {
            this.indexConfigs = indexConfigs;
            this.insecureRegistryCidrs = insecureRegistryCidrs;
        }

        @Override
        @JsonProperty(value="IndexConfigs")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public Map<String, Info.IndexConfig> indexConfigs() {
            return this.indexConfigs;
        }

        @Override
        @JsonProperty(value="InsecureRegistryCIDRs")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public List<String> insecureRegistryCidrs() {
            return this.insecureRegistryCidrs;
        }

        public final RegistryConfig withIndexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
            if (this.indexConfigs == entries) {
                return this;
            }
            Map newValue = ImmutableInfo.createUnmodifiableMap(true, false, entries);
            return new RegistryConfig(newValue, this.insecureRegistryCidrs);
        }

        public final RegistryConfig withInsecureRegistryCidrs(String ... elements) {
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
            return new RegistryConfig(this.indexConfigs, newValue);
        }

        public final RegistryConfig withInsecureRegistryCidrs(Iterable<String> elements) {
            if (this.insecureRegistryCidrs == elements) {
                return this;
            }
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
            return new RegistryConfig(this.indexConfigs, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof RegistryConfig && this.equalTo((RegistryConfig)another);
        }

        private boolean equalTo(RegistryConfig another) {
            return this.indexConfigs.equals(another.indexConfigs) && this.insecureRegistryCidrs.equals(another.insecureRegistryCidrs);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.indexConfigs.hashCode();
            h += (h << 5) + this.insecureRegistryCidrs.hashCode();
            return h;
        }

        public String toString() {
            return "RegistryConfig{indexConfigs=" + this.indexConfigs + ", insecureRegistryCidrs=" + this.insecureRegistryCidrs + "}";
        }

        public static RegistryConfig copyOf(Info.RegistryConfig instance) {
            if (instance instanceof RegistryConfig) {
                return (RegistryConfig)instance;
            }
            return RegistryConfig.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private Map<String, Info.IndexConfig> indexConfigs = new LinkedHashMap<String, Info.IndexConfig>();
            private List<String> insecureRegistryCidrs = new ArrayList<String>();

            private Builder() {
            }

            public final Builder from(Info.RegistryConfig instance) {
                Objects.requireNonNull(instance, "instance");
                this.putAllIndexConfigs(instance.indexConfigs());
                this.addAllInsecureRegistryCidrs(instance.insecureRegistryCidrs());
                return this;
            }

            public final Builder addIndexConfig(String key, Info.IndexConfig value) {
                this.indexConfigs.put(Objects.requireNonNull(key, "indexConfigs key"), Objects.requireNonNull(value, "indexConfigs value"));
                return this;
            }

            public final Builder addIndexConfig(Map.Entry<String, ? extends Info.IndexConfig> entry) {
                String k = entry.getKey();
                Info.IndexConfig v = entry.getValue();
                this.indexConfigs.put(Objects.requireNonNull(k, "indexConfigs key"), Objects.requireNonNull(v, "indexConfigs value"));
                return this;
            }

            @JsonProperty(value="IndexConfigs")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public final Builder indexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
                this.indexConfigs.clear();
                return this.putAllIndexConfigs(entries);
            }

            public final Builder putAllIndexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
                for (Map.Entry<String, ? extends Info.IndexConfig> e : entries.entrySet()) {
                    String k = e.getKey();
                    Info.IndexConfig v = e.getValue();
                    this.indexConfigs.put(Objects.requireNonNull(k, "indexConfigs key"), Objects.requireNonNull(v, "indexConfigs value"));
                }
                return this;
            }

            public final Builder insecureRegistryCidr(String element) {
                this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
                return this;
            }

            public final Builder insecureRegistryCidrs(String ... elements) {
                for (String element : elements) {
                    this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
                }
                return this;
            }

            @JsonProperty(value="InsecureRegistryCIDRs")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public final Builder insecureRegistryCidrs(Iterable<String> elements) {
                this.insecureRegistryCidrs.clear();
                return this.addAllInsecureRegistryCidrs(elements);
            }

            public final Builder addAllInsecureRegistryCidrs(Iterable<String> elements) {
                for (String element : elements) {
                    this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
                }
                return this;
            }

            public RegistryConfig build() {
                return new RegistryConfig(ImmutableInfo.createUnmodifiableMap(false, false, this.indexConfigs), ImmutableInfo.createUnmodifiableList(true, this.insecureRegistryCidrs));
            }
        }
    }

    static final class Plugins
    implements Info.Plugins {
        private final List<String> volumes;
        private final List<String> networks;

        private Plugins(List<String> volumes, List<String> networks) {
            this.volumes = volumes;
            this.networks = networks;
        }

        @Override
        @JsonProperty(value="Volume")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public List<String> volumes() {
            return this.volumes;
        }

        @Override
        @JsonProperty(value="Network")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public List<String> networks() {
            return this.networks;
        }

        public final Plugins withVolumes(String ... elements) {
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
            return new Plugins(newValue, this.networks);
        }

        public final Plugins withVolumes(Iterable<String> elements) {
            if (this.volumes == elements) {
                return this;
            }
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
            return new Plugins(newValue, this.networks);
        }

        public final Plugins withNetworks(String ... elements) {
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(Arrays.asList(elements), true, false));
            return new Plugins(this.volumes, newValue);
        }

        public final Plugins withNetworks(Iterable<String> elements) {
            if (this.networks == elements) {
                return this;
            }
            List newValue = ImmutableInfo.createUnmodifiableList(false, ImmutableInfo.createSafeList(elements, true, false));
            return new Plugins(this.volumes, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Plugins && this.equalTo((Plugins)another);
        }

        private boolean equalTo(Plugins another) {
            return this.volumes.equals(another.volumes) && this.networks.equals(another.networks);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.volumes.hashCode();
            h += (h << 5) + this.networks.hashCode();
            return h;
        }

        public String toString() {
            return "Plugins{volumes=" + this.volumes + ", networks=" + this.networks + "}";
        }

        public static Plugins copyOf(Info.Plugins instance) {
            if (instance instanceof Plugins) {
                return (Plugins)instance;
            }
            return Plugins.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private List<String> volumes = new ArrayList<String>();
            private List<String> networks = new ArrayList<String>();

            private Builder() {
            }

            public final Builder from(Info.Plugins instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllVolumes(instance.volumes());
                this.addAllNetworks(instance.networks());
                return this;
            }

            public final Builder volume(String element) {
                this.volumes.add(Objects.requireNonNull(element, "volumes element"));
                return this;
            }

            public final Builder volumes(String ... elements) {
                for (String element : elements) {
                    this.volumes.add(Objects.requireNonNull(element, "volumes element"));
                }
                return this;
            }

            @JsonProperty(value="Volume")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public final Builder volumes(Iterable<String> elements) {
                this.volumes.clear();
                return this.addAllVolumes(elements);
            }

            public final Builder addAllVolumes(Iterable<String> elements) {
                for (String element : elements) {
                    this.volumes.add(Objects.requireNonNull(element, "volumes element"));
                }
                return this;
            }

            public final Builder network(String element) {
                this.networks.add(Objects.requireNonNull(element, "networks element"));
                return this;
            }

            public final Builder networks(String ... elements) {
                for (String element : elements) {
                    this.networks.add(Objects.requireNonNull(element, "networks element"));
                }
                return this;
            }

            @JsonProperty(value="Network")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public final Builder networks(Iterable<String> elements) {
                this.networks.clear();
                return this.addAllNetworks(elements);
            }

            public final Builder addAllNetworks(Iterable<String> elements) {
                for (String element : elements) {
                    this.networks.add(Objects.requireNonNull(element, "networks element"));
                }
                return this;
            }

            public Plugins build() {
                return new Plugins(ImmutableInfo.createUnmodifiableList(true, this.volumes), ImmutableInfo.createUnmodifiableList(true, this.networks));
            }
        }
    }

    static final class Builder {
        private static final long INIT_BIT_CONTAINERS = 1L;
        private static final long INIT_BIT_DEBUG = 2L;
        private static final long INIT_BIT_DOCKER_ROOT_DIR = 4L;
        private static final long INIT_BIT_STORAGE_DRIVER = 8L;
        private static final long INIT_BIT_ID = 16L;
        private static final long INIT_BIT_IPV4_FORWARDING = 32L;
        private static final long INIT_BIT_IMAGES = 64L;
        private static final long INIT_BIT_INDEX_SERVER_ADDRESS = 128L;
        private static final long INIT_BIT_KERNEL_VERSION = 256L;
        private static final long INIT_BIT_MEM_TOTAL = 512L;
        private static final long INIT_BIT_MEMORY_LIMIT = 1024L;
        private static final long INIT_BIT_CPUS = 2048L;
        private static final long INIT_BIT_EVENTS_LISTENER = 4096L;
        private static final long INIT_BIT_FILE_DESCRIPTORS = 8192L;
        private static final long INIT_BIT_GOROUTINES = 16384L;
        private static final long INIT_BIT_NAME = 32768L;
        private static final long INIT_BIT_OPERATING_SYSTEM = 65536L;
        private static final long INIT_BIT_REGISTRY_CONFIG = 131072L;
        private static final long INIT_BIT_SWAP_LIMIT = 262144L;
        private static final long INIT_BIT_SYSTEM_TIME = 524288L;
        private long initBits = 1048575L;
        private String architecture;
        private String clusterStore;
        private String cgroupDriver;
        private Integer containers;
        private Integer containersRunning;
        private Integer containersStopped;
        private Integer containersPaused;
        private Boolean cpuCfsPeriod;
        private Boolean cpuCfsQuota;
        private Boolean debug;
        private String dockerRootDir;
        private String storageDriver;
        private List<List<String>> driverStatus = new ArrayList<List<String>>();
        private Boolean experimentalBuild;
        private String httpProxy;
        private String httpsProxy;
        private String id;
        private Boolean ipv4Forwarding;
        private Integer images;
        private String indexServerAddress;
        private String initPath;
        private String initSha1;
        private Boolean kernelMemory;
        private String kernelVersion;
        private List<String> labels = new ArrayList<String>();
        private Long memTotal;
        private Boolean memoryLimit;
        private Integer cpus;
        private Integer eventsListener;
        private Integer fileDescriptors;
        private Integer goroutines;
        private String name;
        private String noProxy;
        private Boolean oomKillDisable;
        private String operatingSystem;
        private String osType;
        private Info.Plugins plugins;
        private Info.RegistryConfig registryConfig;
        private String serverVersion;
        private Boolean swapLimit;
        private SwarmInfo swarm;
        private List<List<String>> systemStatus = null;
        private Date systemTime;

        private Builder() {
        }

        public final Builder from(Info instance) {
            List<List<String>> systemStatusValue;
            Info.Plugins pluginsValue;
            Boolean oomKillDisableValue;
            Boolean kernelMemoryValue;
            String initSha1Value;
            String httpsProxyValue;
            String httpProxyValue;
            Boolean cpuCfsQuotaValue;
            Boolean cpuCfsPeriodValue;
            Integer containersPausedValue;
            Integer containersStoppedValue;
            String cgroupDriverValue;
            String clusterStoreValue;
            Objects.requireNonNull(instance, "instance");
            String architectureValue = instance.architecture();
            if (architectureValue != null) {
                this.architecture(architectureValue);
            }
            if ((clusterStoreValue = instance.clusterStore()) != null) {
                this.clusterStore(clusterStoreValue);
            }
            if ((cgroupDriverValue = instance.cgroupDriver()) != null) {
                this.cgroupDriver(cgroupDriverValue);
            }
            this.containers(instance.containers());
            Integer containersRunningValue = instance.containersRunning();
            if (containersRunningValue != null) {
                this.containersRunning(containersRunningValue);
            }
            if ((containersStoppedValue = instance.containersStopped()) != null) {
                this.containersStopped(containersStoppedValue);
            }
            if ((containersPausedValue = instance.containersPaused()) != null) {
                this.containersPaused(containersPausedValue);
            }
            if ((cpuCfsPeriodValue = instance.cpuCfsPeriod()) != null) {
                this.cpuCfsPeriod(cpuCfsPeriodValue);
            }
            if ((cpuCfsQuotaValue = instance.cpuCfsQuota()) != null) {
                this.cpuCfsQuota(cpuCfsQuotaValue);
            }
            this.debug(instance.debug());
            this.dockerRootDir(instance.dockerRootDir());
            this.storageDriver(instance.storageDriver());
            this.addAllDriverStatus(instance.driverStatus());
            Boolean experimentalBuildValue = instance.experimentalBuild();
            if (experimentalBuildValue != null) {
                this.experimentalBuild(experimentalBuildValue);
            }
            if ((httpProxyValue = instance.httpProxy()) != null) {
                this.httpProxy(httpProxyValue);
            }
            if ((httpsProxyValue = instance.httpsProxy()) != null) {
                this.httpsProxy(httpsProxyValue);
            }
            this.id(instance.id());
            this.ipv4Forwarding(instance.ipv4Forwarding());
            this.images(instance.images());
            this.indexServerAddress(instance.indexServerAddress());
            String initPathValue = instance.initPath();
            if (initPathValue != null) {
                this.initPath(initPathValue);
            }
            if ((initSha1Value = instance.initSha1()) != null) {
                this.initSha1(initSha1Value);
            }
            if ((kernelMemoryValue = instance.kernelMemory()) != null) {
                this.kernelMemory(kernelMemoryValue);
            }
            this.kernelVersion(instance.kernelVersion());
            this.addAllLabels(instance.labels());
            this.memTotal(instance.memTotal());
            this.memoryLimit(instance.memoryLimit());
            this.cpus(instance.cpus());
            this.eventsListener(instance.eventsListener());
            this.fileDescriptors(instance.fileDescriptors());
            this.goroutines(instance.goroutines());
            this.name(instance.name());
            String noProxyValue = instance.noProxy();
            if (noProxyValue != null) {
                this.noProxy(noProxyValue);
            }
            if ((oomKillDisableValue = instance.oomKillDisable()) != null) {
                this.oomKillDisable(oomKillDisableValue);
            }
            this.operatingSystem(instance.operatingSystem());
            String osTypeValue = instance.osType();
            if (osTypeValue != null) {
                this.osType(osTypeValue);
            }
            if ((pluginsValue = instance.plugins()) != null) {
                this.plugins(pluginsValue);
            }
            this.registryConfig(instance.registryConfig());
            String serverVersionValue = instance.serverVersion();
            if (serverVersionValue != null) {
                this.serverVersion(serverVersionValue);
            }
            this.swapLimit(instance.swapLimit());
            SwarmInfo swarmValue = instance.swarm();
            if (swarmValue != null) {
                this.swarm(swarmValue);
            }
            if ((systemStatusValue = instance.systemStatus()) != null) {
                this.addAllSystemStatus(systemStatusValue);
            }
            this.systemTime(instance.systemTime());
            return this;
        }

        @JsonProperty(value="Architecture")
        public final Builder architecture(@Nullable String architecture) {
            this.architecture = architecture;
            return this;
        }

        @JsonProperty(value="ClusterStore")
        public final Builder clusterStore(@Nullable String clusterStore) {
            this.clusterStore = clusterStore;
            return this;
        }

        @JsonProperty(value="CgroupDriver")
        public final Builder cgroupDriver(@Nullable String cgroupDriver) {
            this.cgroupDriver = cgroupDriver;
            return this;
        }

        @JsonProperty(value="Containers")
        public final Builder containers(Integer containers) {
            this.containers = Objects.requireNonNull(containers, "containers");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ContainersRunning")
        public final Builder containersRunning(@Nullable Integer containersRunning) {
            this.containersRunning = containersRunning;
            return this;
        }

        @JsonProperty(value="ContainersStopped")
        public final Builder containersStopped(@Nullable Integer containersStopped) {
            this.containersStopped = containersStopped;
            return this;
        }

        @JsonProperty(value="ContainersPaused")
        public final Builder containersPaused(@Nullable Integer containersPaused) {
            this.containersPaused = containersPaused;
            return this;
        }

        @JsonProperty(value="CpuCfsPeriod")
        public final Builder cpuCfsPeriod(@Nullable Boolean cpuCfsPeriod) {
            this.cpuCfsPeriod = cpuCfsPeriod;
            return this;
        }

        @JsonProperty(value="CpuCfsQuota")
        public final Builder cpuCfsQuota(@Nullable Boolean cpuCfsQuota) {
            this.cpuCfsQuota = cpuCfsQuota;
            return this;
        }

        @JsonProperty(value="Debug")
        public final Builder debug(Boolean debug) {
            this.debug = Objects.requireNonNull(debug, "debug");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="DockerRootDir")
        public final Builder dockerRootDir(String dockerRootDir) {
            this.dockerRootDir = Objects.requireNonNull(dockerRootDir, "dockerRootDir");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Driver")
        public final Builder storageDriver(String storageDriver) {
            this.storageDriver = Objects.requireNonNull(storageDriver, "storageDriver");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder driverStatu(List<String> element) {
            this.driverStatus.add(Objects.requireNonNull(element, "driverStatus element"));
            return this;
        }

        @SafeVarargs
        public final Builder driverStatus(List<String> ... elements) {
            for (List<String> element : elements) {
                this.driverStatus.add(Objects.requireNonNull(element, "driverStatus element"));
            }
            return this;
        }

        @JsonProperty(value="DriverStatus")
        public final Builder driverStatus(Iterable<? extends List<String>> elements) {
            this.driverStatus.clear();
            return this.addAllDriverStatus(elements);
        }

        public final Builder addAllDriverStatus(Iterable<? extends List<String>> elements) {
            for (List<String> list : elements) {
                this.driverStatus.add(Objects.requireNonNull(list, "driverStatus element"));
            }
            return this;
        }

        @JsonProperty(value="ExperimentalBuild")
        public final Builder experimentalBuild(@Nullable Boolean experimentalBuild) {
            this.experimentalBuild = experimentalBuild;
            return this;
        }

        @JsonProperty(value="HttpProxy")
        public final Builder httpProxy(@Nullable String httpProxy) {
            this.httpProxy = httpProxy;
            return this;
        }

        @JsonProperty(value="HttpsProxy")
        public final Builder httpsProxy(@Nullable String httpsProxy) {
            this.httpsProxy = httpsProxy;
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="IPv4Forwarding")
        public final Builder ipv4Forwarding(Boolean ipv4Forwarding) {
            this.ipv4Forwarding = Objects.requireNonNull(ipv4Forwarding, "ipv4Forwarding");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Images")
        public final Builder images(Integer images) {
            this.images = Objects.requireNonNull(images, "images");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="IndexServerAddress")
        public final Builder indexServerAddress(String indexServerAddress) {
            this.indexServerAddress = Objects.requireNonNull(indexServerAddress, "indexServerAddress");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="InitPath")
        public final Builder initPath(@Nullable String initPath) {
            this.initPath = initPath;
            return this;
        }

        @JsonProperty(value="InitSha1")
        public final Builder initSha1(@Nullable String initSha1) {
            this.initSha1 = initSha1;
            return this;
        }

        @JsonProperty(value="KernelMemory")
        public final Builder kernelMemory(@Nullable Boolean kernelMemory) {
            this.kernelMemory = kernelMemory;
            return this;
        }

        @JsonProperty(value="KernelVersion")
        public final Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = Objects.requireNonNull(kernelVersion, "kernelVersion");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder label(String element) {
            this.labels.add(Objects.requireNonNull(element, "labels element"));
            return this;
        }

        public final Builder labels(String ... elements) {
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        @JsonProperty(value="Labels")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public final Builder labels(Iterable<String> elements) {
            this.labels.clear();
            return this.addAllLabels(elements);
        }

        public final Builder addAllLabels(Iterable<String> elements) {
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        @JsonProperty(value="MemTotal")
        public final Builder memTotal(Long memTotal) {
            this.memTotal = Objects.requireNonNull(memTotal, "memTotal");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="MemoryLimit")
        public final Builder memoryLimit(Boolean memoryLimit) {
            this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="NCPU")
        public final Builder cpus(Integer cpus) {
            this.cpus = Objects.requireNonNull(cpus, "cpus");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="NEventsListener")
        public final Builder eventsListener(Integer eventsListener) {
            this.eventsListener = Objects.requireNonNull(eventsListener, "eventsListener");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty(value="NFd")
        public final Builder fileDescriptors(Integer fileDescriptors) {
            this.fileDescriptors = Objects.requireNonNull(fileDescriptors, "fileDescriptors");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @JsonProperty(value="NGoroutines")
        public final Builder goroutines(Integer goroutines) {
            this.goroutines = Objects.requireNonNull(goroutines, "goroutines");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        @JsonProperty(value="NoProxy")
        public final Builder noProxy(@Nullable String noProxy) {
            this.noProxy = noProxy;
            return this;
        }

        @JsonProperty(value="OomKillDisable")
        public final Builder oomKillDisable(@Nullable Boolean oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this;
        }

        @JsonProperty(value="OperatingSystem")
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        @JsonProperty(value="OSType")
        public final Builder osType(@Nullable String osType) {
            this.osType = osType;
            return this;
        }

        @JsonProperty(value="Plugins")
        public final Builder plugins(@Nullable Info.Plugins plugins) {
            this.plugins = plugins;
            return this;
        }

        @JsonProperty(value="RegistryConfig")
        public final Builder registryConfig(Info.RegistryConfig registryConfig) {
            this.registryConfig = Objects.requireNonNull(registryConfig, "registryConfig");
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        @JsonProperty(value="ServerVersion")
        public final Builder serverVersion(@Nullable String serverVersion) {
            this.serverVersion = serverVersion;
            return this;
        }

        @JsonProperty(value="SwapLimit")
        public final Builder swapLimit(Boolean swapLimit) {
            this.swapLimit = Objects.requireNonNull(swapLimit, "swapLimit");
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        @JsonProperty(value="Swarm")
        public final Builder swarm(@Nullable SwarmInfo swarm) {
            this.swarm = swarm;
            return this;
        }

        public final Builder systemStatu(List<String> element) {
            if (this.systemStatus == null) {
                this.systemStatus = new ArrayList<List<String>>();
            }
            this.systemStatus.add(Objects.requireNonNull(element, "systemStatus element"));
            return this;
        }

        @SafeVarargs
        public final Builder systemStatus(List<String> ... elements) {
            if (this.systemStatus == null) {
                this.systemStatus = new ArrayList<List<String>>();
            }
            for (List<String> element : elements) {
                this.systemStatus.add(Objects.requireNonNull(element, "systemStatus element"));
            }
            return this;
        }

        @JsonProperty(value="SystemStatus")
        public final Builder systemStatus(@Nullable Iterable<? extends List<String>> elements) {
            if (elements == null) {
                this.systemStatus = null;
                return this;
            }
            this.systemStatus = new ArrayList<List<String>>();
            return this.addAllSystemStatus(elements);
        }

        public final Builder addAllSystemStatus(Iterable<? extends List<String>> elements) {
            Objects.requireNonNull(elements, "systemStatus element");
            if (this.systemStatus == null) {
                this.systemStatus = new ArrayList<List<String>>();
            }
            for (List<String> list : elements) {
                this.systemStatus.add(Objects.requireNonNull(list, "systemStatus element"));
            }
            return this;
        }

        @JsonProperty(value="SystemTime")
        public final Builder systemTime(Date systemTime) {
            this.systemTime = Objects.requireNonNull(systemTime, "systemTime");
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public ImmutableInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInfo(this.architecture, this.clusterStore, this.cgroupDriver, this.containers, this.containersRunning, this.containersStopped, this.containersPaused, this.cpuCfsPeriod, this.cpuCfsQuota, this.debug, this.dockerRootDir, this.storageDriver, ImmutableInfo.createUnmodifiableList(true, this.driverStatus), this.experimentalBuild, this.httpProxy, this.httpsProxy, this.id, this.ipv4Forwarding, this.images, this.indexServerAddress, this.initPath, this.initSha1, this.kernelMemory, this.kernelVersion, ImmutableInfo.createUnmodifiableList(true, this.labels), this.memTotal, this.memoryLimit, this.cpus, this.eventsListener, this.fileDescriptors, this.goroutines, this.name, this.noProxy, this.oomKillDisable, this.operatingSystem, this.osType, this.plugins, this.registryConfig, this.serverVersion, this.swapLimit, this.swarm, this.systemStatus == null ? null : ImmutableInfo.createUnmodifiableList(true, this.systemStatus), this.systemTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("containers");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("debug");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dockerRootDir");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("storageDriver");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ipv4Forwarding");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("images");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("indexServerAddress");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("kernelVersion");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("memTotal");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("memoryLimit");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("cpus");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("eventsListener");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("fileDescriptors");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("goroutines");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("operatingSystem");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("registryConfig");
            }
            if ((this.initBits & 0x40000L) != 0L) {
                attributes.add("swapLimit");
            }
            if ((this.initBits & 0x80000L) != 0L) {
                attributes.add("systemTime");
            }
            return "Cannot build Info, some of required attributes are not set " + attributes;
        }
    }
}

