/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.selection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.core.gef.header.AbstractHeaderSelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDimensionInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

abstract class DimensionSelectionEditPolicy<C extends IControlInfo>
extends AbstractHeaderSelectionEditPolicy {
    public DimensionSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost(), (ILocator)new HeaderMoveHandleLocator());
        moveHandle.setForeground(IColorConstants.red);
        handles.add(moveHandle);
        return handles;
    }

    protected final GridDimensionInfo<C> getDimension() {
        return ((DimensionHeaderEditPart)this.getHost()).getDimension();
    }

    private class HeaderMoveHandleLocator
    implements ILocator {
        private HeaderMoveHandleLocator() {
        }

        public void relocate(Figure target) {
            Figure reference = DimensionSelectionEditPolicy.this.getHostFigure();
            Rectangle bounds = reference.getBounds().getCopy();
            FigureUtils.translateFigureToFigure((Figure)reference, (Figure)target, (Translatable)bounds);
            target.setBounds(bounds);
        }
    }
}

