/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class FontDialogField
extends DialogField {
    private FontData[] m_fontDataArray;
    private String m_chooseButtonText = "!Choose!";
    private String m_defaultButtonText = "!Default!";
    private Group m_group;
    private Label m_fontLabel;
    private Button m_chooseButton;
    private Button m_defaultButton;

    @Override
    public Control[] doFillIntoGrid(Composite parent, int columns) {
        this.assertEnoughColumns(columns);
        this.getGroupControl(parent);
        GridDataFactory.create((Control)this.m_group).spanH(columns).grabH().fillH();
        return new Control[]{this.m_group};
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    public Group getGroupControl(Composite parent) {
        if (this.m_group == null) {
            this.m_group = new Group(parent, 0);
            this.m_group.setText(this.fLabelText);
            GridLayoutFactory.create((Composite)this.m_group).columns(3);
            this.m_fontLabel = new Label((Composite)this.m_group, 0);
            GridDataFactory.create((Control)this.m_fontLabel).grab().fillH().alignVM();
            this.updateFontLabel();
            this.m_chooseButton = new Button((Composite)this.m_group, 0);
            GridDataFactory.create((Control)this.m_chooseButton);
            this.m_chooseButton.setText(this.m_chooseButtonText);
            this.m_chooseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FontDialog fontDialog = new FontDialog(FontDialogField.this.m_group.getShell());
                    fontDialog.setFontList(FontDialogField.this.m_fontDataArray);
                    if (fontDialog.open() != null) {
                        FontDialogField.this.setFontDataArray(fontDialog.getFontList());
                    }
                }
            });
            this.m_defaultButton = new Button((Composite)this.m_group, 0);
            GridDataFactory.create((Control)this.m_defaultButton);
            this.m_defaultButton.setText(this.m_defaultButtonText);
            this.m_defaultButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FontDialogField.this.setFontDataArray(Display.getDefault().getSystemFont().getFontData());
                }
            });
        }
        return this.m_group;
    }

    private void updateFontLabel() {
        if (this.isOkToUse((Control)this.m_fontLabel)) {
            if (this.m_fontDataArray != null) {
                this.m_fontLabel.setFont(new Font((Device)this.m_group.getDisplay(), this.m_fontDataArray));
                FontData fontData = this.m_fontDataArray[0];
                String styleString = "";
                int style = fontData.getStyle();
                if ((style & 1) != 0) {
                    styleString = String.valueOf(styleString) + " BOLD";
                }
                if ((style & 2) != 0) {
                    styleString = String.valueOf(styleString) + " ITALIC";
                }
                this.m_fontLabel.setText(String.valueOf(fontData.getName()) + styleString + " " + fontData.getHeight());
            } else {
                this.m_fontLabel.setFont(null);
                this.m_fontLabel.setText("");
            }
            this.m_group.layout();
        }
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.m_chooseButton)) {
            this.m_chooseButton.setFocus();
        }
        return true;
    }

    public FontData[] getFontDataArray() {
        return this.m_fontDataArray;
    }

    public void setFontDataArray(FontData[] fontDataArray) {
        this.m_fontDataArray = fontDataArray;
        this.updateFontLabel();
    }

    public void setChooseButtonText(String chooseButtonText) {
        this.m_chooseButtonText = chooseButtonText;
        if (this.isOkToUse((Control)this.m_chooseButton)) {
            this.m_chooseButton.setText(this.m_chooseButtonText);
        }
    }

    public void setDefaultButtonText(String defaultButtonText) {
        this.m_defaultButtonText = defaultButtonText;
        if (this.isOkToUse((Control)this.m_defaultButton)) {
            this.m_defaultButton.setText(this.m_defaultButtonText);
        }
    }
}

