/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.ReturnType;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PHPMethodDeclaration
extends MethodDeclaration
implements IPHPDocAwareDeclaration,
IAttributed {
    private static final List<FormalParameter> EMPTY_PARAMETERS = new LinkedList<FormalParameter>();
    private final boolean isReference;
    private PHPDocBlock phpDoc;
    private ReturnType returnType;
    private List<Attribute> attributes;

    public PHPMethodDeclaration(int start, int end, int nameStart, int nameEnd, String functionName, List<FormalParameter> formalParameters, Block body, boolean isReference, PHPDocBlock phpDoc) {
        this(start, end, nameStart, nameEnd, functionName, 64, formalParameters, body, isReference, phpDoc);
    }

    public PHPMethodDeclaration(int start, int end, int nameStart, int nameEnd, String functionName, int modifiers, List<FormalParameter> formalParameters, Block body, boolean isReference, PHPDocBlock phpDoc) {
        this(start, end, nameStart, nameEnd, functionName, modifiers, formalParameters, body, isReference, phpDoc, null);
    }

    public PHPMethodDeclaration(int start, int end, int nameStart, int nameEnd, String functionName, int modifiers, List<FormalParameter> formalParameters, Block body, boolean isReference, PHPDocBlock phpDoc, TypeReference returnType) {
        super(functionName, nameStart, nameEnd, start, end);
        this.setModifiers(modifiers);
        this.acceptArguments(formalParameters == null ? EMPTY_PARAMETERS : formalParameters);
        this.acceptBody(body);
        this.isReference = isReference;
        this.phpDoc = phpDoc;
        this.setReturnType(returnType);
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public TypeReference getReturnType() {
        if (this.returnType != null) {
            return this.returnType.getReturnType();
        }
        return null;
    }

    public void setReturnType(TypeReference returnType) {
        if (returnType != null) {
            this.returnType = new ReturnType(returnType);
        }
    }

    protected void traverseChildNodes(ASTVisitor visitor) throws Exception {
        if (this.attributes != null) {
            for (Attribute attr : this.attributes) {
                attr.traverse(visitor);
            }
        }
        super.traverseChildNodes(visitor);
        if (this.returnType != null) {
            this.returnType.traverse(visitor);
        }
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }
}

