/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ResourceApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class ProjectTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private IContainer fRoot;
    private String[] fPackageNames = null;

    public ProjectTypeContainer(IApiElement parent, IContainer container) {
        super(parent, 3, container.getName());
        this.fRoot = container;
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.doVisit(this.fRoot, "", visitor);
        }
        visitor.end(this);
    }

    @Override
    public void close() throws CoreException {
        this.fPackageNames = null;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Project Class File Container: " + this.getName());
        return buff.toString();
    }

    private void doVisit(IContainer container, String pkgName, ApiTypeContainerVisitor visitor) throws CoreException {
        IResource[] members = container.members();
        ArrayList<IContainer> dirs = new ArrayList<IContainer>();
        boolean visitPkg = visitor.visitPackage(pkgName);
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource file = iResourceArray[n2];
            switch (file.getType()) {
                case 2: {
                    dirs.add((IContainer)file);
                    break;
                }
                case 1: {
                    if (!visitPkg || !file.getName().endsWith(".class")) break;
                    String name = file.getName();
                    String typeName = name.substring(0, name.length() - 6);
                    if (pkgName.length() > 0) {
                        StringBuilder buf = new StringBuilder(pkgName);
                        buf.append('.');
                        buf.append(typeName);
                        typeName = buf.toString();
                    }
                    ResourceApiTypeRoot cf = new ResourceApiTypeRoot((IApiElement)this, (IFile)file, typeName);
                    visitor.visit(pkgName, cf);
                    visitor.end(pkgName, cf);
                    break;
                }
            }
            ++n2;
        }
        visitor.endVisitPackage(pkgName);
        for (IContainer child : dirs) {
            String nextName = null;
            if (pkgName.length() == 0) {
                nextName = child.getName();
            } else {
                StringBuilder buffer = new StringBuilder(pkgName);
                buffer.append('.');
                buffer.append(child.getName());
                nextName = buffer.toString();
            }
            this.doVisit(child, nextName, visitor);
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IFile file;
        IFolder folder;
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((folder = this.fRoot.getFolder((IPath)new Path(pkg.replace('.', '/')))).exists() && (file = folder.getFile(String.valueOf(cfName) + ".class")).exists()) {
            return new ResourceApiTypeRoot((IApiElement)this, file, qualifiedName);
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        if (this.fPackageNames == null) {
            TreeSet<String> names = new TreeSet<String>();
            ProjectTypeContainer.collectPackageNames(names, this.fRoot);
            this.fPackageNames = (String[])names.toArray(String[]::new);
        }
        return this.fPackageNames;
    }

    private static void collectPackageNames(Set<String> collector, IContainer dir) throws CoreException {
        int segmentCount = dir.getFullPath().segmentCount();
        dir.accept(proxy -> {
            if (proxy.getType() == 2) {
                IPath relativePath = proxy.requestFullPath().removeFirstSegments(segmentCount);
                String packageName = relativePath.toString().replace('/', '.');
                return collector.add(packageName);
            }
            return false;
        }, 0);
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 3;
    }
}

