/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.internal;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.papyrus.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.swt.graphics.Image;

@Deprecated
public class CustomizableLabelProvider
extends LabelProvider {
    private final ComposedAdapterFactory adapterFactoryWithRegistry = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private ICustomizationManager customizationEngine;
    private ICustomizedLabelProvider labelProvider;

    public CustomizableLabelProvider(ICustomizationManager customizationEngine) {
        this();
        this.customizationEngine = customizationEngine;
        this.labelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customizationEngine);
    }

    public CustomizableLabelProvider() {
        this.adapterFactoryWithRegistry.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactoryWithRegistry.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public void dispose() {
        try {
            this.adapterFactoryWithRegistry.dispose();
        }
        finally {
            super.dispose();
        }
    }

    public String getText(Object element) {
        if (element instanceof EReference) {
            EReference eReference = (EReference)element;
            return CustomizableLabelProvider.getText(eReference);
        }
        if (element instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)element;
            return CustomizableLabelProvider.getText(eAttribute);
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.getText(eObject);
        }
        return element.toString();
    }

    public String getText(EObject eObject) {
        String label;
        if (this.customizationEngine != null && (label = this.labelProvider.getText((Object)eObject)) != null) {
            return label;
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactoryWithRegistry.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return null;
    }

    public static String getText(EReference reference) {
        EReference oppositeRef;
        boolean showMultiplicity = true;
        boolean showOpposite = false;
        String multiplicity = "";
        if (showMultiplicity) {
            multiplicity = CustomizableLabelProvider.getMultiplicity(reference);
        }
        String opposite = "";
        if (showOpposite && (oppositeRef = reference.getEOpposite()) != null) {
            String oppositeMultiplicity = "";
            if (showMultiplicity) {
                oppositeMultiplicity = CustomizableLabelProvider.getMultiplicity(oppositeRef);
            }
            opposite = " <-> " + oppositeRef.getName() + oppositeMultiplicity;
        }
        String prefix = reference.isDerived() ? "/" : "";
        String referenceName = reference.getName();
        return String.valueOf(prefix) + referenceName + multiplicity + opposite;
    }

    public static String getMultiplicity(EReference reference) {
        String multLow = reference.isRequired() ? "1" : "0";
        String multHigh = reference.isMany() ? "*" : "1";
        return " [" + multLow + ".." + multHigh + "]";
    }

    public static String getText(EAttribute attribute) {
        String multiplicity = "";
        String multLow = attribute.isRequired() ? "1" : "0";
        String multHigh = attribute.isMany() ? "*" : "1";
        multiplicity = " [" + multLow + ".." + multHigh + "]";
        String prefix = attribute.isDerived() ? "/" : "";
        String attributeName = attribute.getName();
        return String.valueOf(prefix) + attributeName + multiplicity;
    }

    public Image getImage(Object element) {
        if (element instanceof EReference) {
            EReference eReference = (EReference)element;
            return CustomizableLabelProvider.getImage(eReference);
        }
        if (element instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)element;
            return CustomizableLabelProvider.getImage(eAttribute);
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.getImage(eObject);
        }
        return null;
    }

    public Image getImage(EObject eObject) {
        Image image;
        if (this.customizationEngine != null && (image = this.labelProvider.getImage((Object)eObject)) != null) {
            return image;
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactoryWithRegistry.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            Object image2 = itemLabelProvider.getImage((Object)eObject);
            return ExtendedImageRegistry.getInstance().getImage(image2);
        }
        return null;
    }

    public static Image getImage(EReference reference) {
        EReference opposite = reference.getEOpposite();
        if (reference.isContainment()) {
            if (opposite == null) {
                return ImageProvider.getInstance().getUnidirectionalAggregIcon();
            }
            return ImageProvider.getInstance().getAggregIcon();
        }
        if (opposite != null && opposite.isContainment()) {
            return ImageProvider.getInstance().getInvAggregIcon();
        }
        if (opposite == null) {
            return ImageProvider.getInstance().getUnidirectionalLinkIcon();
        }
        return ImageProvider.getInstance().getLinkIcon();
    }

    public static Image getImage(EAttribute eAttribute) {
        return ImageProvider.getInstance().getAttributeIcon();
    }
}

