/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.osgi;

import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator
extends ServiceLocator {
    private static final String SERVICES_SLASH = "services/";

    public OsgiServiceLocator() {
        this(OsgiServiceLocator.class.getClassLoader());
    }

    public OsgiServiceLocator(ClassLoader classLoader) {
        super(classLoader);
    }

    public static ServiceLocator getApplicableInstance() {
        if (OsgiServiceLocator.isApplicable()) {
            return new OsgiServiceLocator();
        }
        return ServiceLocator.getInstance();
    }

    public static boolean isApplicable() {
        return FrameworkUtil.getBundle(OsgiServiceLocator.class) != null;
    }

    /*
     * Unable to fully structure code
     */
    protected List<ServiceLocator.ResourceDescriptor> discoverServiceResources() {
        resourceUrls = new HashSet<URL>();
        descriptors = new ArrayList<ServiceLocator.ResourceDescriptor>();
        var6_3 = (Bundle[])this.bundles().toArray((IntFunction<Bundle[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$0(int ), (I)[Lorg/osgi/framework/Bundle;)());
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            bundle = var6_3[var4_5];
            for (String resourceName : this.getClasspathServiceResourceNames()) {
                indexOf = resourceName.indexOf("services/");
                Preconditions.checkState((boolean)(indexOf >= 0), (Object)resourceName);
                path = resourceName.substring(0, indexOf + "services/".length() - 1);
                file = resourceName.substring(indexOf + "services/".length());
                resources = bundle.findEntries(path, file, false);
                if (resources != null || (resources = bundle.findEntries("bin/" + path, file, false)) != null) ** GOTO lbl20
                continue;
lbl-1000:
                // 1 sources

                {
                    resourceUrl = (URL)resources.nextElement();
                    if (!resourceUrls.add(resourceUrl)) continue;
                    descriptors.add(new BundleResourceDescriptor(bundle, resourceUrl));
lbl20:
                    // 3 sources

                    ** while (resources.hasMoreElements())
                }
lbl21:
                // 1 sources

            }
            ++var4_5;
        }
        return descriptors;
    }

    protected Class<?> loadClass(ServiceLocator.ResourceDescriptor resource, String className) throws ClassNotFoundException {
        return ((BundleResourceDescriptor)resource).bundle.loadClass(className);
    }

    private Stream<Bundle> bundles() {
        Bundle[] bundles = this.getContext().getBundles();
        return Arrays.asList(bundles).stream().filter(new SystemBundleFilter());
    }

    BundleContext getContext() {
        Bundle bundle = this.getBundle();
        this.ensureContext(bundle);
        return Objects.requireNonNull(bundle.getBundleContext(), "Bundle has no context");
    }

    protected void ensureContext(Bundle bundle) {
        try {
            bundle.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Bundle getBundle() {
        return Objects.requireNonNull(FrameworkUtil.getBundle(OsgiServiceLocator.class), "Bundle is null.");
    }

    private static /* synthetic */ Bundle[] lambda$0(int n) {
        return new Bundle[n];
    }

    static class BundleResourceDescriptor
    extends ServiceLocator.ResourceDescriptor {
        private final Bundle bundle;

        public BundleResourceDescriptor(Bundle bundle, URL resourceUrl) {
            super(resourceUrl);
            this.bundle = bundle;
        }
    }

    private static class SystemBundleFilter
    implements Predicate<Bundle> {
        private SystemBundleFilter() {
        }

        @Override
        public boolean test(Bundle input) {
            return input.getBundleId() != 0L;
        }
    }
}

