/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.impl.PageflowPackageImpl;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowResourceFactoryImpl;

public class PageflowModelManager {
    private Resource resourcePageflow = null;
    private IPath pathPageflow = null;
    private static PageflowFactory pageflowFactory = null;
    private Pageflow pageflow = null;
    private ResourceSet resourceSet = null;
    private static HashMap defaultSaveOptions = new HashMap();

    static {
        defaultSaveOptions.put("ENCODING", "UTF-8");
    }

    public Resource getResource(IPath path) {
        if (this.resourcePageflow == null) {
            this.pathPageflow = path;
            ResourceSet resSet = this.getResourceSet();
            this.resourcePageflow = resSet.getResource(URI.createPlatformResourceURI((String)path.toString(), (boolean)false), true);
        }
        return this.resourcePageflow;
    }

    public Pageflow getModel() {
        if (this.pageflow == null) {
            EList l = this.resourcePageflow.getContents();
            for (Object o : l) {
                if (!(o instanceof Pageflow)) continue;
                this.pageflow = (Pageflow)o;
            }
        }
        return this.pageflow;
    }

    private Resource createResource(IPath path) {
        if (this.resourcePageflow == null) {
            this.pathPageflow = path;
            ResourceSet resSet = this.getResourceSet();
            this.resourcePageflow = resSet.createResource(URI.createPlatformResourceURI((String)path.toString(), (boolean)false));
        }
        return this.resourcePageflow;
    }

    private ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            PageflowPackageImpl.init();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map regMap = reg.getExtensionToFactoryMap();
            regMap.put("pageflow", new PageflowResourceFactoryImpl());
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    public static PageflowFactory getFactory() {
        if (pageflowFactory == null) {
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            String pageflowURI = "http://www.sybase.com/suade/pageflow";
            PageflowPackage pageflowPackage = (PageflowPackage)registry.get(pageflowURI);
            pageflowFactory = pageflowPackage.getPageflowFactory();
        }
        return pageflowFactory;
    }

    public Pageflow createPageflow(IPath path) {
        this.createResource(path);
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        String pageflowURI = "http://www.sybase.com/suade/pageflow";
        PageflowPackage nPackage = (PageflowPackage)registry.get(pageflowURI);
        PageflowFactory nFactory = nPackage.getPageflowFactory();
        this.pageflow = nFactory.createPageflow();
        this.resourcePageflow.getContents().add((Object)this.pageflow);
        return this.pageflow;
    }

    public void load(IPath path) {
        this.getResource(path);
    }

    public void reload(IPath path) {
        this.getResource(path).unload();
        this.load(path);
    }

    public void save(IPath path) throws IOException {
        if (!this.pathPageflow.toString().equalsIgnoreCase(path.toString())) {
            this.pathPageflow = path;
            URI fileURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
            this.resourcePageflow.setURI(fileURI);
        }
        this.resourcePageflow.save((Map)defaultSaveOptions);
    }

    public IPath getPath() {
        return this.pathPageflow;
    }

    public PageflowPage foundPage(String webPath) {
        PageflowPage page = null;
        if (this.getModel() != null) {
            for (PageflowNode node : this.getModel().getNodes()) {
                if (!(node instanceof PageflowPage) || !((PageflowPage)node).getPath().equalsIgnoreCase(webPath)) continue;
                page = (PageflowPage)node;
                break;
            }
        }
        return page;
    }

    public static IPath makePageflowPath(IPath pathFacesConfig) {
        String[] segs = pathFacesConfig.removeFileExtension().segments();
        IPath pageflowPath = new Path(segs[0]).makeAbsolute();
        pageflowPath = pageflowPath.append(".metadata");
        int i = 1;
        while (i < segs.length) {
            pageflowPath = pageflowPath.append(segs[i]);
            ++i;
        }
        pageflowPath = pageflowPath.addFileExtension("pageflow");
        return pageflowPath;
    }
}

