package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotColorGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotColorParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "NumberSign", "Comma", "Solidus", "RULE_DIGITS", "RULE_ZERO_OR_ONE", "RULE_COLOR_NUMBER", "RULE_HEXADECIMAL_DIGIT", "RULE_COLOR_STRING", "RULE_WS"
    };
    public static final int RULE_WS=12;
    public static final int RULE_COLOR_STRING=11;
    public static final int RULE_DIGITS=7;
    public static final int RULE_ZERO_OR_ONE=8;
    public static final int Comma=5;
    public static final int RULE_COLOR_NUMBER=9;
    public static final int NumberSign=4;
    public static final int RULE_HEXADECIMAL_DIGIT=10;
    public static final int Solidus=6;
    public static final int EOF=-1;

    // delegates
    // delegators


        public InternalDotColorParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotColorParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotColorParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotColorParser.g"; }


    	private DotColorGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("NumberSign", "'#'");
    		tokenNameToValue.put("Comma", "','");
    		tokenNameToValue.put("Solidus", "'/'");
    	}

    	public void setGrammarAccess(DotColorGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleColor"
    // InternalDotColorParser.g:58:1: entryRuleColor : ruleColor EOF ;
    public final void entryRuleColor() throws RecognitionException {
        try {
            // InternalDotColorParser.g:59:1: ( ruleColor EOF )
            // InternalDotColorParser.g:60:1: ruleColor EOF
            {
             before(grammarAccess.getColorRule()); 
            pushFollow(FOLLOW_1);
            ruleColor();

            state._fsp--;

             after(grammarAccess.getColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleColor"


    // $ANTLR start "ruleColor"
    // InternalDotColorParser.g:67:1: ruleColor : ( ( rule__Color__Alternatives )? ) ;
    public final void ruleColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:71:2: ( ( ( rule__Color__Alternatives )? ) )
            // InternalDotColorParser.g:72:2: ( ( rule__Color__Alternatives )? )
            {
            // InternalDotColorParser.g:72:2: ( ( rule__Color__Alternatives )? )
            // InternalDotColorParser.g:73:3: ( rule__Color__Alternatives )?
            {
             before(grammarAccess.getColorAccess().getAlternatives()); 
            // InternalDotColorParser.g:74:3: ( rule__Color__Alternatives )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==NumberSign||LA1_0==Solidus||(LA1_0>=RULE_COLOR_NUMBER && LA1_0<=RULE_COLOR_STRING)) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // InternalDotColorParser.g:74:4: rule__Color__Alternatives
                    {
                    pushFollow(FOLLOW_2);
                    rule__Color__Alternatives();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getColorAccess().getAlternatives()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleColor"


    // $ANTLR start "entryRuleRGBColor"
    // InternalDotColorParser.g:83:1: entryRuleRGBColor : ruleRGBColor EOF ;
    public final void entryRuleRGBColor() throws RecognitionException {
        try {
            // InternalDotColorParser.g:84:1: ( ruleRGBColor EOF )
            // InternalDotColorParser.g:85:1: ruleRGBColor EOF
            {
             before(grammarAccess.getRGBColorRule()); 
            pushFollow(FOLLOW_1);
            ruleRGBColor();

            state._fsp--;

             after(grammarAccess.getRGBColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleRGBColor"


    // $ANTLR start "ruleRGBColor"
    // InternalDotColorParser.g:92:1: ruleRGBColor : ( ( rule__RGBColor__Group__0 ) ) ;
    public final void ruleRGBColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:96:2: ( ( ( rule__RGBColor__Group__0 ) ) )
            // InternalDotColorParser.g:97:2: ( ( rule__RGBColor__Group__0 ) )
            {
            // InternalDotColorParser.g:97:2: ( ( rule__RGBColor__Group__0 ) )
            // InternalDotColorParser.g:98:3: ( rule__RGBColor__Group__0 )
            {
             before(grammarAccess.getRGBColorAccess().getGroup()); 
            // InternalDotColorParser.g:99:3: ( rule__RGBColor__Group__0 )
            // InternalDotColorParser.g:99:4: rule__RGBColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleRGBColor"


    // $ANTLR start "entryRuleHSVColor"
    // InternalDotColorParser.g:108:1: entryRuleHSVColor : ruleHSVColor EOF ;
    public final void entryRuleHSVColor() throws RecognitionException {
        try {
            // InternalDotColorParser.g:109:1: ( ruleHSVColor EOF )
            // InternalDotColorParser.g:110:1: ruleHSVColor EOF
            {
             before(grammarAccess.getHSVColorRule()); 
            pushFollow(FOLLOW_1);
            ruleHSVColor();

            state._fsp--;

             after(grammarAccess.getHSVColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleHSVColor"


    // $ANTLR start "ruleHSVColor"
    // InternalDotColorParser.g:117:1: ruleHSVColor : ( ( rule__HSVColor__Group__0 ) ) ;
    public final void ruleHSVColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:121:2: ( ( ( rule__HSVColor__Group__0 ) ) )
            // InternalDotColorParser.g:122:2: ( ( rule__HSVColor__Group__0 ) )
            {
            // InternalDotColorParser.g:122:2: ( ( rule__HSVColor__Group__0 ) )
            // InternalDotColorParser.g:123:3: ( rule__HSVColor__Group__0 )
            {
             before(grammarAccess.getHSVColorAccess().getGroup()); 
            // InternalDotColorParser.g:124:3: ( rule__HSVColor__Group__0 )
            // InternalDotColorParser.g:124:4: rule__HSVColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleHSVColor"


    // $ANTLR start "entryRuleStringColor"
    // InternalDotColorParser.g:133:1: entryRuleStringColor : ruleStringColor EOF ;
    public final void entryRuleStringColor() throws RecognitionException {
        try {
            // InternalDotColorParser.g:134:1: ( ruleStringColor EOF )
            // InternalDotColorParser.g:135:1: ruleStringColor EOF
            {
             before(grammarAccess.getStringColorRule()); 
            pushFollow(FOLLOW_1);
            ruleStringColor();

            state._fsp--;

             after(grammarAccess.getStringColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleStringColor"


    // $ANTLR start "ruleStringColor"
    // InternalDotColorParser.g:142:1: ruleStringColor : ( ( rule__StringColor__Group__0 ) ) ;
    public final void ruleStringColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:146:2: ( ( ( rule__StringColor__Group__0 ) ) )
            // InternalDotColorParser.g:147:2: ( ( rule__StringColor__Group__0 ) )
            {
            // InternalDotColorParser.g:147:2: ( ( rule__StringColor__Group__0 ) )
            // InternalDotColorParser.g:148:3: ( rule__StringColor__Group__0 )
            {
             before(grammarAccess.getStringColorAccess().getGroup()); 
            // InternalDotColorParser.g:149:3: ( rule__StringColor__Group__0 )
            // InternalDotColorParser.g:149:4: rule__StringColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleStringColor"


    // $ANTLR start "entryRulehex"
    // InternalDotColorParser.g:158:1: entryRulehex : rulehex EOF ;
    public final void entryRulehex() throws RecognitionException {
        try {
            // InternalDotColorParser.g:159:1: ( rulehex EOF )
            // InternalDotColorParser.g:160:1: rulehex EOF
            {
             before(grammarAccess.getHexRule()); 
            pushFollow(FOLLOW_1);
            rulehex();

            state._fsp--;

             after(grammarAccess.getHexRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRulehex"


    // $ANTLR start "rulehex"
    // InternalDotColorParser.g:167:1: rulehex : ( ( rule__Hex__Group__0 ) ) ;
    public final void rulehex() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:171:2: ( ( ( rule__Hex__Group__0 ) ) )
            // InternalDotColorParser.g:172:2: ( ( rule__Hex__Group__0 ) )
            {
            // InternalDotColorParser.g:172:2: ( ( rule__Hex__Group__0 ) )
            // InternalDotColorParser.g:173:3: ( rule__Hex__Group__0 )
            {
             before(grammarAccess.getHexAccess().getGroup()); 
            // InternalDotColorParser.g:174:3: ( rule__Hex__Group__0 )
            // InternalDotColorParser.g:174:4: rule__Hex__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Hex__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getHexAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rulehex"


    // $ANTLR start "rule__Color__Alternatives"
    // InternalDotColorParser.g:182:1: rule__Color__Alternatives : ( ( ruleRGBColor ) | ( ruleHSVColor ) | ( ruleStringColor ) );
    public final void rule__Color__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:186:1: ( ( ruleRGBColor ) | ( ruleHSVColor ) | ( ruleStringColor ) )
            int alt2=3;
            switch ( input.LA(1) ) {
            case NumberSign:
                {
                alt2=1;
                }
                break;
            case RULE_COLOR_NUMBER:
                {
                int LA2_2 = input.LA(2);

                if ( (LA2_2==Comma||LA2_2==RULE_COLOR_NUMBER) ) {
                    alt2=2;
                }
                else if ( (LA2_2==EOF) ) {
                    alt2=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 2, 2, input);

                    throw nvae;
                }
                }
                break;
            case Solidus:
            case RULE_HEXADECIMAL_DIGIT:
            case RULE_COLOR_STRING:
                {
                alt2=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // InternalDotColorParser.g:187:2: ( ruleRGBColor )
                    {
                    // InternalDotColorParser.g:187:2: ( ruleRGBColor )
                    // InternalDotColorParser.g:188:3: ruleRGBColor
                    {
                     before(grammarAccess.getColorAccess().getRGBColorParserRuleCall_0()); 
                    pushFollow(FOLLOW_2);
                    ruleRGBColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getRGBColorParserRuleCall_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalDotColorParser.g:193:2: ( ruleHSVColor )
                    {
                    // InternalDotColorParser.g:193:2: ( ruleHSVColor )
                    // InternalDotColorParser.g:194:3: ruleHSVColor
                    {
                     before(grammarAccess.getColorAccess().getHSVColorParserRuleCall_1()); 
                    pushFollow(FOLLOW_2);
                    ruleHSVColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getHSVColorParserRuleCall_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalDotColorParser.g:199:2: ( ruleStringColor )
                    {
                    // InternalDotColorParser.g:199:2: ( ruleStringColor )
                    // InternalDotColorParser.g:200:3: ruleStringColor
                    {
                     before(grammarAccess.getColorAccess().getStringColorParserRuleCall_2()); 
                    pushFollow(FOLLOW_2);
                    ruleStringColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getStringColorParserRuleCall_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Color__Alternatives"


    // $ANTLR start "rule__StringColor__NameAlternatives_1_0"
    // InternalDotColorParser.g:209:1: rule__StringColor__NameAlternatives_1_0 : ( ( RULE_HEXADECIMAL_DIGIT ) | ( RULE_COLOR_STRING ) | ( RULE_COLOR_NUMBER ) );
    public final void rule__StringColor__NameAlternatives_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:213:1: ( ( RULE_HEXADECIMAL_DIGIT ) | ( RULE_COLOR_STRING ) | ( RULE_COLOR_NUMBER ) )
            int alt3=3;
            switch ( input.LA(1) ) {
            case RULE_HEXADECIMAL_DIGIT:
                {
                alt3=1;
                }
                break;
            case RULE_COLOR_STRING:
                {
                alt3=2;
                }
                break;
            case RULE_COLOR_NUMBER:
                {
                alt3=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }

            switch (alt3) {
                case 1 :
                    // InternalDotColorParser.g:214:2: ( RULE_HEXADECIMAL_DIGIT )
                    {
                    // InternalDotColorParser.g:214:2: ( RULE_HEXADECIMAL_DIGIT )
                    // InternalDotColorParser.g:215:3: RULE_HEXADECIMAL_DIGIT
                    {
                     before(grammarAccess.getStringColorAccess().getNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0()); 
                    match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalDotColorParser.g:220:2: ( RULE_COLOR_STRING )
                    {
                    // InternalDotColorParser.g:220:2: ( RULE_COLOR_STRING )
                    // InternalDotColorParser.g:221:3: RULE_COLOR_STRING
                    {
                     before(grammarAccess.getStringColorAccess().getNameCOLOR_STRINGTerminalRuleCall_1_0_1()); 
                    match(input,RULE_COLOR_STRING,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameCOLOR_STRINGTerminalRuleCall_1_0_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalDotColorParser.g:226:2: ( RULE_COLOR_NUMBER )
                    {
                    // InternalDotColorParser.g:226:2: ( RULE_COLOR_NUMBER )
                    // InternalDotColorParser.g:227:3: RULE_COLOR_NUMBER
                    {
                     before(grammarAccess.getStringColorAccess().getNameCOLOR_NUMBERTerminalRuleCall_1_0_2()); 
                    match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameCOLOR_NUMBERTerminalRuleCall_1_0_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__NameAlternatives_1_0"


    // $ANTLR start "rule__RGBColor__Group__0"
    // InternalDotColorParser.g:236:1: rule__RGBColor__Group__0 : rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1 ;
    public final void rule__RGBColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:240:1: ( rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1 )
            // InternalDotColorParser.g:241:2: rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__RGBColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__0"


    // $ANTLR start "rule__RGBColor__Group__0__Impl"
    // InternalDotColorParser.g:248:1: rule__RGBColor__Group__0__Impl : ( NumberSign ) ;
    public final void rule__RGBColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:252:1: ( ( NumberSign ) )
            // InternalDotColorParser.g:253:1: ( NumberSign )
            {
            // InternalDotColorParser.g:253:1: ( NumberSign )
            // InternalDotColorParser.g:254:2: NumberSign
            {
             before(grammarAccess.getRGBColorAccess().getNumberSignKeyword_0()); 
            match(input,NumberSign,FOLLOW_2); 
             after(grammarAccess.getRGBColorAccess().getNumberSignKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__0__Impl"


    // $ANTLR start "rule__RGBColor__Group__1"
    // InternalDotColorParser.g:263:1: rule__RGBColor__Group__1 : rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2 ;
    public final void rule__RGBColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:267:1: ( rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2 )
            // InternalDotColorParser.g:268:2: rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2
            {
            pushFollow(FOLLOW_3);
            rule__RGBColor__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__1"


    // $ANTLR start "rule__RGBColor__Group__1__Impl"
    // InternalDotColorParser.g:275:1: rule__RGBColor__Group__1__Impl : ( ( rule__RGBColor__RAssignment_1 ) ) ;
    public final void rule__RGBColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:279:1: ( ( ( rule__RGBColor__RAssignment_1 ) ) )
            // InternalDotColorParser.g:280:1: ( ( rule__RGBColor__RAssignment_1 ) )
            {
            // InternalDotColorParser.g:280:1: ( ( rule__RGBColor__RAssignment_1 ) )
            // InternalDotColorParser.g:281:2: ( rule__RGBColor__RAssignment_1 )
            {
             before(grammarAccess.getRGBColorAccess().getRAssignment_1()); 
            // InternalDotColorParser.g:282:2: ( rule__RGBColor__RAssignment_1 )
            // InternalDotColorParser.g:282:3: rule__RGBColor__RAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__RAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getRAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__1__Impl"


    // $ANTLR start "rule__RGBColor__Group__2"
    // InternalDotColorParser.g:290:1: rule__RGBColor__Group__2 : rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3 ;
    public final void rule__RGBColor__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:294:1: ( rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3 )
            // InternalDotColorParser.g:295:2: rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3
            {
            pushFollow(FOLLOW_3);
            rule__RGBColor__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__2"


    // $ANTLR start "rule__RGBColor__Group__2__Impl"
    // InternalDotColorParser.g:302:1: rule__RGBColor__Group__2__Impl : ( ( rule__RGBColor__GAssignment_2 ) ) ;
    public final void rule__RGBColor__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:306:1: ( ( ( rule__RGBColor__GAssignment_2 ) ) )
            // InternalDotColorParser.g:307:1: ( ( rule__RGBColor__GAssignment_2 ) )
            {
            // InternalDotColorParser.g:307:1: ( ( rule__RGBColor__GAssignment_2 ) )
            // InternalDotColorParser.g:308:2: ( rule__RGBColor__GAssignment_2 )
            {
             before(grammarAccess.getRGBColorAccess().getGAssignment_2()); 
            // InternalDotColorParser.g:309:2: ( rule__RGBColor__GAssignment_2 )
            // InternalDotColorParser.g:309:3: rule__RGBColor__GAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__GAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getGAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__2__Impl"


    // $ANTLR start "rule__RGBColor__Group__3"
    // InternalDotColorParser.g:317:1: rule__RGBColor__Group__3 : rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4 ;
    public final void rule__RGBColor__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:321:1: ( rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4 )
            // InternalDotColorParser.g:322:2: rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4
            {
            pushFollow(FOLLOW_3);
            rule__RGBColor__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__3"


    // $ANTLR start "rule__RGBColor__Group__3__Impl"
    // InternalDotColorParser.g:329:1: rule__RGBColor__Group__3__Impl : ( ( rule__RGBColor__BAssignment_3 ) ) ;
    public final void rule__RGBColor__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:333:1: ( ( ( rule__RGBColor__BAssignment_3 ) ) )
            // InternalDotColorParser.g:334:1: ( ( rule__RGBColor__BAssignment_3 ) )
            {
            // InternalDotColorParser.g:334:1: ( ( rule__RGBColor__BAssignment_3 ) )
            // InternalDotColorParser.g:335:2: ( rule__RGBColor__BAssignment_3 )
            {
             before(grammarAccess.getRGBColorAccess().getBAssignment_3()); 
            // InternalDotColorParser.g:336:2: ( rule__RGBColor__BAssignment_3 )
            // InternalDotColorParser.g:336:3: rule__RGBColor__BAssignment_3
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__BAssignment_3();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getBAssignment_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__3__Impl"


    // $ANTLR start "rule__RGBColor__Group__4"
    // InternalDotColorParser.g:344:1: rule__RGBColor__Group__4 : rule__RGBColor__Group__4__Impl ;
    public final void rule__RGBColor__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:348:1: ( rule__RGBColor__Group__4__Impl )
            // InternalDotColorParser.g:349:2: rule__RGBColor__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__4"


    // $ANTLR start "rule__RGBColor__Group__4__Impl"
    // InternalDotColorParser.g:355:1: rule__RGBColor__Group__4__Impl : ( ( rule__RGBColor__AAssignment_4 )? ) ;
    public final void rule__RGBColor__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:359:1: ( ( ( rule__RGBColor__AAssignment_4 )? ) )
            // InternalDotColorParser.g:360:1: ( ( rule__RGBColor__AAssignment_4 )? )
            {
            // InternalDotColorParser.g:360:1: ( ( rule__RGBColor__AAssignment_4 )? )
            // InternalDotColorParser.g:361:2: ( rule__RGBColor__AAssignment_4 )?
            {
             before(grammarAccess.getRGBColorAccess().getAAssignment_4()); 
            // InternalDotColorParser.g:362:2: ( rule__RGBColor__AAssignment_4 )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==RULE_HEXADECIMAL_DIGIT) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // InternalDotColorParser.g:362:3: rule__RGBColor__AAssignment_4
                    {
                    pushFollow(FOLLOW_2);
                    rule__RGBColor__AAssignment_4();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getRGBColorAccess().getAAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__4__Impl"


    // $ANTLR start "rule__HSVColor__Group__0"
    // InternalDotColorParser.g:371:1: rule__HSVColor__Group__0 : rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1 ;
    public final void rule__HSVColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:375:1: ( rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1 )
            // InternalDotColorParser.g:376:2: rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1
            {
            pushFollow(FOLLOW_4);
            rule__HSVColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__0"


    // $ANTLR start "rule__HSVColor__Group__0__Impl"
    // InternalDotColorParser.g:383:1: rule__HSVColor__Group__0__Impl : ( ( rule__HSVColor__HAssignment_0 ) ) ;
    public final void rule__HSVColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:387:1: ( ( ( rule__HSVColor__HAssignment_0 ) ) )
            // InternalDotColorParser.g:388:1: ( ( rule__HSVColor__HAssignment_0 ) )
            {
            // InternalDotColorParser.g:388:1: ( ( rule__HSVColor__HAssignment_0 ) )
            // InternalDotColorParser.g:389:2: ( rule__HSVColor__HAssignment_0 )
            {
             before(grammarAccess.getHSVColorAccess().getHAssignment_0()); 
            // InternalDotColorParser.g:390:2: ( rule__HSVColor__HAssignment_0 )
            // InternalDotColorParser.g:390:3: rule__HSVColor__HAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__HAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getHAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__0__Impl"


    // $ANTLR start "rule__HSVColor__Group__1"
    // InternalDotColorParser.g:398:1: rule__HSVColor__Group__1 : rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2 ;
    public final void rule__HSVColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:402:1: ( rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2 )
            // InternalDotColorParser.g:403:2: rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2
            {
            pushFollow(FOLLOW_4);
            rule__HSVColor__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__1"


    // $ANTLR start "rule__HSVColor__Group__1__Impl"
    // InternalDotColorParser.g:410:1: rule__HSVColor__Group__1__Impl : ( ( Comma )? ) ;
    public final void rule__HSVColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:414:1: ( ( ( Comma )? ) )
            // InternalDotColorParser.g:415:1: ( ( Comma )? )
            {
            // InternalDotColorParser.g:415:1: ( ( Comma )? )
            // InternalDotColorParser.g:416:2: ( Comma )?
            {
             before(grammarAccess.getHSVColorAccess().getCommaKeyword_1()); 
            // InternalDotColorParser.g:417:2: ( Comma )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==Comma) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // InternalDotColorParser.g:417:3: Comma
                    {
                    match(input,Comma,FOLLOW_2); 

                    }
                    break;

            }

             after(grammarAccess.getHSVColorAccess().getCommaKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__1__Impl"


    // $ANTLR start "rule__HSVColor__Group__2"
    // InternalDotColorParser.g:425:1: rule__HSVColor__Group__2 : rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3 ;
    public final void rule__HSVColor__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:429:1: ( rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3 )
            // InternalDotColorParser.g:430:2: rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3
            {
            pushFollow(FOLLOW_4);
            rule__HSVColor__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__2"


    // $ANTLR start "rule__HSVColor__Group__2__Impl"
    // InternalDotColorParser.g:437:1: rule__HSVColor__Group__2__Impl : ( ( rule__HSVColor__SAssignment_2 ) ) ;
    public final void rule__HSVColor__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:441:1: ( ( ( rule__HSVColor__SAssignment_2 ) ) )
            // InternalDotColorParser.g:442:1: ( ( rule__HSVColor__SAssignment_2 ) )
            {
            // InternalDotColorParser.g:442:1: ( ( rule__HSVColor__SAssignment_2 ) )
            // InternalDotColorParser.g:443:2: ( rule__HSVColor__SAssignment_2 )
            {
             before(grammarAccess.getHSVColorAccess().getSAssignment_2()); 
            // InternalDotColorParser.g:444:2: ( rule__HSVColor__SAssignment_2 )
            // InternalDotColorParser.g:444:3: rule__HSVColor__SAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__SAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getSAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__2__Impl"


    // $ANTLR start "rule__HSVColor__Group__3"
    // InternalDotColorParser.g:452:1: rule__HSVColor__Group__3 : rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4 ;
    public final void rule__HSVColor__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:456:1: ( rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4 )
            // InternalDotColorParser.g:457:2: rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4
            {
            pushFollow(FOLLOW_4);
            rule__HSVColor__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__3"


    // $ANTLR start "rule__HSVColor__Group__3__Impl"
    // InternalDotColorParser.g:464:1: rule__HSVColor__Group__3__Impl : ( ( Comma )? ) ;
    public final void rule__HSVColor__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:468:1: ( ( ( Comma )? ) )
            // InternalDotColorParser.g:469:1: ( ( Comma )? )
            {
            // InternalDotColorParser.g:469:1: ( ( Comma )? )
            // InternalDotColorParser.g:470:2: ( Comma )?
            {
             before(grammarAccess.getHSVColorAccess().getCommaKeyword_3()); 
            // InternalDotColorParser.g:471:2: ( Comma )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==Comma) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // InternalDotColorParser.g:471:3: Comma
                    {
                    match(input,Comma,FOLLOW_2); 

                    }
                    break;

            }

             after(grammarAccess.getHSVColorAccess().getCommaKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__3__Impl"


    // $ANTLR start "rule__HSVColor__Group__4"
    // InternalDotColorParser.g:479:1: rule__HSVColor__Group__4 : rule__HSVColor__Group__4__Impl ;
    public final void rule__HSVColor__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:483:1: ( rule__HSVColor__Group__4__Impl )
            // InternalDotColorParser.g:484:2: rule__HSVColor__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__4"


    // $ANTLR start "rule__HSVColor__Group__4__Impl"
    // InternalDotColorParser.g:490:1: rule__HSVColor__Group__4__Impl : ( ( rule__HSVColor__VAssignment_4 ) ) ;
    public final void rule__HSVColor__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:494:1: ( ( ( rule__HSVColor__VAssignment_4 ) ) )
            // InternalDotColorParser.g:495:1: ( ( rule__HSVColor__VAssignment_4 ) )
            {
            // InternalDotColorParser.g:495:1: ( ( rule__HSVColor__VAssignment_4 ) )
            // InternalDotColorParser.g:496:2: ( rule__HSVColor__VAssignment_4 )
            {
             before(grammarAccess.getHSVColorAccess().getVAssignment_4()); 
            // InternalDotColorParser.g:497:2: ( rule__HSVColor__VAssignment_4 )
            // InternalDotColorParser.g:497:3: rule__HSVColor__VAssignment_4
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__VAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getVAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__4__Impl"


    // $ANTLR start "rule__StringColor__Group__0"
    // InternalDotColorParser.g:506:1: rule__StringColor__Group__0 : rule__StringColor__Group__0__Impl rule__StringColor__Group__1 ;
    public final void rule__StringColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:510:1: ( rule__StringColor__Group__0__Impl rule__StringColor__Group__1 )
            // InternalDotColorParser.g:511:2: rule__StringColor__Group__0__Impl rule__StringColor__Group__1
            {
            pushFollow(FOLLOW_5);
            rule__StringColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__0"


    // $ANTLR start "rule__StringColor__Group__0__Impl"
    // InternalDotColorParser.g:518:1: rule__StringColor__Group__0__Impl : ( ( rule__StringColor__Group_0__0 )? ) ;
    public final void rule__StringColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:522:1: ( ( ( rule__StringColor__Group_0__0 )? ) )
            // InternalDotColorParser.g:523:1: ( ( rule__StringColor__Group_0__0 )? )
            {
            // InternalDotColorParser.g:523:1: ( ( rule__StringColor__Group_0__0 )? )
            // InternalDotColorParser.g:524:2: ( rule__StringColor__Group_0__0 )?
            {
             before(grammarAccess.getStringColorAccess().getGroup_0()); 
            // InternalDotColorParser.g:525:2: ( rule__StringColor__Group_0__0 )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==Solidus) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // InternalDotColorParser.g:525:3: rule__StringColor__Group_0__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__StringColor__Group_0__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStringColorAccess().getGroup_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__0__Impl"


    // $ANTLR start "rule__StringColor__Group__1"
    // InternalDotColorParser.g:533:1: rule__StringColor__Group__1 : rule__StringColor__Group__1__Impl ;
    public final void rule__StringColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:537:1: ( rule__StringColor__Group__1__Impl )
            // InternalDotColorParser.g:538:2: rule__StringColor__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__1"


    // $ANTLR start "rule__StringColor__Group__1__Impl"
    // InternalDotColorParser.g:544:1: rule__StringColor__Group__1__Impl : ( ( rule__StringColor__NameAssignment_1 ) ) ;
    public final void rule__StringColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:548:1: ( ( ( rule__StringColor__NameAssignment_1 ) ) )
            // InternalDotColorParser.g:549:1: ( ( rule__StringColor__NameAssignment_1 ) )
            {
            // InternalDotColorParser.g:549:1: ( ( rule__StringColor__NameAssignment_1 ) )
            // InternalDotColorParser.g:550:2: ( rule__StringColor__NameAssignment_1 )
            {
             before(grammarAccess.getStringColorAccess().getNameAssignment_1()); 
            // InternalDotColorParser.g:551:2: ( rule__StringColor__NameAssignment_1 )
            // InternalDotColorParser.g:551:3: rule__StringColor__NameAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__NameAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getNameAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__1__Impl"


    // $ANTLR start "rule__StringColor__Group_0__0"
    // InternalDotColorParser.g:560:1: rule__StringColor__Group_0__0 : rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1 ;
    public final void rule__StringColor__Group_0__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:564:1: ( rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1 )
            // InternalDotColorParser.g:565:2: rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1
            {
            pushFollow(FOLLOW_6);
            rule__StringColor__Group_0__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__0"


    // $ANTLR start "rule__StringColor__Group_0__0__Impl"
    // InternalDotColorParser.g:572:1: rule__StringColor__Group_0__0__Impl : ( Solidus ) ;
    public final void rule__StringColor__Group_0__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:576:1: ( ( Solidus ) )
            // InternalDotColorParser.g:577:1: ( Solidus )
            {
            // InternalDotColorParser.g:577:1: ( Solidus )
            // InternalDotColorParser.g:578:2: Solidus
            {
             before(grammarAccess.getStringColorAccess().getSolidusKeyword_0_0()); 
            match(input,Solidus,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSolidusKeyword_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__0__Impl"


    // $ANTLR start "rule__StringColor__Group_0__1"
    // InternalDotColorParser.g:587:1: rule__StringColor__Group_0__1 : rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2 ;
    public final void rule__StringColor__Group_0__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:591:1: ( rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2 )
            // InternalDotColorParser.g:592:2: rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2
            {
            pushFollow(FOLLOW_6);
            rule__StringColor__Group_0__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__1"


    // $ANTLR start "rule__StringColor__Group_0__1__Impl"
    // InternalDotColorParser.g:599:1: rule__StringColor__Group_0__1__Impl : ( ( rule__StringColor__SchemeAssignment_0_1 )? ) ;
    public final void rule__StringColor__Group_0__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:603:1: ( ( ( rule__StringColor__SchemeAssignment_0_1 )? ) )
            // InternalDotColorParser.g:604:1: ( ( rule__StringColor__SchemeAssignment_0_1 )? )
            {
            // InternalDotColorParser.g:604:1: ( ( rule__StringColor__SchemeAssignment_0_1 )? )
            // InternalDotColorParser.g:605:2: ( rule__StringColor__SchemeAssignment_0_1 )?
            {
             before(grammarAccess.getStringColorAccess().getSchemeAssignment_0_1()); 
            // InternalDotColorParser.g:606:2: ( rule__StringColor__SchemeAssignment_0_1 )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==RULE_COLOR_STRING) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // InternalDotColorParser.g:606:3: rule__StringColor__SchemeAssignment_0_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__StringColor__SchemeAssignment_0_1();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStringColorAccess().getSchemeAssignment_0_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__1__Impl"


    // $ANTLR start "rule__StringColor__Group_0__2"
    // InternalDotColorParser.g:614:1: rule__StringColor__Group_0__2 : rule__StringColor__Group_0__2__Impl ;
    public final void rule__StringColor__Group_0__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:618:1: ( rule__StringColor__Group_0__2__Impl )
            // InternalDotColorParser.g:619:2: rule__StringColor__Group_0__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__2"


    // $ANTLR start "rule__StringColor__Group_0__2__Impl"
    // InternalDotColorParser.g:625:1: rule__StringColor__Group_0__2__Impl : ( Solidus ) ;
    public final void rule__StringColor__Group_0__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:629:1: ( ( Solidus ) )
            // InternalDotColorParser.g:630:1: ( Solidus )
            {
            // InternalDotColorParser.g:630:1: ( Solidus )
            // InternalDotColorParser.g:631:2: Solidus
            {
             before(grammarAccess.getStringColorAccess().getSolidusKeyword_0_2()); 
            match(input,Solidus,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSolidusKeyword_0_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__2__Impl"


    // $ANTLR start "rule__Hex__Group__0"
    // InternalDotColorParser.g:641:1: rule__Hex__Group__0 : rule__Hex__Group__0__Impl rule__Hex__Group__1 ;
    public final void rule__Hex__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:645:1: ( rule__Hex__Group__0__Impl rule__Hex__Group__1 )
            // InternalDotColorParser.g:646:2: rule__Hex__Group__0__Impl rule__Hex__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__Hex__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Hex__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__0"


    // $ANTLR start "rule__Hex__Group__0__Impl"
    // InternalDotColorParser.g:653:1: rule__Hex__Group__0__Impl : ( RULE_HEXADECIMAL_DIGIT ) ;
    public final void rule__Hex__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:657:1: ( ( RULE_HEXADECIMAL_DIGIT ) )
            // InternalDotColorParser.g:658:1: ( RULE_HEXADECIMAL_DIGIT )
            {
            // InternalDotColorParser.g:658:1: ( RULE_HEXADECIMAL_DIGIT )
            // InternalDotColorParser.g:659:2: RULE_HEXADECIMAL_DIGIT
            {
             before(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_0()); 
            match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
             after(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__0__Impl"


    // $ANTLR start "rule__Hex__Group__1"
    // InternalDotColorParser.g:668:1: rule__Hex__Group__1 : rule__Hex__Group__1__Impl ;
    public final void rule__Hex__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:672:1: ( rule__Hex__Group__1__Impl )
            // InternalDotColorParser.g:673:2: rule__Hex__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Hex__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__1"


    // $ANTLR start "rule__Hex__Group__1__Impl"
    // InternalDotColorParser.g:679:1: rule__Hex__Group__1__Impl : ( RULE_HEXADECIMAL_DIGIT ) ;
    public final void rule__Hex__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:683:1: ( ( RULE_HEXADECIMAL_DIGIT ) )
            // InternalDotColorParser.g:684:1: ( RULE_HEXADECIMAL_DIGIT )
            {
            // InternalDotColorParser.g:684:1: ( RULE_HEXADECIMAL_DIGIT )
            // InternalDotColorParser.g:685:2: RULE_HEXADECIMAL_DIGIT
            {
             before(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_1()); 
            match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
             after(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__1__Impl"


    // $ANTLR start "rule__RGBColor__RAssignment_1"
    // InternalDotColorParser.g:695:1: rule__RGBColor__RAssignment_1 : ( rulehex ) ;
    public final void rule__RGBColor__RAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:699:1: ( ( rulehex ) )
            // InternalDotColorParser.g:700:2: ( rulehex )
            {
            // InternalDotColorParser.g:700:2: ( rulehex )
            // InternalDotColorParser.g:701:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getRHexParserRuleCall_1_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getRHexParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__RAssignment_1"


    // $ANTLR start "rule__RGBColor__GAssignment_2"
    // InternalDotColorParser.g:710:1: rule__RGBColor__GAssignment_2 : ( rulehex ) ;
    public final void rule__RGBColor__GAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:714:1: ( ( rulehex ) )
            // InternalDotColorParser.g:715:2: ( rulehex )
            {
            // InternalDotColorParser.g:715:2: ( rulehex )
            // InternalDotColorParser.g:716:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getGHexParserRuleCall_2_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getGHexParserRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__GAssignment_2"


    // $ANTLR start "rule__RGBColor__BAssignment_3"
    // InternalDotColorParser.g:725:1: rule__RGBColor__BAssignment_3 : ( rulehex ) ;
    public final void rule__RGBColor__BAssignment_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:729:1: ( ( rulehex ) )
            // InternalDotColorParser.g:730:2: ( rulehex )
            {
            // InternalDotColorParser.g:730:2: ( rulehex )
            // InternalDotColorParser.g:731:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getBHexParserRuleCall_3_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getBHexParserRuleCall_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__BAssignment_3"


    // $ANTLR start "rule__RGBColor__AAssignment_4"
    // InternalDotColorParser.g:740:1: rule__RGBColor__AAssignment_4 : ( rulehex ) ;
    public final void rule__RGBColor__AAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:744:1: ( ( rulehex ) )
            // InternalDotColorParser.g:745:2: ( rulehex )
            {
            // InternalDotColorParser.g:745:2: ( rulehex )
            // InternalDotColorParser.g:746:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getAHexParserRuleCall_4_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getAHexParserRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__AAssignment_4"


    // $ANTLR start "rule__HSVColor__HAssignment_0"
    // InternalDotColorParser.g:755:1: rule__HSVColor__HAssignment_0 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__HAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:759:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorParser.g:760:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorParser.g:760:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorParser.g:761:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getHCOLOR_NUMBERTerminalRuleCall_0_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getHCOLOR_NUMBERTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__HAssignment_0"


    // $ANTLR start "rule__HSVColor__SAssignment_2"
    // InternalDotColorParser.g:770:1: rule__HSVColor__SAssignment_2 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__SAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:774:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorParser.g:775:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorParser.g:775:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorParser.g:776:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getSCOLOR_NUMBERTerminalRuleCall_2_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getSCOLOR_NUMBERTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__SAssignment_2"


    // $ANTLR start "rule__HSVColor__VAssignment_4"
    // InternalDotColorParser.g:785:1: rule__HSVColor__VAssignment_4 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__VAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:789:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorParser.g:790:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorParser.g:790:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorParser.g:791:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getVCOLOR_NUMBERTerminalRuleCall_4_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getVCOLOR_NUMBERTerminalRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__VAssignment_4"


    // $ANTLR start "rule__StringColor__SchemeAssignment_0_1"
    // InternalDotColorParser.g:800:1: rule__StringColor__SchemeAssignment_0_1 : ( RULE_COLOR_STRING ) ;
    public final void rule__StringColor__SchemeAssignment_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:804:1: ( ( RULE_COLOR_STRING ) )
            // InternalDotColorParser.g:805:2: ( RULE_COLOR_STRING )
            {
            // InternalDotColorParser.g:805:2: ( RULE_COLOR_STRING )
            // InternalDotColorParser.g:806:3: RULE_COLOR_STRING
            {
             before(grammarAccess.getStringColorAccess().getSchemeCOLOR_STRINGTerminalRuleCall_0_1_0()); 
            match(input,RULE_COLOR_STRING,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSchemeCOLOR_STRINGTerminalRuleCall_0_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__SchemeAssignment_0_1"


    // $ANTLR start "rule__StringColor__NameAssignment_1"
    // InternalDotColorParser.g:815:1: rule__StringColor__NameAssignment_1 : ( ( rule__StringColor__NameAlternatives_1_0 ) ) ;
    public final void rule__StringColor__NameAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorParser.g:819:1: ( ( ( rule__StringColor__NameAlternatives_1_0 ) ) )
            // InternalDotColorParser.g:820:2: ( ( rule__StringColor__NameAlternatives_1_0 ) )
            {
            // InternalDotColorParser.g:820:2: ( ( rule__StringColor__NameAlternatives_1_0 ) )
            // InternalDotColorParser.g:821:3: ( rule__StringColor__NameAlternatives_1_0 )
            {
             before(grammarAccess.getStringColorAccess().getNameAlternatives_1_0()); 
            // InternalDotColorParser.g:822:3: ( rule__StringColor__NameAlternatives_1_0 )
            // InternalDotColorParser.g:822:4: rule__StringColor__NameAlternatives_1_0
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__NameAlternatives_1_0();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getNameAlternatives_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__NameAssignment_1"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000220L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000000E00L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000000000840L});

}