/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;

class OdaDriverObject
extends OdaObject {
    private OdaConnection m_connection;

    OdaDriverObject(Object obj, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super(obj, switchContextClassloader, driverClassLoader, connection.getOriginalContextClassLoader());
        this.m_connection = connection;
    }

    protected OdaConnection getOdaConnection() {
        return this.m_connection;
    }

    @Override
    protected void handleError(OdaException exception) throws OdaException {
        this.m_connection.handleError(exception);
    }

    protected String getClobAsStringImpl(IClob clobObj, String context) throws OdaException {
        String ret = null;
        if (clobObj == null) {
            return ret;
        }
        try {
            int len = (int)clobObj.length();
            ret = clobObj.getSubString(1L, len);
        }
        catch (UnsupportedOperationException ex) {
            this.handleUnsupportedOp(ex, context);
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        return ret;
    }
}

