/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.test;

import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvas;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class TestCanvas
extends GraphicCanvas {
    String m_text = null;

    public TestCanvas(Composite parent) {
        super(parent);
        this.initDefaultCanvas(parent);
    }

    @Override
    public void dispose() {
        this.cleanupDefaultCanvas();
        super.dispose();
    }

    protected void initDefaultCanvas(Composite parent) {
    }

    protected void cleanupDefaultCanvas() {
    }

    public void setText(String text) {
        this.m_text = text;
    }

    @Override
    public void paintCanvas(GC gc) {
        super.paintCanvas(gc);
        int margin = 10;
        TestCanvas.drawStringWrapNewlines(gc, this.m_text, margin, margin);
    }

    public static int getTextHeight(GC gc) {
        return gc.getFontMetrics().getHeight();
    }

    public static void drawStringWrapNewlines(GC gc, String text, int x, int y) {
        int lineHeight = TestCanvas.getTextHeight(gc);
        TestCanvas.drawStringWrapNewlines(gc, text, x, y, lineHeight);
    }

    public static void drawStringWrapNewlines(GC gc, String text, int x, int y, int lineHeight) {
        if (text != null) {
            String[] lines = text.split("\n");
            int i = 0;
            while (i < lines.length) {
                gc.drawString(lines[i], x, y, true);
                y += lineHeight;
                ++i;
            }
        }
    }
}

