/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.DefaultLoadingContext;
import org.eclipse.xwt.ICLRFactory;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.IDataProviderFactory;
import org.eclipse.xwt.ILoadingContext;
import org.eclipse.xwt.ILogger;
import org.eclipse.xwt.IMetaclassFactory;
import org.eclipse.xwt.INamespaceHandler;
import org.eclipse.xwt.IStyle;
import org.eclipse.xwt.IUIResource;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.Tracking;
import org.eclipse.xwt.callback.IBeforeParsingCallback;
import org.eclipse.xwt.converters.ObjectToObject;
import org.eclipse.xwt.converters.StringToEnum;
import org.eclipse.xwt.core.IElementLoaderFactory;
import org.eclipse.xwt.core.IRenderingContext;
import org.eclipse.xwt.core.IVisualElementLoader;
import org.eclipse.xwt.dataproviders.ObjectDataProvider;
import org.eclipse.xwt.input.ICommand;
import org.eclipse.xwt.internal.core.MetaclassManager;
import org.eclipse.xwt.internal.core.MetaclassService;
import org.eclipse.xwt.internal.core.UIResource;
import org.eclipse.xwt.internal.xml.Attribute;
import org.eclipse.xwt.internal.xml.DefaultElementCache;
import org.eclipse.xwt.internal.xml.DocumentObject;
import org.eclipse.xwt.internal.xml.DocumentRoot;
import org.eclipse.xwt.internal.xml.Element;
import org.eclipse.xwt.internal.xml.ElementManager;
import org.eclipse.xwt.internal.xml.IElementCache;
import org.eclipse.xwt.javabean.ValueConvertorRegister;
import org.eclipse.xwt.metadata.IMetaclass;

public class Core {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String DEFAULT_STYLES_KEY = "XWT.DefaultStyles";
    public static boolean TRACE_BENCH = false;
    private HashMap<Class<?>, Object> registrations;
    private HashMap<DocumentObject, IVisualElementLoader> elementsLoaders = new HashMap();
    private MetaclassService metaclassService;
    private IElementLoaderFactory loaderFactory;
    private ILoadingContext _loadingContext = null;
    private ICLRFactory clrFactory = null;
    private Set<Tracking> trackingSet = new HashSet<Tracking>();
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Map<String, INamespaceHandler> nsHandlers = new HashMap<String, INamespaceHandler>();
    private ILogger logger;
    private Collection<IStyle> defaultStyles = new ArrayList<IStyle>();
    private static LinkedHashMap<String, IDataProviderFactory> dataProviderFactories = new LinkedHashMap();
    private Collection<Class<?>> resolveTypes = new ArrayList();
    private IXWTLoader xwtLoader;
    public static ILogger nullLog = new ILogger(){
        private Map<Tracking, String> messageMap = new HashMap<Tracking, String>();

        @Override
        public void error(Throwable e) {
        }

        @Override
        public void error(Throwable e, String message) {
        }

        @Override
        public void message(String message) {
        }

        @Override
        public void warning(String message) {
        }

        public void printInfo(String message, Tracking tracking, Set trackType) {
            String printMessage = "";
            if (trackType != null && trackType.size() > 0 && trackType.contains((Object)tracking)) {
                printMessage = this.messageMap.get((Object)tracking);
            }
            System.out.println(printMessage);
        }

        @Override
        public void addMessage(String message, Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
            this.messageMap.put(tracking, message);
        }

        @Override
        public void removeMessage(Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
        }
    };

    public Core(IElementLoaderFactory loaderFactory, IXWTLoader xwtLoader) {
        this.loaderFactory = loaderFactory;
        this.registrations = new HashMap();
        this.xwtLoader = xwtLoader;
        this.metaclassService = new MetaclassService(xwtLoader);
    }

    public ILogger getLogger() {
        if (this.logger == null) {
            return nullLog;
        }
        return this.logger;
    }

    public void setLogger(ILogger log) {
        this.logger = log;
    }

    public ICLRFactory getCLRFactory() {
        return this.clrFactory;
    }

    public void setCLRFactory(ICLRFactory clrFactory) {
        this.clrFactory = clrFactory;
    }

    public void registerNamespaceHandler(String nsmapace, INamespaceHandler handler) {
        this.nsHandlers.put(nsmapace, handler);
    }

    public void unregisterNamespaceHandler(String nsmapace) {
        this.nsHandlers.remove(nsmapace);
    }

    public INamespaceHandler getNamespaceHandler(String nsmapace) {
        return this.nsHandlers.get(nsmapace);
    }

    public IConverter findConvertor(Class<?> source, Class<?> target) {
        if (source == target || source != Object.class && source.isAssignableFrom(target)) {
            return ObjectToObject.instance;
        }
        if (String.class == source && target.isEnum()) {
            return new StringToEnum(target);
        }
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)this.getService(ValueConvertorRegister.class);
        if (convertorRegister == null) {
            return null;
        }
        return convertorRegister.findConverter(source, target);
    }

    public void registerConvertor(IConverter converter) {
        Class source = (Class)converter.getFromType();
        Class target = (Class)converter.getToType();
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)this.getService(ValueConvertorRegister.class);
        convertorRegister.register(source, target, converter);
    }

    public void registerConvertor(Class<?> converter, String methodName) {
        try {
            Method method = converter.getDeclaredMethod(methodName, new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object instanceof IConverter) {
                this.registerConvertor((IConverter)object);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public void registerConvertor(Class<?> converterType, String methodName, boolean value) {
        IConverter converter = this.loadConvertor(converterType, methodName, value);
        if (converter != null) {
            this.registerConvertor(converter);
        }
    }

    public void registerConvertor(ValueConvertorRegister convertorRegister, Class<?> source, Class<?> target, Class<?> converterType, String methodName, boolean value) {
        IConverter converter = this.loadConvertor(converterType, methodName, value);
        if (converter != null) {
            convertorRegister.register(source, target, converter);
        }
    }

    public IConverter loadConvertor(Class<?> converter, String methodName, boolean value) {
        try {
            Method method = converter.getDeclaredMethod(methodName, Boolean.TYPE);
            Object object = method.invoke(null, value);
            if (object instanceof IConverter) {
                return (IConverter)object;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public ConverterService getConverterService() {
        ConverterService service = (ConverterService)this.getService(ConverterService.class);
        if (service == null) {
            service = new ConverterService();
            this.registerService(ConverterService.class, service);
            service.register(Object.class, new IConverter(){

                public Object convert(Object fromObject) {
                    return null;
                }

                public Object getFromType() {
                    return Object.class;
                }

                public Object getToType() {
                    return String.class;
                }
            });
        }
        return service;
    }

    public void addTracking(Tracking tracking) {
        if (!this.trackingSet.contains((Object)tracking)) {
            this.trackingSet.add(tracking);
        }
    }

    public boolean isTracking(Tracking tracking) {
        return this.trackingSet.contains((Object)tracking);
    }

    public Set<Tracking> getTrackings() {
        return this.trackingSet;
    }

    public void removeTracking(Tracking tracking) {
        if (this.trackingSet.contains((Object)tracking)) {
            this.trackingSet.remove((Object)tracking);
        }
    }

    public void registerCommand(String name, ICommand command) {
        this.commands.put(name, command);
    }

    public ICommand getCommand(String name) {
        return this.commands.get(name);
    }

    public Map<String, ICommand> getCommands() {
        return this.commands;
    }

    public void unregisterCommand(String name) {
        this.commands.remove(name);
    }

    public void addDefaultStyle(IStyle style) {
        this.defaultStyles.add(style);
    }

    public void removeDefaultStyle(IStyle style) {
        this.defaultStyles.remove(style);
    }

    public Collection<IStyle> getDefaultStyles() {
        return new ArrayList<IStyle>(this.defaultStyles);
    }

    public void addDataProviderFactory(String name, IDataProviderFactory dataProviderFactory) {
        if (dataProviderFactory == null) {
            return;
        }
        dataProviderFactories.put(name, dataProviderFactory);
        this.registerMetaclass(dataProviderFactory.getType());
    }

    public IMetaclass registerMetaclass(Class<?> type) {
        return this.registerMetaclass(type, "http://www.eclipse.org/xwt/presentation");
    }

    public void removeDataProviderFactory(String name) {
        if (name == null) {
            return;
        }
        dataProviderFactories.remove(name);
    }

    public void removeDataProviderFactory(IDataProviderFactory dataProviderFactory) {
        if (dataProviderFactory == null) {
            return;
        }
        for (String name : dataProviderFactories.keySet()) {
            IDataProviderFactory value = dataProviderFactories.get(name);
            if (dataProviderFactory != value) continue;
            dataProviderFactories.remove(name);
        }
    }

    public Collection<IDataProviderFactory> getDataProviderFactories() {
        return dataProviderFactories.values();
    }

    public IDataProvider findDataProvider(Object dataContext) {
        if (dataContext instanceof IDataProvider) {
            return (IDataProvider)dataContext;
        }
        for (IDataProviderFactory factory : dataProviderFactories.values()) {
            IDataProvider dataProvider = factory.create(dataContext);
            if (dataProvider == null) continue;
            return dataProvider;
        }
        ObjectDataProvider dataProvider = new ObjectDataProvider();
        dataProvider.setObjectInstance(dataContext);
        return dataProvider;
    }

    public ILoadingContext getLoadingContext() {
        if (this._loadingContext == null) {
            return DefaultLoadingContext.defaultLoadingContext;
        }
        return this._loadingContext;
    }

    public void setLoadingContext(ILoadingContext loadingContext) {
        this._loadingContext = loadingContext;
    }

    public ILoadingContext findLoadingContext(Object container) {
        return this.getLoadingContext();
    }

    public IMetaclass getMetaclass(ILoadingContext context, String name, String namespace) {
        return this.getMetaclassService().getMetaclass(context, name, namespace);
    }

    public IMetaclass findMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclassService().findMetaclass((Class)object);
        }
        return this.getMetaclassService().findMetaclass(object.getClass());
    }

    public IMetaclass getMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclassService().getMetaclass((Class)object);
        }
        return this.getMetaclassService().getMetaclass(object.getClass());
    }

    public IMetaclass getMetaclass(Object object, String namespace) {
        if (object instanceof Class) {
            return this.getMetaclassService().getMetaclass((Class)object, namespace);
        }
        return this.getMetaclassService().getMetaclass(object.getClass(), namespace);
    }

    public Collection<IMetaclass> getAllMetaclasses(String namespace) {
        return this.getMetaclassService().getAllMetaclasses(namespace);
    }

    public void registerMetaclass(IMetaclass metaclass, String namespace) {
        this.getMetaclassService().register(metaclass, namespace);
    }

    public void registerMetaclassFactory(IMetaclassFactory metaclassFactory) {
        this.getMetaclassService().registerFactory(metaclassFactory);
    }

    public IMetaclass registerMetaclass(Class<?> metaclass, String namespace) {
        return this.getMetaclassService().register(metaclass, namespace);
    }

    public IMetaclass registerMetaclass(Class<?> metaclass, String namespace, IMetaclass superMetaclass) {
        return this.getMetaclassService().register(metaclass, namespace, superMetaclass);
    }

    public void registerMetaclassManager(String namespace, MetaclassManager manager) {
        this.getMetaclassService().register(namespace, manager);
    }

    public Object getService(Class<?> type) {
        return this.registrations.get(type);
    }

    public void registerService(Class<?> serviceType, Object service) {
        this.registrations.put(serviceType, service);
    }

    protected Object createCLRElement(IRenderingContext context, Element element, Map<String, Object> options) {
        IVisualElementLoader loader = this.findElementLoader(element);
        if (loader != null) {
            return loader.createUIElement(element, options);
        }
        loader = this.createElementLoader(context, element);
        Object visualObject = loader.createUIElement(element, options);
        this.removeElementLoader(element);
        return visualObject;
    }

    protected IVisualElementLoader findElementLoader(DocumentObject element) {
        IVisualElementLoader loader = this.elementsLoaders.get(element);
        if (loader != null) {
            return loader;
        }
        if (element.getParent() != null) {
            return this.findElementLoader(element.getParent());
        }
        return null;
    }

    protected IVisualElementLoader createElementLoader(IRenderingContext context, DocumentObject element) {
        IVisualElementLoader creator = this.loaderFactory.createElementLoader(context, this.xwtLoader);
        this.elementsLoaders.put(element, creator);
        return creator;
    }

    protected void removeElementLoader(DocumentObject element) {
        this.elementsLoaders.remove(element);
    }

    public Object load(ILoadingContext loadingContext, URL input, Map<String, Object> options) throws Exception {
        return this.load(loadingContext, null, input, options);
    }

    public IUIResource loadAsResource(InputStream stream, URL input, IBeforeParsingCallback parsingCallback) throws Exception {
        ElementManager manager = new ElementManager();
        Element element = null;
        if (stream == null) {
            element = manager.load(input, parsingCallback);
        } else {
            InputStream inputStream = stream;
            if (parsingCallback != null) {
                int size = stream.read();
                byte[] buffer = new byte[size];
                stream.read(buffer);
                String content = new String(buffer);
                stream.close();
                content = parsingCallback.onParsing(content);
                inputStream = new ByteArrayInputStream(content.getBytes());
                element = manager.load(stream, input);
            }
            element = manager.load(inputStream, input);
        }
        return new UIResource(input, element);
    }

    public Object load(ILoadingContext loadingContext, IUIResource pattern, Map<String, Object> options) throws Exception {
        Element element;
        UIResource uiResource = (UIResource)pattern;
        Control control = null;
        ElementManager manager = new ElementManager(uiResource.getURL());
        ExtensionContext context = new ExtensionContext(loadingContext, manager, (element = uiResource.getContent()).getNamespace());
        Object visual = this.createCLRElement(context, element, options);
        if (visual instanceof Control) {
            control = (Control)visual;
        } else if (visual instanceof Viewer) {
            control = ((Viewer)visual).getControl();
        } else {
            Class<?> jfaceWindow = Class.forName("org.eclipse.jface.window.Window");
            if (jfaceWindow != null && jfaceWindow.isInstance(visual)) {
                Method createMethod = jfaceWindow.getDeclaredMethod("create", new Class[0]);
                createMethod.invoke(visual, new Object[0]);
                Method method = jfaceWindow.getDeclaredMethod("getShell", new Class[0]);
                control = (Control)method.invoke(visual, new Object[0]);
            }
        }
        if (control instanceof Composite) {
            Object parent = options.get("XWT.Container");
            Object designMode = options.get("XWT.DesignMode");
            if (parent instanceof Composite) {
                Composite parentComposite = (Composite)parent;
                if (parentComposite.getLayout() == null || designMode == Boolean.TRUE) {
                    this.autoLayout((Control)parentComposite, element);
                }
            } else if (parent == null || designMode == Boolean.TRUE) {
                if (control instanceof Shell) {
                    this.autoLayout((Control)((Shell)control), element);
                } else {
                    this.autoLayout((Control)control.getShell(), element);
                }
            }
        }
        return visual;
    }

    public Control load(ILoadingContext loadingContext, InputStream stream, URL input, Map<String, Object> options) throws Exception {
        long start = System.currentTimeMillis();
        Control control = null;
        ElementManager manager = new ElementManager();
        if (input != null) {
            Element element = null;
            IElementCache cache = this.getCache(options);
            element = cache.getElement(input);
            if (element != null) {
                manager.setRootElement(element);
                if (stream != null) {
                    stream.close();
                }
            } else {
                if (stream == null) {
                    element = manager.load(input, (IBeforeParsingCallback)options.get(IXWTLoader.BEFORE_PARSING_CALLBACK));
                } else {
                    IBeforeParsingCallback callback = (IBeforeParsingCallback)options.get(IXWTLoader.BEFORE_PARSING_CALLBACK);
                    InputStream inputStream = stream;
                    if (callback != null) {
                        int size = stream.read();
                        byte[] buffer = new byte[size];
                        stream.read(buffer);
                        String content = new String(buffer);
                        stream.close();
                        content = callback.onParsing(content);
                        inputStream = new ByteArrayInputStream(content.getBytes());
                        element = manager.load(stream, input);
                    }
                    element = manager.load(inputStream, input);
                }
                cache.cache(input, element);
            }
            ExtensionContext context = new ExtensionContext(loadingContext, manager, manager.getRootElement().getNamespace());
            Object visual = this.createCLRElement(context, element, options);
            if (TRACE_BENCH) {
                System.out.println("Loaded: " + (System.currentTimeMillis() - start) + "  " + input.toString());
            }
            if (visual instanceof Control) {
                control = (Control)visual;
            } else if (visual instanceof Viewer) {
                control = ((Viewer)visual).getControl();
            } else {
                Class<?> jfaceWindow = Class.forName("org.eclipse.jface.window.Window");
                if (jfaceWindow != null && jfaceWindow.isInstance(visual)) {
                    Method createMethod = jfaceWindow.getDeclaredMethod("create", new Class[0]);
                    createMethod.invoke(visual, new Object[0]);
                    Method method = jfaceWindow.getDeclaredMethod("getShell", new Class[0]);
                    control = (Control)method.invoke(visual, new Object[0]);
                }
            }
            Object parent = options.get("XWT.Container");
            Object designMode = options.get("XWT.DesignMode");
            if (control instanceof Composite) {
                if (parent instanceof Composite) {
                    Composite parentComposite = (Composite)parent;
                    if (parentComposite.getLayout() == null || designMode == Boolean.TRUE) {
                        this.autoLayout((Control)parentComposite, element);
                    }
                } else if (parent == null || designMode == Boolean.TRUE) {
                    if (control instanceof Shell) {
                        this.autoLayout((Control)((Shell)control), element);
                    } else {
                        this.autoLayoutShell(control, element);
                    }
                }
            } else if (control != null && (parent == null || designMode == Boolean.TRUE)) {
                this.autoLayoutShell(control, element);
            }
        }
        return control;
    }

    private IElementCache getCache(Map<String, Object> options) {
        IElementCache option;
        IElementCache iElementCache = option = options == null ? IElementCache.NULL : options.get(IXWTLoader.XML_CACHE_PROPERTY);
        if (option instanceof Boolean) {
            option = (Boolean)((Object)option) != false ? new DefaultElementCache() : IElementCache.NULL;
            options.put(IXWTLoader.XML_CACHE_PROPERTY, option);
        } else if (option instanceof Number) {
            option = new DefaultElementCache(((Number)((Object)option)).intValue());
            options.put(IXWTLoader.XML_CACHE_PROPERTY, option);
        } else if (!(option instanceof IElementCache)) {
            option = IElementCache.NULL;
            options.put(IXWTLoader.XML_CACHE_PROPERTY, option);
        }
        return option;
    }

    protected void autoLayout(Control composite, Element element) {
        Attribute size;
        if (element == null) {
            return;
        }
        Attribute bounds = element.getAttribute("Bounds");
        if (bounds == null) {
            bounds = element.getAttribute("Bounds", "http://www.eclipse.org/xwt/presentation");
        }
        if ((size = element.getAttribute("Size")) == null) {
            size = element.getAttribute("Size", "http://www.eclipse.org/xwt/presentation");
        }
        if (bounds == null && size == null) {
            composite.pack();
        }
    }

    protected void autoLayoutShell(Control control, Element element) {
        Attribute size;
        if (element == null) {
            return;
        }
        Attribute bounds = element.getAttribute("Bounds");
        if (bounds == null) {
            bounds = element.getAttribute("Bounds", "http://www.eclipse.org/xwt/presentation");
        }
        if ((size = element.getAttribute("Size")) == null) {
            size = element.getAttribute("Size", "http://www.eclipse.org/xwt/presentation");
        }
        if (bounds == null && size == null) {
            control.pack();
        } else {
            Shell shell = control.getShell();
            Point targetSize = control.getSize();
            Rectangle rectangle = shell.getBounds();
            Rectangle clientArea = shell.getClientArea();
            targetSize.x += rectangle.width - clientArea.width;
            targetSize.y += rectangle.height - clientArea.height;
            shell.setSize(targetSize);
        }
    }

    public MetaclassService getMetaclassService() {
        return this.metaclassService;
    }

    public boolean isFileResolveType(Class<?> type) {
        for (Class<?> resolveType : this.resolveTypes) {
            if (!resolveType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public void registerFileResolveType(Class<?> type) {
        if (!this.resolveTypes.contains(type)) {
            this.resolveTypes.add(type);
        }
    }

    public void unregisterFileResolveType(Class<?> type) {
        this.resolveTypes.remove(type);
    }

    class ConverterService {
        protected Map<Class<?>, IConverter> converters = new HashMap();

        ConverterService() {
        }

        public IConverter getConverter(Class<?> type) {
            IConverter converter = this.converters.get(type);
            if (converter != null) {
                return converter;
            }
            return null;
        }

        public void register(Class<?> type, IConverter converter) {
            this.converters.put(type, converter);
        }
    }

    private static class ExtensionContext
    implements IRenderingContext {
        private Map<String, Object> properties = new HashMap<String, Object>();
        private URL resourcePath;
        private DocumentRoot documentRoot;
        private String namespace;
        private String encoding;
        protected ILoadingContext loadingContext;

        public ExtensionContext(ILoadingContext loadingContext, ElementManager elementManager, String namespace) {
            this.documentRoot = elementManager.getDocumentRoot();
            this.resourcePath = this.documentRoot.getPath();
            this.namespace = namespace;
            this.loadingContext = loadingContext;
            this.encoding = elementManager.getEncoding();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public InputStream openStream(String path) throws IOException {
            return this.documentRoot.openStream(path);
        }

        @Override
        public URL getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        @Override
        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        @Override
        public ILoadingContext getLoadingContext() {
            return this.loadingContext;
        }
    }
}

