/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.correction.SourceValidationQuickAssistProcessor;

public class CompoundQuickAssistProcessor
implements IQuickAssistProcessor {
    private final String QUICK_ASSIST_PROCESSOR_EXTENDED_ID = IQuickAssistProcessor.class.getName();
    private Map<String, Set<IQuickAssistProcessor>> fProcessors;
    private IQuickAssistProcessor fQuickFixProcessor;
    private List<String> fInstalledExtendedContentTypes;

    private Set<IQuickAssistProcessor> getQuickAssistProcessors(IQuickAssistInvocationContext invocationContext, String partitionType) {
        Collection<Object> processors;
        if (this.fInstalledExtendedContentTypes == null || !this.fInstalledExtendedContentTypes.contains(partitionType)) {
            processors = ExtendedConfigurationBuilder.getInstance().getConfigurations(this.QUICK_ASSIST_PROCESSOR_EXTENDED_ID, partitionType);
            if (processors != null && !processors.isEmpty()) {
                for (IQuickAssistProcessor processor : processors) {
                    this.setQuickAssistProcessor(partitionType, processor);
                }
            }
            if (this.fInstalledExtendedContentTypes == null) {
                this.fInstalledExtendedContentTypes = new ArrayList<String>();
            }
            this.fInstalledExtendedContentTypes.add(partitionType);
        }
        processors = null;
        if (this.fProcessors != null) {
            processors = this.fProcessors.get(partitionType);
        }
        return processors;
    }

    private Set<IQuickAssistProcessor> getQuickAssistProcessors(IQuickAssistInvocationContext invocationContext) {
        Set<IQuickAssistProcessor> processors = null;
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        if (sourceViewer != null) {
            IDocument document = sourceViewer.getDocument();
            try {
                String partitionType = document != null ? TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)invocationContext.getOffset(), (boolean)true) : "__dftl_partition_content_type";
                processors = this.getQuickAssistProcessors(invocationContext, partitionType);
            }
            catch (BadLocationException x) {
                Logger.log(202, x.getMessage(), x);
            }
        }
        return processors;
    }

    private IQuickAssistProcessor getQuickFixProcessor() {
        if (this.fQuickFixProcessor == null) {
            this.fQuickFixProcessor = new SourceValidationQuickAssistProcessor();
        }
        return this.fQuickFixProcessor;
    }

    private void setQuickAssistProcessor(String partitionType, IQuickAssistProcessor processor) {
        if (this.fProcessors == null) {
            this.fProcessors = new HashMap<String, Set<IQuickAssistProcessor>>();
        }
        Set<IQuickAssistProcessor> processors = this.fProcessors.get(partitionType);
        if (processor == null && processors != null) {
            processors.clear();
            this.fProcessors.remove(partitionType);
        } else {
            if (processors == null) {
                processors = new LinkedHashSet<IQuickAssistProcessor>();
            }
            processors.add(processor);
            this.fProcessors.put(partitionType, processors);
        }
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        Set<IQuickAssistProcessor> processors = this.getQuickAssistProcessors(invocationContext);
        if (processors != null) {
            for (IQuickAssistProcessor p : processors) {
                if (!p.canAssist(invocationContext)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canFix(Annotation annotation) {
        IQuickAssistProcessor processor = this.getQuickFixProcessor();
        return processor.canFix(annotation);
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        Set<IQuickAssistProcessor> processors;
        ArrayList<ICompletionProposal> proposalsList = new ArrayList<ICompletionProposal>();
        IQuickAssistProcessor processor = this.getQuickFixProcessor();
        ICompletionProposal[] proposals = processor.computeQuickAssistProposals(invocationContext);
        if (proposals != null && proposals.length > 0) {
            proposalsList.addAll(Arrays.asList(proposals));
        }
        if (proposalsList.isEmpty() && (processors = this.getQuickAssistProcessors(invocationContext)) != null) {
            for (IQuickAssistProcessor assistProcessor : processors) {
                ICompletionProposal[] assistProposals = assistProcessor.computeQuickAssistProposals(invocationContext);
                if (assistProposals == null || assistProposals.length <= 0) continue;
                proposalsList.addAll(Arrays.asList(assistProposals));
            }
        }
        if (proposalsList.isEmpty()) {
            return null;
        }
        return proposalsList.toArray(new ICompletionProposal[proposalsList.size()]);
    }

    public String getErrorMessage() {
        return null;
    }
}

