/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.preferences;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.internal.preferences.IPreferenceConsts;

public class PreferencesInitializer
extends AbstractPreferenceInitializer
implements IPreferenceConsts {
    public void initializeDefaultPreferences() {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault("PrefIntervalGrades", "Off:0|Default:15");
        preferenceStore.setDefault("PrefIntervalMRUCount", 5);
    }

    public static void addMRUInterval(int interval) {
        if (interval <= 0 || "Off:0|Default:15".contains(":" + interval)) {
            return;
        }
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        String mruList = prefStore.getString("PrefIntervalMRUList");
        if (mruList == null || mruList.trim().length() == 0) {
            mruList = "" + interval;
        } else {
            int comma;
            StringTokenizer st = new StringTokenizer(mruList, ":");
            int maxCount = prefStore.getInt("PrefIntervalMRUCount");
            boolean found = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int s = Integer.parseInt(token);
                    if (s != interval) continue;
                    found = true;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!found && (st = new StringTokenizer(mruList = String.valueOf(mruList) + ":" + interval, ":")).countTokens() > maxCount && (comma = mruList.indexOf(":")) != -1) {
                mruList = mruList.substring(comma + 1);
            }
        }
        prefStore.setValue("PrefIntervalMRUList", mruList);
    }
}

