/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureDependenciesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.Preferences;

public class RequiresSection
extends TableSection
implements IPluginModelListener,
IFeatureModelListener {
    private static final int RECOMPUTE_IMPORT = 3;
    private static final int REMOVE = 2;
    private static final int NEW_FEATURE = 1;
    private static final int NEW_PLUGIN = 0;
    private Button fSyncButton;
    private TableViewer fPluginViewer;
    private Action fDeleteAction;
    private SortAction fSortAction;
    private Action fOpenAction;

    public RequiresSection(FeatureDependenciesPage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEUIMessages.FeatureEditor_RequiresSection_plugin, PDEUIMessages.FeatureEditor_RequiresSection_feature, PDEUIMessages.FeatureEditor_RequiresSection_remove, PDEUIMessages.FeatureEditor_RequiresSection_compute});
        this.getSection().setText(PDEUIMessages.FeatureEditor_RequiresSection_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_RequiresSection_desc);
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.fSyncButton = toolkit.createButton(container, PDEUIMessages.FeatureEditor_RequiresSection_sync, 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fSyncButton.setLayoutData((Object)gd);
        this.fSyncButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IEclipsePreferences eclipsePrefs = Platform.getPreferencesService().getRootNode();
            Preferences prefs = eclipsePrefs.node("instance").node("org.eclipse.pde.ui");
            prefs.putBoolean(model.getFeature().getLabel(), this.fSyncButton.getSelection());
        }));
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPluginViewer = tablePart.getTableViewer();
        this.fPluginViewer.setContentProvider((IContentProvider)new ImportContentProvider());
        this.fPluginViewer.setComparator(ListUtil.NAME_COMPARATOR);
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fDeleteAction = new Action(){

            public void run() {
                RequiresSection.this.handleDelete();
            }
        };
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fOpenAction = new Action(PDEUIMessages.Actions_open_label){

            public void run() {
                RequiresSection.this.handleOpen();
            }
        };
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction(this.getStructuredViewerPart().getViewer(), PDEUIMessages.FeatureEditor_RequiresSection_sortAlpha, ListUtil.NAME_COMPARATOR, null, null);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewPlugin();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 2: {
                this.handleDelete();
                break;
            }
            case 3: {
                this.recomputeImports();
            }
        }
    }

    private void handleNewPlugin() {
        BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), () -> {
            IPluginModelBase[] allModels = PluginRegistry.getActiveModels();
            ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
            IPluginModelBase[] iPluginModelBaseArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (this.canAdd(model)) {
                    newModels.add(model);
                }
                ++n2;
            }
            IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
            PluginSelectionDialog dialog = new PluginSelectionDialog(this.fPluginViewer.getTable().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAdd(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private boolean canAdd(IPluginModelBase candidate) {
        IFeaturePlugin[] fplugins;
        IFeatureImport[] imports;
        IPluginBase plugin = candidate.getPluginBase();
        if (candidate.isFragmentModel()) {
            return false;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeatureImport[] iFeatureImportArray = imports = model.getFeature().getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (plugin.getId().equals(featureImport.getId())) {
                return false;
            }
            ++n2;
        }
        IFeaturePlugin[] iFeaturePluginArray = fplugins = model.getFeature().getPlugins();
        int n3 = fplugins.length;
        n = 0;
        while (n < n3) {
            IFeaturePlugin featurePlugin = iFeaturePluginArray[n];
            if (plugin.getId().equals(featurePlugin.getId())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void handleNewFeature() {
        BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), () -> {
            IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
            ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
            IFeatureModel[] iFeatureModelArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel model = iFeatureModelArray[n2];
                if (this.canAdd(model)) {
                    newModels.add(model);
                }
                ++n2;
            }
            IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
            FeatureSelectionDialog dialog = new FeatureSelectionDialog(this.fPluginViewer.getTable().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAdd(models);
                }
                catch (CoreException e) {
                    PDECore.log((Throwable)e);
                }
            }
        });
    }

    private void doAdd(Object[] candidates) throws CoreException {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureImport[] added = new IFeatureImport[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate;
            FeatureImport fimport = (FeatureImport)model.getFactory().createImport();
            if (candidates[i] instanceof IFeatureModel) {
                candidate = (IFeatureModel)candidates[i];
                fimport.loadFrom(candidate.getFeature());
            } else {
                candidate = (IPluginModelBase)candidates[i];
                IPluginBase pluginBase = candidate.getPluginBase();
                fimport.setId(pluginBase.getId());
            }
            added[i] = fimport;
            ++i;
        }
        feature.addImports(added);
    }

    private boolean canAdd(IFeatureModel candidate) {
        IFeatureImport[] features;
        IFeature cfeature = candidate.getFeature();
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (cfeature.getId().equals(feature.getId()) && cfeature.getVersion().equals(feature.getVersion())) {
            return false;
        }
        IFeatureImport[] iFeatureImportArray = features = feature.getImports();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.getId().equals(cfeature.getId()) && featureImport.getVersion() != null && featureImport.getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void handleDelete() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        IStructuredSelection selection = this.fPluginViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            IFeatureImport[] deleted = new IFeatureImport[selection.size()];
            int i = 0;
            for (IFeatureImport iimport : selection) {
                deleted[i++] = iimport;
            }
            feature.removeImports(deleted);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen();
    }

    private void handleOpen() {
        IStructuredSelection sel = this.fPluginViewer.getStructuredSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FeatureImport) {
            FeatureImport featureImport = (FeatureImport)obj;
            if (featureImport.getType() == 0) {
                IPlugin plugin = featureImport.getPlugin();
                if (plugin == null) {
                    this.logNullFeatureImport(obj);
                    return;
                }
                ManifestEditor.open(plugin, false);
            } else if (featureImport.getType() == 1) {
                IFeature feature = featureImport.getFeature();
                if (feature == null) {
                    this.logNullFeatureImport(obj);
                    return;
                }
                FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
                IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
                FeatureEditor.openFeatureEditor(model);
            }
        }
    }

    private void logNullFeatureImport(Object obj) {
        PDEPlugin.log(Status.warning((String)NLS.bind((String)PDEUIMessages.RequiresSection_nullLog, (Object)obj)));
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getFeatureModelManager().removeFeatureModelListener((IFeatureModelListener)this);
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), this::handleDelete);
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), this::handleSelectAll);
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        if (object instanceof IFeatureImport) {
            StructuredSelection ssel = new StructuredSelection(object);
            this.fPluginViewer.setSelection((ISelection)ssel);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.fPluginViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fOpenAction);
            manager.add((IAction)this.fDeleteAction);
            manager.add((IContributionItem)new Separator());
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    @Override
    protected void registerPopupMenu(MenuManager popupMenuManager) {
        IEditorSite site = (IEditorSite)this.getPage().getSite();
        site.registerContextMenu(String.valueOf(site.getId()) + ".plugins", popupMenuManager, (ISelectionProvider)this.fViewerPart.getViewer(), false);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.getPage().getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)selection);
        this.updateButtons();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean hasSelection = tableSelection.length > 0;
        tablePart.setButtonEnabled(2, this.isEditable() && hasSelection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
            this.getTablePart().setButtonEnabled(2, false);
            this.getTablePart().setButtonEnabled(3, false);
            this.fSyncButton.setEnabled(false);
        }
        IEclipsePreferences eclipsePrefs = Platform.getPreferencesService().getRootNode();
        Preferences prefs = eclipsePrefs.node("instance").node("org.eclipse.pde.ui");
        this.fSyncButton.setSelection(prefs.getBoolean(model.getFeature().getLabel(), false));
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getFeatureModelManager().addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3) {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                this.fPluginViewer.refresh(obj);
            }
        } else {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                if (e.getChangeType() == 1) {
                    this.fPluginViewer.add(e.getChangedObjects());
                    if (e.getChangedObjects().length > 0) {
                        this.fPluginViewer.setSelection((ISelection)new StructuredSelection(e.getChangedObjects()[0]));
                    }
                } else {
                    this.fPluginViewer.remove(e.getChangedObjects());
                }
            } else if (obj instanceof IFeaturePlugin && this.fSyncButton.getSelection()) {
                this.recomputeImports();
            }
        }
    }

    private void recomputeImports() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        try {
            feature.computeImports();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void modelsChanged(PluginModelDelta delta) {
        this.getSection().getDisplay().asyncExec(() -> {
            if (this.getSection().isDisposed()) {
                return;
            }
            ModelEntry[] added = delta.getAddedEntries();
            ModelEntry[] removed = delta.getRemovedEntries();
            ModelEntry[] changed = delta.getChangedEntries();
            if (this.hasModels(added) || this.hasModels(removed) || this.hasModels(changed)) {
                this.markStale();
            }
        });
    }

    private boolean hasModels(ModelEntry[] entries) {
        if (entries == null) {
            return false;
        }
        return entries.length > 0;
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.getSection().getDisplay().asyncExec(() -> {
            if (this.getSection().isDisposed()) {
                return;
            }
            IFeatureModel[] added = delta.getAdded();
            IFeatureModel[] removed = delta.getRemoved();
            IFeatureModel[] changed = delta.getChanged();
            if (this.hasModels(added) || this.hasModels(removed) || this.hasModels(changed)) {
                this.markStale();
            }
        });
    }

    private boolean hasModels(IFeatureModel[] models) {
        if (models == null) {
            return false;
        }
        IFeatureModel thisModel = (IFeatureModel)this.getPage().getModel();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model != thisModel) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setFocus() {
        if (this.fPluginViewer != null) {
            this.fPluginViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fPluginViewer.setInput((Object)feature);
        this.updateButtons();
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeatureImport)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void doPaste() {
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && this.canPaste(null, objects)) {
            this.doPaste(null, objects);
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (!model.isEditable()) {
            return;
        }
        IFeatureImport[] imports = new IFeatureImport[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                FeatureImport fImport = (FeatureImport)objects[i];
                fImport.setModel(model);
                fImport.setParent((IFeatureObject)feature);
                imports[i] = fImport;
                ++i;
            }
            feature.addImports(imports);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    void fireSelection() {
        IStructuredSelection sel = this.fPluginViewer.getStructuredSelection();
        if (!sel.isEmpty()) {
            this.fPluginViewer.setSelection((ISelection)this.fPluginViewer.getStructuredSelection());
        } else if (this.fPluginViewer.getElementAt(0) != null) {
            this.fPluginViewer.setSelection((ISelection)new StructuredSelection(this.fPluginViewer.getElementAt(0)));
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    static class ImportContentProvider
    implements IStructuredContentProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                IFeatureImport[] imports = ((IFeature)parent).getImports();
                ArrayList<IFeatureImport> displayable = new ArrayList<IFeatureImport>();
                IFeatureImport[] iFeatureImportArray = imports;
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeatureImport featureImport = iFeatureImportArray[n2];
                    if (!featureImport.isPatch()) {
                        displayable.add(featureImport);
                    }
                    ++n2;
                }
                return displayable.toArray();
            }
            return new Object[0];
        }
    }
}

