/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.projectconfig.ExclusionPredicate;
import org.eclipse.oomph.projectconfig.InclusionPredicate;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ProjectConfigPlugin;
import org.eclipse.oomph.projectconfig.util.Messages;

public class ProjectConfigValidator
extends EObjectValidator {
    public static final ProjectConfigValidator INSTANCE = new ProjectConfigValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.oomph.projectconfig";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private static final Object OVERLAPPING_PROFILES_KEY = new Object();

    protected EPackage getEPackage() {
        return ProjectConfigPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateWorkspaceConfiguration((WorkspaceConfiguration)value, diagnostics, context);
            }
            case 1: {
                return this.validateProject((Project)value, diagnostics, context);
            }
            case 2: {
                return this.validatePreferenceProfile((PreferenceProfile)value, diagnostics, context);
            }
            case 3: {
                return this.validatePreferenceFilter((PreferenceFilter)value, diagnostics, context);
            }
            case 4: {
                return this.validateInclusionPredicate((InclusionPredicate)value, diagnostics, context);
            }
            case 5: {
                return this.validateExclusionPredicate((ExclusionPredicate)value, diagnostics, context);
            }
            case 6: {
                return this.validatePattern((Pattern)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)workspaceConfiguration, diagnostics, context);
    }

    public boolean validateProject(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)project, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)project, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProject_AllPreferencesManaged(project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProject_PreferenceProfileReferencesSpecifyUniqueProperties(project, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProject_AllPropertiesHaveManagedValue(project, diagnostics, context);
        }
        return result;
    }

    static Map<PreferenceNode, Set<Property>> collectUnmanagedPreferences(Project project) {
        LinkedHashMap<PreferenceNode, Set<Property>> result = new LinkedHashMap<PreferenceNode, Set<Property>>();
        PreferenceNode projectPreferenceNode = project.getPreferenceNode();
        if (projectPreferenceNode != null) {
            ProjectConfigValidator.collectPreferenceNodes(project.getConfiguration(), result, (List<PreferenceNode>)projectPreferenceNode.getChildren());
            result.remove(projectPreferenceNode.getNode(DIAGNOSTIC_SOURCE));
            for (PreferenceProfile preferenceProfile : project.getPreferenceProfiles()) {
                for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                    Set properties;
                    PreferenceNode preferenceNode = preferenceFilter.getPreferenceNode();
                    if (preferenceNode == null || (properties = (Set)result.get(preferenceNode)) == null) continue;
                    Iterator it = properties.iterator();
                    while (it.hasNext()) {
                        if (!preferenceFilter.matches(((Property)it.next()).getName())) continue;
                        it.remove();
                    }
                    if (!properties.isEmpty()) continue;
                    result.remove(preferenceNode);
                }
            }
            for (PreferenceProfile preferenceProfile : project.getPreferenceProfileReferences()) {
                PreferenceNode otherProjectPreferenceNode = preferenceProfile.getProject().getPreferenceNode();
                for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                    PreferenceNode referencedPreferenceNode = preferenceFilter.getPreferenceNode();
                    if (referencedPreferenceNode == null) continue;
                    Set properties = null;
                    PreferenceNode preferenceNode = null;
                    block5: for (Map.Entry entry : result.entrySet()) {
                        PreferenceNode targetPreferenceNode = (PreferenceNode)entry.getKey();
                        for (PreferenceNode otherPreferenceNode = referencedPreferenceNode; targetPreferenceNode.getName().equals(otherPreferenceNode.getName()) && targetPreferenceNode != projectPreferenceNode && otherPreferenceNode != otherProjectPreferenceNode; targetPreferenceNode = targetPreferenceNode.getParent(), otherPreferenceNode = otherPreferenceNode.getParent()) {
                            if (targetPreferenceNode != projectPreferenceNode || otherPreferenceNode != otherProjectPreferenceNode) continue;
                            preferenceNode = (PreferenceNode)entry.getKey();
                            properties = (Set)entry.getValue();
                            break block5;
                        }
                    }
                    if (properties == null) continue;
                    Iterator it = properties.iterator();
                    while (it.hasNext()) {
                        String name = ((Property)it.next()).getName();
                        if (!preferenceFilter.matches(name) || referencedPreferenceNode.getProperty(name) == null) continue;
                        it.remove();
                    }
                    if (!properties.isEmpty()) continue;
                    result.remove(preferenceNode);
                }
            }
        }
        return result;
    }

    private static void collectPreferenceNodes(WorkspaceConfiguration workspaceConfiguration, Map<PreferenceNode, Set<Property>> result, List<PreferenceNode> preferenceNodes) {
        for (PreferenceNode child : preferenceNodes) {
            EList properties = child.getProperties();
            if (!properties.isEmpty()) {
                LinkedHashSet propertySet = new LinkedHashSet(properties);
                result.put(child, propertySet);
            }
            ProjectConfigValidator.collectPreferenceNodes(workspaceConfiguration, result, (List<PreferenceNode>)child.getChildren());
        }
    }

    private static String getObjectLabel(Collection<? extends EObject> eObjects, Map<Object, Object> context) {
        StringBuilder result = new StringBuilder();
        ArrayList<? extends EObject> values = new ArrayList<EObject>(eObjects);
        int i = 0;
        int size = values.size();
        while (i < size) {
            if (i == size - 1 && size > 1) {
                result.append(Messages.ProjectConfigValidator_And);
            } else if (i != 0) {
                result.append(", ");
            }
            result.append(ProjectConfigValidator.getObjectLabel((EObject)((EObject)values.get(i)), context));
            ++i;
        }
        return result.toString();
    }

    public boolean validateProject_AllPreferencesManaged(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Map<PreferenceNode, Set<Property>> unmanagedPreferences = ProjectConfigValidator.collectUnmanagedPreferences(project);
        if (!unmanagedPreferences.isEmpty()) {
            if (diagnostics != null) {
                PreferenceNode projectPreferenceNode = project.getPreferenceNode();
                StringBuilder substitution = new StringBuilder();
                ArrayList<PreferenceNode> preferenceNodes = new ArrayList<PreferenceNode>(unmanagedPreferences.keySet());
                int i = 0;
                int size = preferenceNodes.size();
                while (i < size) {
                    if (i == size - 1 && size > 1) {
                        substitution.append(Messages.ProjectConfigValidator_And);
                    } else if (i != 0) {
                        substitution.append(", ");
                    }
                    int index = substitution.length();
                    int count = 0;
                    PreferenceNode preferenceNode = (PreferenceNode)preferenceNodes.get(i);
                    while (preferenceNode != projectPreferenceNode) {
                        if (count++ > 0) {
                            substitution.insert(index, "/");
                        }
                        substitution.insert(index, ProjectConfigValidator.getObjectLabel((EObject)preferenceNode, context));
                        preferenceNode = preferenceNode.getParent();
                    }
                    ++i;
                }
                ArrayList<Project> data = new ArrayList<Project>();
                data.add(project);
                data.add((Project)ProjectConfigPackage.Literals.PROJECT__PREFERENCE_PROFILE_REFERENCES);
                data.addAll(preferenceNodes);
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_AllPreferencesManaged_diagnostic", new Object[]{substitution}, data.toArray(), context));
                for (Map.Entry<PreferenceNode, Set<Property>> entry : unmanagedPreferences.entrySet()) {
                    for (Property property : entry.getValue()) {
                        diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_UnmanagedProperty_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)property, context)}, new Object[]{property, project}, context));
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static final Map<PreferenceProfile, Map<PreferenceProfile, Set<Property>>> getOverlaps(Map<Object, Object> context, boolean demandCreate) {
        HashMap overlappingProfiles = (HashMap)context.get(OVERLAPPING_PROFILES_KEY);
        if (overlappingProfiles == null) {
            overlappingProfiles = new HashMap();
            context.put(OVERLAPPING_PROFILES_KEY, overlappingProfiles);
        }
        return overlappingProfiles;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateProject_PreferenceProfileReferencesSpecifyUniqueProperties(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        try {
            keyToPropertiesMap = new HashMap<URI, HashSet<Property>>();
            propertyToPreferenceProfileMap = new HashMap<Property, LinkedHashSet<PreferenceProfile>>();
            preferenceProfileToPropertyMap = new LinkedHashMap<PreferenceProfile, LinkedHashSet<E>>();
            preferenceProfileReferences = new LinkedHashSet<PreferenceProfile>((Collection<PreferenceProfile>)project.getPreferenceProfileReferences());
            preferenceProfileReferences.addAll((Collection<PreferenceProfile>)project.getPreferenceProfiles());
            for (PreferenceProfile preferenceProfile : preferenceProfileReferences) {
                preferenceProfileProperties = (LinkedHashSet<Property>)preferenceProfileToPropertyMap.get(preferenceProfile);
                if (preferenceProfileProperties == null) {
                    preferenceProfileProperties = new LinkedHashSet<Property>();
                    preferenceProfileToPropertyMap.put(preferenceProfile, preferenceProfileProperties);
                }
                for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                    for (Property property : preferenceFilter.getProperties()) {
                        preferenceProfileProperties.add(property);
                        preferenceProfiles = (LinkedHashSet<PreferenceProfile>)propertyToPreferenceProfileMap.get(property);
                        if (preferenceProfiles == null) {
                            preferenceProfiles = new LinkedHashSet<PreferenceProfile>();
                            propertyToPreferenceProfileMap.put(property, preferenceProfiles);
                        }
                        preferenceProfiles.add(preferenceProfile);
                        relativePath = property.getRelativePath();
                        properties = (HashSet<Property>)keyToPropertiesMap.get(relativePath);
                        if (properties == null) {
                            properties = new HashSet<Property>();
                            keyToPropertiesMap.put(relativePath, properties);
                        }
                        properties.add(property);
                    }
                }
            }
            it = keyToPropertiesMap.entrySet().iterator();
            while (it.hasNext()) {
                properties = (Set)it.next().getValue();
                if (properties.size() <= 1) {
                    it.remove();
                    continue;
                }
                preferencesProfiles = new LinkedHashSet<E>();
                for (Property property : properties) {
                    preferencesProfiles.addAll((Collection)propertyToPreferenceProfileMap.get(property));
                }
                overlaps = ProjectConfigValidator.getOverlaps(context, true);
                for (PreferenceProfile preferenceProfile : preferencesProfiles) {
                    profileProperties = overlaps.get(preferenceProfile);
                    if (profileProperties == null) {
                        profileProperties = new LinkedHashMap<PreferenceProfile, Set<Property>>();
                        overlaps.put(preferenceProfile, profileProperties);
                    }
                    for (PreferenceProfile otherPreferenceProfile : preferencesProfiles) {
                        if (otherPreferenceProfile == preferenceProfile) continue;
                        otherProperties = profileProperties.get(otherPreferenceProfile);
                        if (otherProperties == null) {
                            otherProperties = new LinkedHashSet<Property>();
                            profileProperties.put(otherPreferenceProfile, otherProperties);
                        }
                        otherProperties.addAll(properties);
                        otherProperties.retainAll((Collection)preferenceProfileToPropertyMap.get(otherPreferenceProfile));
                    }
                }
                for (Property property : properties) {
                    otherProperties = new LinkedHashSet<E>(properties);
                    otherProperties.remove(property);
                    data = new ArrayList<Object>(otherProperties);
                    data.add(0, property);
                    data.add(1, project);
                    data.addAll(2, preferencesProfiles);
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.oomph.projectconfig", 0, "_UI_NonUniquePropertyApplication_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)property, context), ProjectConfigValidator.getObjectLabel(preferencesProfiles, context), ProjectConfigValidator.getObjectLabel((EObject)project, context), ProjectConfigValidator.getObjectLabel(otherProperties, context)}, data.toArray(), context));
                }
            }
            var19_18 = keyToPropertiesMap.isEmpty();
            return var19_18;
        }
        finally {
            projects = project.getConfiguration().getProjects();
            if (projects.indexOf((Object)project) != projects.size() - 1) return var19_18;
            overlaps = ProjectConfigValidator.getOverlaps(context, false);
            if (overlaps == null) return var19_18;
            ** for (entry : overlaps.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            key = entry.getKey();
            value = entry.getValue();
            data = new LinkedHashSet<PreferenceProfile>();
            data.add(key);
            data.addAll(value.keySet());
            diagnostic = this.createDiagnostic(4, "org.eclipse.oomph.projectconfig", 0, "_UI_OverlappingPreferenceProfile_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)key, context), ProjectConfigValidator.getObjectLabel(value.keySet(), context)}, data.toArray(), context);
            referentProjects = new ArrayList<Project>((Collection<Project>)key.getReferentProjects());
            referentProjects.add(key.getProject());
            for (Map.Entry<PreferenceProfile, Set<Property>> propertyEntry : value.entrySet()) {
                data2 = new LinkedHashSet<Object>();
                data2.add(key);
                otherPreferenceProfile = propertyEntry.getKey();
                otherReferentProjects = new LinkedHashSet<Project>((Collection<Project>)otherPreferenceProfile.getReferentProjects());
                otherReferentProjects.add(otherPreferenceProfile.getProject());
                otherReferentProjects.retainAll(referentProjects);
                data2.add(otherPreferenceProfile);
                data2.addAll(otherReferentProjects);
                data2.addAll((Collection)propertyEntry.getValue());
                diagnostic2 = this.createDiagnostic(4, "org.eclipse.oomph.projectconfig", 0, "_UI_OverlappingPreferenceProfileProperty_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)otherPreferenceProfile, context), ProjectConfigValidator.getObjectLabel(otherReferentProjects, context)}, data2.toArray(), context);
                diagnostic.add((Diagnostic)diagnostic2);
            }
            diagnostics.add((Diagnostic)diagnostic);
            continue;
        }
lbl119:
        // 1 sources

        return var19_18;
    }

    static Map<PreferenceNode, Map<Property, Property>> collectInconsistentPreferences(Project project) {
        LinkedHashMap<PreferenceNode, Map<Property, Property>> result = new LinkedHashMap<PreferenceNode, Map<Property, Property>>();
        ProjectConfigValidator.collectInconsistentPreferences(result, project.getConfiguration(), project, project.getPreferenceNode());
        return result;
    }

    static void collectInconsistentPreferences(Map<PreferenceNode, Map<Property, Property>> result, WorkspaceConfiguration workspaceConfiguration, Project project, PreferenceNode preferenceNode) {
        LinkedHashMap<Property, Property> propertyMap = null;
        for (Property property : preferenceNode.getProperties()) {
            String value = property.getValue();
            Property managingProperty = project.getProperty(property.getRelativePath());
            if (managingProperty == null || managingProperty == property) continue;
            String managingValue = managingProperty.getValue();
            if (!(value == null ? managingValue != null : !value.equals(managingValue))) continue;
            if (propertyMap == null) {
                propertyMap = new LinkedHashMap<Property, Property>();
                result.put(preferenceNode, propertyMap);
            }
            propertyMap.put(property, managingProperty);
        }
        for (PreferenceNode childPreferenceNode : preferenceNode.getChildren()) {
            ProjectConfigValidator.collectInconsistentPreferences(result, workspaceConfiguration, project, childPreferenceNode);
        }
    }

    public boolean validateProject_AllPropertiesHaveManagedValue(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Map<PreferenceNode, Map<Property, Property>> inconsistentPreferences = ProjectConfigValidator.collectInconsistentPreferences(project);
        if (!inconsistentPreferences.isEmpty()) {
            for (Map.Entry<PreferenceNode, Map<Property, Property>> entry : inconsistentPreferences.entrySet()) {
                for (Map.Entry<Property, Property> propertyEntry : entry.getValue().entrySet()) {
                    Property managedProperty = propertyEntry.getKey();
                    Property managingProperty = propertyEntry.getValue();
                    diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_InconsistentPropertyValue_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)managedProperty, context), PreferencesFactory.eINSTANCE.createEscapedString(managedProperty.getValue()), ProjectConfigValidator.getObjectLabel((EObject)managingProperty, context), PreferencesFactory.eINSTANCE.createEscapedString(managingProperty.getValue())}, new Object[]{managedProperty, managingProperty}, context));
                    diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_InconsistentPropertyValue_diagnostic", new Object[]{ProjectConfigValidator.getObjectLabel((EObject)managedProperty, context), PreferencesFactory.eINSTANCE.createEscapedString(managedProperty.getValue()), ProjectConfigValidator.getObjectLabel((EObject)managingProperty, context), PreferencesFactory.eINSTANCE.createEscapedString(managingProperty.getValue())}, new Object[]{project, managedProperty, managingProperty}, context));
                }
            }
            return false;
        }
        return true;
    }

    public boolean validatePreferenceProfile(PreferenceProfile preferenceProfile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)preferenceProfile, diagnostics, context);
    }

    public boolean validatePreferenceFilter(PreferenceFilter preferenceFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)preferenceFilter, diagnostics, context);
    }

    public boolean validateInclusionPredicate(InclusionPredicate inclusionPredicate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)inclusionPredicate, diagnostics, context);
    }

    public boolean validateExclusionPredicate(ExclusionPredicate exclusionPredicate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)exclusionPredicate, diagnostics, context);
    }

    public boolean validatePattern(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigPlugin.INSTANCE;
    }
}

