/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;
import org.eclipse.mat.hprof.acquire.LocalJavaProcessesUtils;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__1")
public class JMapHeapDumpProvider
implements IHeapDumpProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.hprof";
    private static final String LAST_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJDKDir";
    private static final String LAST_JMAP_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJmapJDKDir";
    static final String FILE_PATTERN = "java_pid{1,number,0}.{2,number,0000}.hprof";
    static final String FILE_GZ_PATTERN = "java_pid{1,number,0}.{2,number,0000}.hprof.gz";
    private int lastCount = 20;
    @Argument(isMandatory=false, advice=Argument.Advice.DIRECTORY)
    public File jdkHome = this.readSavedLocation(LAST_JDK_DIRECTORY_KEY);
    @Argument(isMandatory=false, advice=Argument.Advice.DIRECTORY)
    public List<File> jdkList;
    @Argument(isMandatory=false)
    public boolean defaultCompress;
    @Argument(isMandatory=false)
    public boolean defaultChunked = true;
    @Argument(isMandatory=false)
    public boolean defaultLive = true;
    private static final String[] modules = new String[]{"jcmd", "jcmd.exe", "jps", "jps.exe"};

    public JMapHeapDumpProvider() {
        if (this.jdkHome == null) {
            this.jdkHome = this.guessJDKFromJDT();
        } else {
            this.guessJDKFromJDT();
        }
        if (this.jdkHome == null) {
            this.jdkHome = this.guessJDK();
        } else {
            this.guessJDK();
        }
        if (this.jdkHome == null) {
            this.jdkHome = this.guessJDKFromPath();
        } else {
            this.guessJDKFromPath();
        }
    }

    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        JmapVmInfo jmapProcessInfo = info instanceof JmapVmInfo ? (JmapVmInfo)info : new JmapVmInfo(info.getPid(), info.getDescription(), info.isHeapDumpEnabled(), info.getProposedFileName(), info.getHeapDumpProvider());
        listener.beginTask(Messages.JMapHeapDumpProvider_WaitForHeapDump, -1);
        boolean remoteGz = jmapProcessInfo.compress && jmapProcessInfo.chunked;
        boolean useJcmd = true;
        while (true) {
            String[] execLine;
            String[] jmapmodules = new String[]{"jmap", "jmap.exe"};
            String[] jcmdmodules = new String[]{"jcmd", "jcmd.exe"};
            File jmapf = null;
            if (useJcmd) {
                jmapf = this.fullCmdName(jmapProcessInfo, jcmdmodules);
            }
            if (jmapf == null && (jmapf = this.fullCmdName(jmapProcessInfo, jmapmodules)) != null) {
                useJcmd = false;
            }
            String jmap = jmapf != null ? jmapf.getPath() : (useJcmd ? "jcmd" : "jmap");
            if (useJcmd) {
                ArrayList<String> execLine1 = new ArrayList<String>();
                execLine1.add(jmap);
                execLine1.add(String.valueOf(info.getPid()));
                execLine1.add("GC.heap_dump");
                if (!jmapProcessInfo.live) {
                    execLine1.add("-all");
                }
                if (remoteGz) {
                    execLine1.add("-gz=1");
                }
                execLine1.add(preferredLocation.getAbsolutePath());
                execLine = execLine1.toArray(new String[execLine1.size()]);
            } else {
                String option = "-dump:format=b";
                if (jmapProcessInfo.live) {
                    option = String.valueOf(option) + ",live";
                }
                if (remoteGz) {
                    option = String.valueOf(option) + ",gz=1";
                }
                option = String.valueOf(option) + ",file=";
                option = String.valueOf(option) + preferredLocation.getAbsolutePath();
                execLine = new String[]{jmap, option, String.valueOf(info.getPid())};
            }
            listener.subTask(jmap);
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Executing { ");
            int i = 0;
            while (i < execLine.length) {
                logMessage.append("\"").append(execLine[i]).append("\"");
                if (i < execLine.length - 1) {
                    logMessage.append(", ");
                }
                ++i;
            }
            logMessage.append(" }");
            Logger.getLogger(this.getClass().getName()).info(logMessage.toString());
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(execLine);
                LocalJavaProcessesUtils.StreamCollector error = new LocalJavaProcessesUtils.StreamCollector(p.getErrorStream());
                error.start();
                LocalJavaProcessesUtils.StreamCollector output = new LocalJavaProcessesUtils.StreamCollector(p.getInputStream());
                output.start();
                if (listener.isCanceled()) {
                    return null;
                }
                int exitCode = p.waitFor();
                if (!preferredLocation.exists() && (exitCode != 0 || error.buf.length() > 0 || output.buf.toString().startsWith("Error"))) {
                    if (remoteGz) {
                        remoteGz = false;
                        continue;
                    }
                    if (useJcmd) {
                        useJcmd = false;
                        continue;
                    }
                }
                try {
                    if (exitCode != 0) {
                        throw new SnapshotException(MessageUtil.format((String)Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Object[])new Object[]{exitCode, error.buf.toString(), jmap}));
                    }
                    if (preferredLocation.exists()) break;
                    throw new SnapshotException(MessageUtil.format((String)Messages.JMapHeapDumpProvider_HeapDumpNotCreated, (Object[])new Object[]{exitCode, output.buf.toString(), error.buf.toString(), jmap}));
                }
                catch (IOException ioe) {
                    throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ioe);
                }
                catch (InterruptedException ie) {
                    throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ie);
                }
            }
            finally {
                if (p == null) continue;
                p.destroy();
                continue;
            }
            break;
        }
        if (jmapProcessInfo.compress && !remoteGz) {
            try {
                preferredLocation = this.compressFile(preferredLocation, jmapProcessInfo.chunked, listener);
            }
            catch (IOException e) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)e);
            }
        }
        listener.done();
        return preferredLocation;
    }

    private File fullCmdName(JmapVmInfo jmapProcessInfo, String[] modules) {
        File jmap = null;
        if (jmapProcessInfo.jdkHome != null && jmapProcessInfo.jdkHome.exists()) {
            String[] stringArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String mod = stringArray[n2];
                File mod1 = new File(jmapProcessInfo.jdkHome.getAbsoluteFile(), "bin");
                if ((mod1 = new File(mod1, mod)).canExecute()) {
                    jmap = mod1.getAbsoluteFile();
                    this.persistJDKLocation(LAST_JMAP_JDK_DIRECTORY_KEY, jmapProcessInfo.jdkHome.getAbsolutePath());
                    break;
                }
                ++n2;
            }
        }
        return jmap;
    }

    /*
     * Exception decompiling
     */
    File compressFile(File dump, boolean chunked, IProgressListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<JmapVmInfo> getAvailableVMs(IProgressListener listener) throws SnapshotException {
        listener.beginTask(Messages.JMapHeapDumpProvider_ListProcesses, this.lastCount);
        if (this.jdkList == null || this.jdkList.isEmpty()) {
            this.guessJDKFromJDT();
            this.guessJDK();
            this.guessJDKFromPath();
            if (this.jdkHome == null && this.jdkList != null && !this.jdkList.isEmpty()) {
                this.jdkHome = this.jdkList.get(0);
            }
        }
        if (this.jdkHome != null && this.jdkHome.exists()) {
            File old = this.readSavedLocation(LAST_JDK_DIRECTORY_KEY);
            if (old == null || !this.jdkHome.getAbsoluteFile().equals(old)) {
                this.persistJDKLocation(LAST_JMAP_JDK_DIRECTORY_KEY, null);
            }
            this.persistJDKLocation(LAST_JDK_DIRECTORY_KEY, this.jdkHome.getAbsolutePath());
        }
        ArrayList<JmapVmInfo> result = new ArrayList<JmapVmInfo>();
        List<JmapVmInfo> jvms = LocalJavaProcessesUtils.getLocalVMsUsingJPS(this.jdkHome, listener);
        if (jvms != null) {
            File jmapJdkHome;
            this.lastCount = jvms.size();
            if (this.jdkHome == null) {
                this.persistJDKLocation(LAST_JDK_DIRECTORY_KEY, null);
            }
            if ((jmapJdkHome = this.readSavedLocation(LAST_JMAP_JDK_DIRECTORY_KEY)) == null) {
                jmapJdkHome = this.jdkHome;
            }
            for (JmapVmInfo vmInfo : jvms) {
                vmInfo.setHeapDumpProvider(this);
                vmInfo.jdkHome = jmapJdkHome;
                vmInfo.compress = this.defaultCompress;
                vmInfo.chunked = this.defaultChunked;
                vmInfo.live = this.defaultLive;
                result.add(vmInfo);
            }
        }
        listener.done();
        return result;
    }

    private void persistJDKLocation(String key, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        if (value == null) {
            prefs.remove(key);
        } else {
            prefs.put(key, value);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private File readSavedLocation(String key) {
        String lastDir = Platform.getPreferencesService().getString(PLUGIN_ID, key, "", null);
        if (lastDir != null && !lastDir.trim().equals("")) {
            return new File(lastDir);
        }
        return null;
    }

    private File guessJDKFromJDT() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
        if (prefs == null) {
            return null;
        }
        String s1 = prefs.get("org.eclipse.jdt.launching.PREF_VM_XML", null);
        if (s1 == null) {
            return null;
        }
        try {
            List<File> paths = JMapHeapDumpProvider.parseJDTvmSettings(s1);
            this.jdkList = paths;
            if (paths.size() >= 1) {
                return paths.get(0);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private File guessJDK() {
        File[] folders;
        String javaHomeProperty = System.getProperty("java.home");
        folders = new File[]{new File(javaHomeProperty), folders[0].getParentFile()};
        File[] fileArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File parentFolder = fileArray[n2];
            File binDir = new File(parentFolder, "bin");
            if (binDir.exists()) {
                String[] stringArray = modules;
                int n3 = modules.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mod = stringArray[n4];
                    File dll = new File(binDir, mod);
                    if (dll.canExecute()) {
                        if (this.jdkList != null && !this.jdkList.contains(parentFolder)) {
                            this.jdkList.add(parentFolder);
                        }
                        return parentFolder;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private File guessJDKFromPath() {
        File jdkHome = null;
        String path = System.getenv("PATH");
        if (path != null) {
            String[] stringArray = path.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                File dir = new File(p);
                File parentDir = dir.getParentFile();
                String[] stringArray2 = modules;
                int n3 = modules.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mod = stringArray2[n4];
                    File dll = new File(dir, mod);
                    if (dll.canExecute() && parentDir != null && parentDir.getName().equals("bin")) {
                        File home = parentDir.getParentFile();
                        if (jdkHome == null) {
                            jdkHome = home;
                        }
                        if (this.jdkList != null && !this.jdkList.contains(home)) {
                            this.jdkList.add(home);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return jdkHome;
    }

    private static final List<File> parseJDTvmSettings(String input) throws IOException {
        try {
            JDTLaunchingSAXHandler handler = new JDTLaunchingSAXHandler();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxXmlReader = parser.getXMLReader();
            saxXmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxXmlReader.setContentHandler(handler);
            saxXmlReader.setErrorHandler(handler);
            saxXmlReader.parse(new InputSource(new StringReader(input)));
            ArrayList<File> homes = new ArrayList<File>();
            block3: for (String home : handler.getJavaHome()) {
                File homedir = new File(home);
                File dir = new File(homedir, "bin");
                if (!dir.exists()) continue;
                String[] stringArray = modules;
                int n = modules.length;
                int n2 = 0;
                while (n2 < n) {
                    String mod = stringArray[n2];
                    File jps = new File(dir, mod);
                    if (jps.canExecute()) {
                        homes.add(homedir);
                        continue block3;
                    }
                    ++n2;
                }
            }
            return homes;
        }
        catch (SAXException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static class JDTLaunchingSAXHandler
    extends DefaultHandler {
        List<String> javaHomes = new ArrayList<String>();
        private String defVM;
        private String type;

        private JDTLaunchingSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("vmSettings")) {
                String[] s;
                String settings = attributes.getValue("defaultVM");
                if (settings != null && (s = settings.split(",")).length >= 3) {
                    this.defVM = s[2];
                }
            } else if (name.equals("vmType")) {
                this.type = attributes.getValue("id");
            } else if (name.equals("vm") && "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(this.type)) {
                String id = attributes.getValue("id");
                String path = attributes.getValue("path");
                if (path != null) {
                    if (id != null && id.equals(this.defVM)) {
                        this.javaHomes.add(0, path);
                    } else {
                        this.javaHomes.add(path);
                    }
                }
            }
        }

        public List<String> getJavaHome() {
            return this.javaHomes;
        }
    }
}

