/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class SpecfileDocumentProvider
extends TextFileDocumentProvider {
    private int originalLength;

    private void setDocumentLength(Object element) {
        IDocument doc = this.getDocument(element);
        this.originalLength = doc == null ? 0 : doc.getLength();
    }

    public IDocument getDocument(Object element) {
        IDocument document = super.getDocument(element);
        if (document != null && document.getDocumentPartitioner() == null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SpecfilePartitionScanner(), SpecfilePartitionScanner.SPEC_PARTITION_TYPES);
            partitioner.connect(document, false);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        this.setDocumentLength(element);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canSaveDocument(Object element) {
        void fei;
        Object object = element;
        if (!(object instanceof FileStoreEditorInput)) return super.canSaveDocument(element);
        FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
        if (fileStoreEditorInput != (FileStoreEditorInput)object) return super.canSaveDocument(element);
        IDocument doc = this.getDocument(element);
        if (!super.canSaveDocument(element)) {
            return false;
        }
        if (doc.getLength() != this.originalLength) {
            return true;
        }
        URI uri = fei.getURI();
        File f = URIUtil.toFile((URI)uri);
        if (this.originalLength == 0) return super.canSaveDocument(element);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (BufferedReader input = new BufferedReader(new FileReader(f));){
                int len;
                boolean finished = false;
                char[] buffer = new char[100];
                int curoffset = 0;
                while (!finished && (len = input.read(buffer)) > 0) {
                    String origbytes = new String(buffer, 0, len);
                    String curbytes = doc.get(curoffset, len);
                    if (!curbytes.equals(origbytes)) {
                        return true;
                    }
                    curoffset += len;
                }
                this.resetDocument(element);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | CoreException | BadLocationException e) {
            return true;
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.DocumentProviderOperation saveOperation = super.createSaveOperation(element, document, overwrite);
        if (element instanceof IURIEditorInput) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                public void execute(IProgressMonitor monitor) {
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    saveOperation.run(monitor);
                    SpecfileDocumentProvider.this.setDocumentLength(element);
                }

                public ISchedulingRule getSchedulingRule() {
                    return saveOperation.getSchedulingRule();
                }
            };
        }
        return saveOperation;
    }
}

