/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui;

import org.eclipse.cdt.visualizer.ui.IVisualizer;
import org.eclipse.cdt.visualizer.ui.IVisualizerViewer;
import org.eclipse.cdt.visualizer.ui.util.SelectionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class Visualizer
implements IVisualizer,
ISelectionChangedListener {
    protected String m_name;
    protected String m_displayName;
    protected String m_description;
    protected IVisualizerViewer m_viewer;
    protected Control m_control;
    protected SelectionManager m_selectionManager;

    public Visualizer() {
        this("visualizer", "Visualizer", "Displays graphic representation of selection.");
    }

    public Visualizer(String name, String displayName, String description) {
        this.setName(name);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.m_selectionManager = new SelectionManager(this, "Visualizer selection manager");
    }

    public void dispose() {
        this.m_name = null;
        this.m_displayName = null;
        this.m_description = null;
        this.disposeControl();
        this.m_viewer = null;
        if (this.m_selectionManager != null) {
            this.m_selectionManager.dispose();
            this.m_selectionManager = null;
        }
    }

    @Override
    public void initializeVisualizer() {
    }

    @Override
    public void disposeVisualizer() {
        this.dispose();
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setViewer(IVisualizerViewer viewer) {
        this.m_viewer = viewer;
    }

    @Override
    public IVisualizerViewer getViewer() {
        return this.m_viewer;
    }

    @Override
    public void visualizerSelected() {
    }

    @Override
    public void visualizerDeselected() {
    }

    @Override
    public abstract Control createControl(Composite var1);

    public abstract void disposeControl();

    protected void setControl(Control control) {
        this.m_control = control;
    }

    @Override
    public Control getControl() {
        return this.m_control;
    }

    @Override
    public void populateToolBar(IToolBarManager toolBarManager) {
    }

    @Override
    public void populateMenu(IMenuManager menuManager) {
    }

    @Override
    public void populateContextMenu(IMenuManager menuManager) {
    }

    @Override
    public int handlesSelection(ISelection selection) {
        return 0;
    }

    @Override
    public void workbenchSelectionChanged(ISelection selection) {
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionManager.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionManager.removeSelectionChangedListener(listener);
    }

    public void raiseSelectionChangedEvent() {
        this.m_selectionManager.raiseSelectionChangedEvent();
    }

    @Override
    public ISelection getSelection() {
        return this.m_selectionManager.getSelection();
    }

    @Override
    public void setSelection(ISelection selection) {
        this.m_selectionManager.setSelection(selection);
    }

    public void setSelection(ISelection selection, boolean raiseEvent) {
        this.m_selectionManager.setSelection(selection, raiseEvent);
    }

    public boolean hasSelection() {
        return this.m_selectionManager.hasSelection();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }
}

