/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ComboControlledStackComposite
extends Composite {
    private Composite fArea;
    private Combo fCombo;
    private Map<String, Composite> tabMap = new LinkedHashMap<String, Composite>();
    private StackLayout layout;
    private Label fLabel;

    public ComboControlledStackComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.createContents(this);
    }

    public void setLabelText(String label) {
        this.fLabel.setText(label);
    }

    public void addItem(String label, Composite tab) {
        this.tabMap.put(label, tab);
        this.fCombo.add(label);
        if (this.layout.topControl == null) {
            this.layout.topControl = tab;
            this.fCombo.setText(label);
        }
    }

    public void deleteItem(String label) {
        Composite tab;
        if (this.fCombo.getText().equals(label)) {
            this.setSelection(this.fCombo.getItem(0));
        }
        if ((tab = this.tabMap.get(label)) != null) {
            tab.dispose();
            this.tabMap.remove(label);
        }
    }

    public void setSelection(String label) {
        this.fCombo.setText(label);
        this.setPage(label);
    }

    protected void createContents(Composite parent) {
        this.fLabel = this.createLabel(this);
        this.fCombo = this.createCombo(this);
        GridData cgd = new GridData(768);
        this.fCombo.setLayoutData((Object)cgd);
        this.fArea = this.createTabArea(this);
        GridData agd = new GridData(1808);
        agd.horizontalSpan = 2;
        this.fArea.setLayoutData((Object)agd);
    }

    public Composite getStackParent() {
        return this.fArea;
    }

    public Label getLabel() {
        return this.fLabel;
    }

    public Combo getCombo() {
        return this.fCombo;
    }

    protected Composite createTabArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.layout = new StackLayout();
        comp.setLayout((Layout)this.layout);
        return comp;
    }

    protected Label createLabel(Composite parent) {
        Label label = new Label(parent, 64);
        return label;
    }

    protected Combo createCombo(Composite parent) {
        Combo box = new Combo(parent, 8);
        box.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = ComboControlledStackComposite.this.fCombo.getText();
                ComboControlledStackComposite.this.comboSelected(name);
            }
        });
        return box;
    }

    protected void comboSelected(String label) {
        this.setPage(label);
    }

    protected void setPage(String label) {
        this.layout.topControl = (Control)this.tabMap.get(label);
        this.getStackParent().layout();
    }

    public Control getTopControl() {
        return this.layout != null ? this.layout.topControl : null;
    }
}

