/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.Platform;

public class Msys2ToolChainProvider
implements IToolChainProvider {
    private static final String ID = "org.eclipse.cdt.build.gcc.core.msys2Provider";
    private static final Set<String> MSYS2_64BIT_NAMES = Set.of("MSYS2", "MSYS2 64bit");

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) {
        if (Platform.getOS().equals("win32")) {
            String subkey;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            boolean on64bit = Platform.getOSArch().equals("x86_64");
            String key32bit = null;
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                String compKey = String.valueOf(uninstallKey) + '\\' + subkey;
                String displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                if (on64bit) {
                    if (MSYS2_64BIT_NAMES.contains(displayName)) {
                        if (this.addToolChain64(manager, registry, compKey)) {
                            key32bit = null;
                            break;
                        }
                    } else if ("MSYS2 32bit".equals(displayName)) {
                        key32bit = compKey;
                    }
                } else if ("MSYS2 32bit".equals(displayName) && this.addToolChain32(manager, registry, compKey)) break;
                ++i;
            }
            if (on64bit && key32bit != null) {
                this.addToolChain64(manager, registry, key32bit);
            }
        }
    }

    private boolean addToolChain64(IToolChainManager manager, WindowsRegistry registry, String key) {
        String installLocation = registry.getCurrentUserValue(key, "InstallLocation");
        Path msysPath = Paths.get(installLocation, new String[0]);
        Path gccPath = msysPath.resolve("mingw64\\bin\\gcc.exe");
        if (Files.exists(gccPath, new LinkOption[0])) {
            StringBuilder pathVar = new StringBuilder();
            pathVar.append(msysPath);
            pathVar.append("\\mingw64\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\usr\\local\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\usr\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\bin");
            IEnvironmentVariable[] vars = new IEnvironmentVariable[]{new EnvironmentVariable("PATH", pathVar.toString(), 3, File.pathSeparator)};
            GCCToolChain toolChain = new GCCToolChain((IToolChainProvider)this, gccPath, "x86_64", vars);
            toolChain.setProperty("package", "msys2");
            manager.addToolChain((IToolChain)toolChain);
            return true;
        }
        return this.addToolChain32(manager, registry, key);
    }

    private boolean addToolChain32(IToolChainManager manager, WindowsRegistry registry, String key) {
        String installLocation = registry.getCurrentUserValue(key, "InstallLocation");
        Path msysPath = Paths.get(installLocation, new String[0]);
        Path gccPath = msysPath.resolve("mingw32\\bin\\gcc.exe");
        if (Files.exists(gccPath, new LinkOption[0])) {
            StringBuilder pathVar = new StringBuilder();
            pathVar.append(msysPath);
            pathVar.append("\\mingw32\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\usr\\local\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\usr\\bin");
            pathVar.append(File.pathSeparatorChar);
            pathVar.append(msysPath);
            pathVar.append("\\bin");
            IEnvironmentVariable[] vars = new IEnvironmentVariable[]{new EnvironmentVariable("PATH", pathVar.toString(), 3, File.pathSeparator)};
            GCCToolChain toolChain = new GCCToolChain((IToolChainProvider)this, gccPath, "x86", vars);
            toolChain.setProperty("package", "msys2");
            manager.addToolChain((IToolChain)toolChain);
            return true;
        }
        return false;
    }
}

