/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.factory;

import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.factory.FactoryActionsSupport;
import org.eclipse.wb.internal.core.model.util.factory.FactoryApplyAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class FactorySelectAction
extends Action {
    private final JavaInfo m_component;
    private final AstEditor m_editor;

    public FactorySelectAction(JavaInfo component) {
        this.m_component = component;
        this.m_editor = this.m_component.getEditor();
        this.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/factory/open_factory.gif"));
        this.setText(ModelMessages.FactorySelectAction_text);
    }

    public void run() {
        try {
            Class<?> factoryType = this.selectFactoryType();
            if (factoryType == null) {
                return;
            }
            Map<String, FactoryMethodDescription> descriptionsMap = FactoryDescriptionHelper.getDescriptionsMap(this.m_editor, factoryType, true);
            ListDialog selectionDialog = new ListDialog(DesignerPlugin.getShell());
            selectionDialog.setTitle(ModelMessages.FactorySelectAction_dialogTitle);
            selectionDialog.setMessage(ModelMessages.FactorySelectAction_dialogMessage);
            selectionDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            selectionDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return (String)element;
                }
            });
            selectionDialog.setInput(descriptionsMap.keySet());
            if (!descriptionsMap.isEmpty()) {
                selectionDialog.setInitialSelections(new Object[]{descriptionsMap.keySet().iterator().next()});
            }
            if (selectionDialog.open() == 0 && selectionDialog.getResult().length != 0) {
                FactoryActionsSupport.addPreviousTypeName(this.m_component, factoryType.getName());
                String signature = (String)selectionDialog.getResult()[0];
                FactoryMethodDescription description = descriptionsMap.get(signature);
                new FactoryApplyAction(this.m_component, description).run();
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    private Class<?> selectFactoryType() throws Exception {
        Shell shell = DesignerPlugin.getShell();
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.m_editor.getJavaProject()});
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)2, (boolean)false);
        dialog.setTitle(ModelMessages.FactorySelectAction_chooseTitle);
        dialog.setMessage(ModelMessages.FactorySelectAction_chooseMessage);
        if (dialog.open() != 0) {
            return null;
        }
        IType type = (IType)dialog.getResult()[0];
        String factoryTypeName = type.getFullyQualifiedName().replace('$', '.');
        Class<?> factoryType = EditorState.get(this.m_editor).getEditorLoader().loadClass(factoryTypeName);
        return factoryType;
    }
}

