/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils2;

public final class MethodPropertyPropertyEditor
extends TextDisplayPropertyEditor
implements IComplexPropertyEditor {
    private final String m_text;
    private final List<GenericPropertyDescription> m_descriptions;

    public MethodPropertyPropertyEditor(String text, List<GenericPropertyDescription> descriptions) {
        this.m_text = text;
        this.m_descriptions = descriptions;
    }

    protected String getText(Property property) throws Exception {
        return this.m_text;
    }

    public Property[] getProperties(Property _methodProperty) throws Exception {
        GenericProperty methodProperty = (GenericProperty)_methodProperty;
        Property[] properties = (Property[])methodProperty.getArbitraryValue((Object)this);
        if (properties == null) {
            properties = this.createProperties(methodProperty);
            methodProperty.putArbitraryValue((Object)this, properties);
        }
        return properties;
    }

    private Property[] createProperties(GenericProperty methodProperty) {
        Property[] properties = new Property[this.m_descriptions.size()];
        int propertyIndex = 0;
        for (GenericPropertyDescription description : this.m_descriptions) {
            JavaInfo javaInfo = methodProperty.getJavaInfo();
            properties[propertyIndex++] = PropertyUtils2.createGenericPropertyImpl(javaInfo, description);
        }
        return properties;
    }
}

